/*
 * Decompiled with CFR 0.152.
 */
package simpack.api.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import simpack.api.ITreeAccessor;
import simpack.api.ITreeNode;
import simpack.api.ITreeSequenceAccessor;
import simpack.exception.InvalidElementException;
import simpack.util.tree.comparator.NamedTreeNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeAccessor
implements ITreeAccessor,
ITreeSequenceAccessor {
    protected ITreeNode tree;

    @Override
    public ITreeNode getRoot() {
        return this.tree;
    }

    @Override
    public List<Object> getPreorderSequence() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.preorder(this.getRoot(), arrayList);
        return arrayList;
    }

    @Override
    public List<Object> getPostorderSequence() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.postorder(this.getRoot(), arrayList);
        return arrayList;
    }

    public List<Object> getSequence() {
        return this.getPreorderSequence();
    }

    @Override
    public ITreeNode getMostRecentCommonAncestor(ITreeNode iTreeNode, ITreeNode iTreeNode2) throws InvalidElementException {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        defaultMutableTreeNode = this.getNode(iTreeNode);
        defaultMutableTreeNode2 = this.getNode(iTreeNode2);
        if (defaultMutableTreeNode == null) {
            throw new InvalidElementException("Node " + iTreeNode.toString() + " is invalid");
        }
        if (defaultMutableTreeNode2 == null) {
            throw new InvalidElementException("Node " + iTreeNode2.toString() + " is invalid");
        }
        return (simpack.util.tree.TreeNode)defaultMutableTreeNode.getSharedAncestor(defaultMutableTreeNode2);
    }

    @Override
    public Set<ITreeNode> getDescendants(ITreeNode iTreeNode) throws InvalidElementException {
        TreeSet<ITreeNode> treeSet = new TreeSet<ITreeNode>(new NamedTreeNodeComparator());
        DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(iTreeNode);
        if (defaultMutableTreeNode != null) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.preorderEnumeration();
            enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                treeSet.add(new simpack.util.tree.TreeNode(((DefaultMutableTreeNode)enumeration.nextElement()).toString()));
            }
            return treeSet;
        }
        throw new InvalidElementException("Node " + iTreeNode.toString() + " is invalid");
    }

    @Override
    public Set<ITreeNode> getAncestors(ITreeNode iTreeNode) throws InvalidElementException {
        TreeSet<ITreeNode> treeSet = new TreeSet<ITreeNode>(new NamedTreeNodeComparator());
        DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(iTreeNode);
        if (defaultMutableTreeNode != null) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.pathFromAncestorEnumeration(this.getRoot());
            while (enumeration.hasMoreElements()) {
                treeSet.add(new simpack.util.tree.TreeNode(((DefaultMutableTreeNode)enumeration.nextElement()).toString()));
            }
            treeSet.remove(iTreeNode);
            return treeSet;
        }
        throw new InvalidElementException("Node " + iTreeNode.toString() + " is invalid");
    }

    @Override
    public Set<ITreeNode> getChildren(ITreeNode iTreeNode) throws InvalidElementException {
        TreeSet<ITreeNode> treeSet = new TreeSet<ITreeNode>(new NamedTreeNodeComparator());
        DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(iTreeNode);
        if (defaultMutableTreeNode != null) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                treeSet.add(new simpack.util.tree.TreeNode(((DefaultMutableTreeNode)enumeration.nextElement()).toString()));
            }
            return treeSet;
        }
        throw new InvalidElementException("Node " + iTreeNode.toString() + " is invalid");
    }

    @Override
    public Set<ITreeNode> getParents(ITreeNode iTreeNode) throws InvalidElementException {
        TreeSet<ITreeNode> treeSet = new TreeSet<ITreeNode>(new NamedTreeNodeComparator());
        DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(iTreeNode);
        if (defaultMutableTreeNode != null) {
            treeSet.add(new simpack.util.tree.TreeNode(defaultMutableTreeNode.getParent().toString()));
            return treeSet;
        }
        throw new InvalidElementException("Node " + iTreeNode.toString() + " is invalid");
    }

    @Override
    public boolean contains(ITreeNode iTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(iTreeNode);
        if (defaultMutableTreeNode == null) {
            return false;
        }
        return ((simpack.util.tree.TreeNode)this.tree).isNodeDescendant(defaultMutableTreeNode);
    }

    @Override
    public int size() {
        int n = 0;
        Enumeration<TreeNode> enumeration = ((simpack.util.tree.TreeNode)this.tree).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n;
        }
        return n;
    }

    private final DefaultMutableTreeNode getNode(ITreeNode iTreeNode) {
        Enumeration<TreeNode> enumeration = ((simpack.util.tree.TreeNode)this.tree).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!defaultMutableTreeNode.toString().equals(iTreeNode.getUserObject().toString())) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    private final void preorder(ITreeNode iTreeNode, ArrayList<Object> arrayList) {
        if (iTreeNode != null) {
            arrayList.add(iTreeNode);
            Enumeration<? extends TreeNode> enumeration = iTreeNode.children();
            while (enumeration.hasMoreElements()) {
                ITreeNode iTreeNode2 = (ITreeNode)enumeration.nextElement();
                this.preorder(iTreeNode2, arrayList);
            }
        } else {
            return;
        }
    }

    private final void postorder(ITreeNode iTreeNode, ArrayList<Object> arrayList) {
        if (iTreeNode != null) {
            Enumeration<? extends TreeNode> enumeration = iTreeNode.children();
            while (enumeration.hasMoreElements()) {
                ITreeNode iTreeNode2 = (ITreeNode)enumeration.nextElement();
                this.postorder(iTreeNode2, arrayList);
            }
        } else {
            return;
        }
        arrayList.add(iTreeNode);
    }
}

