/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.graph;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import simpack.accessor.string.StringAccessor;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.api.impl.GraphSimilarityMeasure;
import simpack.api.impl.SimilarityMeasure;
import simpack.measure.sequence.Levenshtein;
import simpack.util.graph.GraphNode;
import simpack.util.graph.GroupNode;
import simpack.util.graph.MappedVertex;
import simpack.util.graph.comparator.MappedVertexComparator;
import simpack.util.graph.comparator.NamedGraphNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphIsomorphism
extends GraphSimilarityMeasure {
    public static Logger logger = Logger.getLogger(GraphIsomorphism.class);
    public static boolean NODE_GROUPING = false;
    public static String DEFAULT_NODE_LABEL_SIMILARITY_MEASURE = "Levenshtein";
    private boolean groupNodes = NODE_GROUPING;
    private String similarityMeasure = DEFAULT_NODE_LABEL_SIMILARITY_MEASURE;
    private TreeSet<IGraphNode> nodeSet1 = new TreeSet();
    private TreeSet<IGraphNode> nodeSet2 = new TreeSet();
    private IGraphNode node1;
    private IGraphNode node2;
    private TreeMap<String, Integer> groupDegreeMap1 = new TreeMap();
    private TreeMap<String, Integer> groupDegreeMap2 = new TreeMap();
    private TreeMap<MappedVertex, TreeSet<MappedVertex>> adjacentMap = new TreeMap(new MappedVertexComparator());
    private ArrayList<MappedVertex> mappedVertexList = new ArrayList();
    private ArrayList<MappedVertex> startCandidateList = new ArrayList();
    private TreeSet<String> cliqueList = new TreeSet();
    private IGraphAccessor graphAccessor1 = null;
    private IGraphAccessor graphAccessor2 = null;
    private int graphSize = 0;
    private double maxSimilarity = 0.0;
    private String maxSimilarityPathWithSimNumber;
    private long startMillis;
    private int countCliq = 0;
    private int countLoop = 0;
    private int countMV = 0;
    private int countLoopAdjacentMap = 0;
    private Timestamp ts;
    private long millis;
    private Calendar eDate;

    public GraphIsomorphism(IGraphAccessor iGraphAccessor, IGraphAccessor iGraphAccessor2) {
        this(iGraphAccessor, iGraphAccessor2, NODE_GROUPING);
    }

    public GraphIsomorphism(IGraphAccessor iGraphAccessor, IGraphAccessor iGraphAccessor2, boolean bl) {
        this.graphAccessor1 = iGraphAccessor;
        this.graphAccessor2 = iGraphAccessor2;
        this.nodeSet1 = iGraphAccessor.getNodeSet();
        this.nodeSet2 = iGraphAccessor2.getNodeSet();
        this.groupNodes = bl;
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        if (this.getGraphIsomorphism() == 1) {
            this.graphSize = this.nodeSet1.size();
            if (this.groupNodes) {
                this.setGroups(this.graphAccessor1, "G1");
                this.setGroups(this.graphAccessor2, "G2");
            }
            this.mapSameDegree();
            TreeSet<MappedVertex> treeSet = new TreeSet<MappedVertex>(new MappedVertexComparator());
            TreeSet<IGraphNode> treeSet2 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
            TreeSet<IGraphNode> treeSet3 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
            TreeSet<MappedVertex> treeSet4 = new TreeSet<MappedVertex>(new MappedVertexComparator());
            this.adjacentMap = this.getAdjacentMap();
            if (logger.isDebugEnabled()) {
                for (IGraphNode iterator2 : this.graphAccessor1.getNodeSet()) {
                    System.out.println("nodeG1: " + iterator2);
                    System.out.println("pre: " + iterator2.getPredecessorSet());
                    System.out.println("suc: " + iterator2.getSuccessorSet());
                }
                for (IGraphNode iGraphNode : this.graphAccessor2.getNodeSet()) {
                    System.out.println("nodeG2: " + iGraphNode);
                    System.out.println("pre: " + iGraphNode.getPredecessorSet());
                    System.out.println("suc: " + iGraphNode.getSuccessorSet());
                }
                Set<MappedVertex> set = this.adjacentMap.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    MappedVertex mappedVertex = (MappedVertex)iterator.next();
                    System.out.println(mappedVertex);
                    if (mappedVertex.isGroup()) {
                        System.out.println("grpsiz " + mappedVertex.getGroupSize() + "  grpsim " + mappedVertex.getGroupSimilarity() + "  Map: " + this.adjacentMap.get(mappedVertex));
                    } else {
                        System.out.println("labelsim " + mappedVertex.getLabelSimilarity() + "  Map: " + this.adjacentMap.get(mappedVertex));
                    }
                    for (MappedVertex mappedVertex2 : this.adjacentMap.get(mappedVertex)) {
                        System.out.println(mappedVertex2 + " sim " + mappedVertex2.getLabelSimilarity());
                    }
                }
            }
            for (MappedVertex mappedVertex : this.startCandidateList) {
                ++this.countMV;
                if (Math.IEEEremainder(this.countMV, 3.0) == 0.0 && logger.isDebugEnabled()) {
                    this.eDate = Calendar.getInstance();
                    this.millis = this.eDate.getTime().getTime();
                    this.ts = new Timestamp(this.millis);
                    System.out.println(this.countMV + ") " + mappedVertex + " " + this.ts + " = " + (this.millis - this.startMillis) / 1000L + " sec");
                }
                treeSet.add(mappedVertex);
                this.nextMaximalClique(treeSet, treeSet2, treeSet3, treeSet4);
            }
            logger.debug((Object)("maxSimilarity: " + this.maxSimilarityPathWithSimNumber));
            this.similarity = this.maxSimilarity;
        } else {
            this.similarity = 0.0;
        }
        this.setCalculated(true);
        return true;
    }

    public int getGraphIsomorphism() {
        if (!this.equalNumberOfVertices()) {
            return 0;
        }
        this.groupDegreeMap1 = this.groupDegree(this.nodeSet1);
        this.groupDegreeMap2 = this.groupDegree(this.nodeSet2);
        while (!this.groupDegreeMap1.isEmpty()) {
            String string = this.groupDegreeMap1.firstKey();
            if (!this.groupDegreeMap2.containsKey(string) || this.groupDegreeMap1.get(string) != this.groupDegreeMap2.get(string)) {
                return 0;
            }
            this.groupDegreeMap1.remove(string);
        }
        return 1;
    }

    public boolean equalNumberOfVertices() {
        return this.nodeSet1.size() == this.nodeSet2.size();
    }

    public TreeMap<String, Integer> groupDegree(TreeSet<IGraphNode> treeSet) {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        for (IGraphNode iGraphNode : treeSet) {
            String string = iGraphNode.getInDegree().toString() + "," + iGraphNode.getOutDegree().toString();
            int n = treeMap.containsKey(string) ? treeMap.get(string) + 1 : 1;
            treeMap.put(string, n);
        }
        return treeMap;
    }

    public void setGroups(IGraphAccessor iGraphAccessor, String string) {
        Integer n = 0;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        for (IGraphNode iGraphNode : iGraphAccessor.getNodeSet()) {
            Object object2;
            logger.debug((Object)("node: " + iGraphNode));
            boolean bl = true;
            if (iGraphNode.getHasGroup() || iGraphNode.getSuccessorSet() == null || iGraphNode.getSuccessorSet().size() <= 1) continue;
            TreeSet<Object> treeSet2 = new TreeSet();
            TreeSet<Object> treeSet3 = new TreeSet();
            TreeSet<IGraphNode> treeSet4 = new TreeSet<IGraphNode>();
            treeSet2 = iGraphNode.getSuccessorSet();
            IGraphNode iGraphNode2 = (IGraphNode)treeSet2.first();
            treeSet3 = iGraphNode2.getPredecessorSet();
            logger.debug((Object)("predecessorSet of 1st successor: " + treeSet3));
            for (Object object2 : treeSet2) {
                if ((object2.getSuccessorSet() == null || object2.getSuccessorSet().size() == 0) && object2.getPredecessorSet().size() == treeSet3.size()) {
                    for (IGraphNode iGraphNode3 : treeSet3) {
                        if (object2.getPredecessorSet().contains(iGraphNode3)) continue;
                        bl = false;
                    }
                    continue;
                }
                bl = false;
            }
            for (Object object2 : treeSet3) {
                if (object2.getSuccessorSet().size() == treeSet2.size()) continue;
                bl = false;
            }
            logger.debug((Object)("is groupable: " + bl));
            if (!bl) continue;
            iGraphNode.setHasGroup();
            Object object3 = n;
            n = n + 1;
            object2 = n;
            object3 = new GroupNode(string.concat("_GROUP_").concat(n.toString()));
            treeSet.add(object3);
            logger.debug((Object)("groupNode: " + ((GraphNode)object3).toString()));
            ((GroupNode)object3).setGroupSize(treeSet2.size());
            for (Object object4 : treeSet2) {
                if (object4.getIsGroup()) continue;
                treeSet4.add((IGraphNode)object4);
            }
            ((GroupNode)object3).setGroupNodes(treeSet4);
            logger.debug((Object)("memberSet: " + treeSet4));
            object2 = treeSet3.iterator();
            while (object2.hasNext()) {
                Object object4;
                object4 = (IGraphNode)object2.next();
                ((GraphNode)object3).addPredecessor((IGraphNode)object4);
                object4.setHasGroup();
                object4.addSuccessor((IGraphNode)object3);
            }
        }
        for (IGraphNode iGraphNode : treeSet) {
            iGraphAccessor.addNode(iGraphNode);
        }
    }

    public void mapSameDegree() {
        for (IGraphNode iGraphNode : this.nodeSet1) {
            for (IGraphNode iGraphNode2 : this.nodeSet2) {
                if (iGraphNode.getIsGroup() != iGraphNode2.getIsGroup() || iGraphNode.getGroupSize() != iGraphNode2.getGroupSize() || iGraphNode.getInDegree() != iGraphNode2.getInDegree() || iGraphNode.getOutDegree() != iGraphNode2.getOutDegree()) continue;
                MappedVertex mappedVertex = new MappedVertex(iGraphNode, iGraphNode2);
                this.mappedVertexList.add(mappedVertex);
                if (iGraphNode.getIsGroup()) {
                    if (iGraphNode.getGroupSize() > iGraphNode2.getGroupSize()) {
                        this.groupSimilarity(mappedVertex, iGraphNode2.getGroupNodes(), iGraphNode.getGroupNodes(), "reverse");
                        continue;
                    }
                    this.groupSimilarity(mappedVertex, iGraphNode.getGroupNodes(), iGraphNode2.getGroupNodes(), "normal");
                    continue;
                }
                if (iGraphNode.getInDegree() == 0) {
                    this.startCandidateList.add(mappedVertex);
                }
                if (this.similarityMeasure.equals("Levenshtein")) {
                    Levenshtein<String> levenshtein = new Levenshtein<String>(new StringAccessor(((Object)iGraphNode).toString()), new StringAccessor(((Object)iGraphNode2).toString()));
                    mappedVertex.setLabelSimilarity(levenshtein.getSimilarity());
                    continue;
                }
                logger.error((Object)"Not yet implemented!");
            }
        }
    }

    public TreeMap<MappedVertex, TreeSet<MappedVertex>> getAdjacentMap() {
        TreeSet<IGraphNode> treeSet = new TreeSet();
        TreeSet<IGraphNode> treeSet2 = new TreeSet();
        TreeSet<IGraphNode> treeSet3 = new TreeSet();
        TreeSet<IGraphNode> treeSet4 = new TreeSet();
        for (MappedVertex mappedVertex : this.mappedVertexList) {
            logger.debug((Object)("mappedVertex: " + mappedVertex));
            ++this.countLoopAdjacentMap;
            if (Math.IEEEremainder(this.countLoopAdjacentMap, 1000.0) == 0.0 && logger.isDebugEnabled()) {
                System.out.println("loop adjacency: " + this.countLoopAdjacentMap + " mv: " + mappedVertex);
            }
            TreeSet<MappedVertex> treeSet5 = new TreeSet<MappedVertex>(new MappedVertexComparator());
            IGraphNode iGraphNode = mappedVertex.getLeftNode();
            IGraphNode iGraphNode2 = mappedVertex.getRightNode();
            treeSet = iGraphNode.getPredecessorSet();
            treeSet2 = iGraphNode2.getPredecessorSet();
            treeSet3 = iGraphNode.getSuccessorSet();
            treeSet4 = iGraphNode2.getSuccessorSet();
            if (logger.isDebugEnabled()) {
                System.out.println("nodes: " + iGraphNode + ", " + iGraphNode2);
                System.out.println("sourceSet1: " + treeSet);
                System.out.println("sourceSet2: " + treeSet2);
                System.out.println("targetSet1: " + treeSet3);
                System.out.println("targetSet2: " + treeSet4);
            }
            if (treeSet != null && treeSet2 != null) {
                treeSet5 = this.adjacentNodes(treeSet5, treeSet, treeSet2);
            }
            if (treeSet3 != null && treeSet4 != null) {
                if (iGraphNode.getHasGroup() && iGraphNode2.getHasGroup()) {
                    logger.debug((Object)"have group!");
                    treeSet5 = this.adjacentGroups(treeSet5, treeSet3, treeSet4);
                } else {
                    treeSet5 = this.adjacentNodes(treeSet5, treeSet3, treeSet4);
                }
            }
            logger.debug((Object)("commonAdjacentSet: " + treeSet5));
            this.adjacentMap.put(mappedVertex, treeSet5);
            if (!logger.isDebugEnabled()) continue;
            for (MappedVertex mappedVertex2 : treeSet5) {
                System.out.println("MV: " + mappedVertex + " " + mappedVertex.isGroup() + " m: " + mappedVertex2 + " " + mappedVertex2.isGroup());
            }
        }
        return this.adjacentMap;
    }

    public TreeSet<MappedVertex> adjacentNodes(TreeSet<MappedVertex> treeSet, TreeSet<IGraphNode> treeSet2, TreeSet<IGraphNode> treeSet3) {
        for (IGraphNode iGraphNode : treeSet2) {
            for (IGraphNode iGraphNode2 : treeSet3) {
                if (iGraphNode.getIsGroup() || iGraphNode2.getIsGroup()) continue;
                MappedVertex mappedVertex = new MappedVertex(iGraphNode, iGraphNode2);
                for (MappedVertex mappedVertex2 : this.mappedVertexList) {
                    if (!mappedVertex.equals(mappedVertex2)) continue;
                    treeSet.add(mappedVertex2);
                }
                if (!logger.isDebugEnabled()) continue;
                System.out.println("mappedVertex: " + mappedVertex);
                System.out.println("equal similarity: " + ((Object)iGraphNode).toString().equals(((Object)iGraphNode2).toString()));
            }
        }
        return treeSet;
    }

    public TreeSet<MappedVertex> adjacentGroups(TreeSet<MappedVertex> treeSet, TreeSet<IGraphNode> treeSet2, TreeSet<IGraphNode> treeSet3) {
        for (IGraphNode iGraphNode : treeSet2) {
            for (IGraphNode iGraphNode2 : treeSet3) {
                if (!iGraphNode.getIsGroup() || !iGraphNode2.getIsGroup()) continue;
                MappedVertex mappedVertex = new MappedVertex(iGraphNode, iGraphNode2);
                for (MappedVertex mappedVertex2 : this.mappedVertexList) {
                    if (!mappedVertex.equals(mappedVertex2)) continue;
                    treeSet.add(mappedVertex2);
                }
                if (!logger.isDebugEnabled()) continue;
                System.out.println("mappedVertex: " + mappedVertex + " " + mappedVertex.isGroup());
                System.out.println("size: " + mappedVertex.getGroupSize());
            }
        }
        return treeSet;
    }

    public void groupSimilarity(MappedVertex mappedVertex, TreeSet<IGraphNode> treeSet, TreeSet<IGraphNode> treeSet2, String string) {
        ArrayList arrayList;
        ArrayList arrayList2;
        HashMap<IGraphNode, ArrayList> hashMap = new HashMap<IGraphNode, ArrayList>();
        HashMap<IGraphNode, ArrayList> hashMap2 = new HashMap<IGraphNode, ArrayList>();
        ArrayList<MappedVertex> arrayList3 = new ArrayList<MappedVertex>();
        Double d = 0.0;
        int n = 0;
        for (IGraphNode object2 : treeSet) {
            arrayList2 = new ArrayList();
            arrayList = new ArrayList();
            for (IGraphNode iGraphNode : treeSet2) {
                if (this.similarityMeasure.equals("Levenshtein")) {
                    Object object = new Levenshtein<String>(new StringAccessor(((Object)object2).toString()), new StringAccessor(((Object)iGraphNode).toString()));
                    arrayList2.add(((SimilarityMeasure)object).getSimilarity());
                    arrayList.add(iGraphNode);
                    continue;
                }
                logger.error((Object)"Not yet implemented!");
            }
            hashMap.put(object2, arrayList);
            hashMap2.put(object2, arrayList2);
        }
        for (IGraphNode iGraphNode : treeSet) {
            arrayList2 = new ArrayList();
            arrayList = new ArrayList();
            arrayList2 = (ArrayList)hashMap2.get(iGraphNode);
            arrayList = (ArrayList)hashMap.get(iGraphNode);
            Double d2 = 0.0;
            for (Double d3 : arrayList2) {
                d2 = Math.max(d2, d3);
            }
            n = arrayList2.indexOf(d2);
            d = d + d2;
            IGraphNode iGraphNode2 = (IGraphNode)arrayList.get(n);
            MappedVertex mappedVertex2 = string.equals("normal") ? new MappedVertex(iGraphNode, iGraphNode2) : new MappedVertex(iGraphNode2, iGraphNode);
            arrayList3.add(mappedVertex2);
            for (Object object : treeSet) {
                ((ArrayList)hashMap2.get(object)).remove(n);
                ((ArrayList)hashMap.get(object)).remove(n);
            }
        }
        for (MappedVertex mappedVertex3 : arrayList3) {
            mappedVertex.addGroupMember(mappedVertex3);
        }
        mappedVertex.setGroupSimilarity(d);
        mappedVertex.setGroupSize(Math.min(treeSet.size(), treeSet2.size()));
        if (logger.isDebugEnabled()) {
            System.out.println("MappedVertex: " + mappedVertex);
            System.out.println("groupMembers: " + arrayList3);
            System.out.println("groupSimilarity: " + d);
        }
    }

    public void nextMaximalClique(TreeSet<MappedVertex> treeSet, TreeSet<IGraphNode> treeSet2, TreeSet<IGraphNode> treeSet3, TreeSet<MappedVertex> treeSet4) {
        block16: {
            block15: {
                TreeSet<MappedVertex> treeSet5 = new TreeSet<MappedVertex>(new MappedVertexComparator());
                int n = 0;
                ++this.countLoop;
                if (Math.IEEEremainder(this.countLoop, 100000.0) == 0.0) {
                    System.out.println("countLoop: " + this.countLoop);
                }
                for (MappedVertex serializable : treeSet4) {
                    treeSet5.add(serializable);
                }
                if (!treeSet.isEmpty()) break block15;
                for (MappedVertex mappedVertex : treeSet5) {
                    if (mappedVertex.isGroup()) {
                        n += mappedVertex.getGroupSize();
                        logger.debug((Object)(mappedVertex.isGroup() + " group size: " + mappedVertex.getGroupSize()));
                        continue;
                    }
                    ++n;
                }
                logger.debug((Object)("cliq size: " + n + " " + this.graphSize));
                if (n != this.graphSize) break block16;
                this.checkIfMaxClique(treeSet5);
                logger.debug((Object)"max cliq!!!!!!!!!!!!!!");
                ++this.countCliq;
                if (Math.IEEEremainder(this.countCliq, 50000.0) != 0.0) break block16;
                System.out.println("Cliq: " + this.countCliq + " " + treeSet5);
                break block16;
            }
            while (!treeSet.isEmpty()) {
                MappedVertex mappedVertex = treeSet.first();
                treeSet.remove(mappedVertex);
                this.node1 = mappedVertex.getLeftNode();
                this.node2 = mappedVertex.getRightNode();
                TreeSet<MappedVertex> treeSet6 = new TreeSet<MappedVertex>(new MappedVertexComparator());
                TreeSet<IGraphNode> treeSet5 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
                TreeSet<IGraphNode> treeSet7 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
                if (logger.isDebugEnabled()) {
                    System.out.println("mappedVertex: " + mappedVertex);
                    System.out.println("impossible before l: " + treeSet2);
                    System.out.println("impossible before r: " + treeSet3);
                    System.out.println("adjacent for mappedVertex: " + this.adjacentMap.get(mappedVertex));
                }
                for (MappedVertex mappedVertex2 : this.adjacentMap.get(mappedVertex)) {
                    if (!(treeSet2.contains(mappedVertex2.getLeftNode()) || treeSet3.contains(mappedVertex2.getRightNode()) || treeSet4.contains(mappedVertex2))) {
                        treeSet6.add(mappedVertex2);
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    System.out.println("new candidate not added: " + mappedVertex2);
                    System.out.println(!treeSet2.contains(this.node1) + " " + !treeSet3.contains(this.node2) + " " + !treeSet4.contains(mappedVertex2));
                }
                logger.debug((Object)("only new candidates: " + treeSet6));
                for (MappedVertex mappedVertex3 : treeSet) {
                    if (logger.isDebugEnabled()) {
                        System.out.println("old candidate: " + mappedVertex3);
                        System.out.println(this.adjacentMap.get(mappedVertex).contains(mappedVertex3) + " " + !mappedVertex3.getLeftNode().equals(this.node1) + " " + !mappedVertex3.getRightNode().equals(this.node2) + " " + !this.node1.getAdjacentSet().contains(mappedVertex3.getLeftNode()) + " " + !this.node2.getAdjacentSet().contains(mappedVertex3.getRightNode()));
                    }
                    if (!this.adjacentMap.get(mappedVertex).contains(mappedVertex3) && (mappedVertex3.getLeftNode().equals(this.node1) || mappedVertex3.getRightNode().equals(this.node2) || this.node1.getAdjacentSet().contains(mappedVertex3.getLeftNode()) || this.node2.getAdjacentSet().contains(mappedVertex3.getRightNode()))) continue;
                    treeSet6.add(mappedVertex3);
                }
                for (IGraphNode iGraphNode : treeSet2) {
                    treeSet5.add(iGraphNode);
                }
                for (IGraphNode iGraphNode : treeSet3) {
                    treeSet7.add(iGraphNode);
                }
                for (IGraphNode iGraphNode : this.node1.getAdjacentSet()) {
                    treeSet5.add(iGraphNode);
                }
                for (IGraphNode iGraphNode : this.node2.getAdjacentSet()) {
                    treeSet7.add(iGraphNode);
                }
                treeSet5.add(this.node1);
                treeSet7.add(this.node2);
                treeSet4.add(mappedVertex);
                if (logger.isDebugEnabled()) {
                    System.out.println("clique: " + treeSet4);
                    System.out.println("all candidates: " + treeSet6);
                    System.out.println("impossible after l: " + treeSet5);
                    System.out.println("impossible after r: " + treeSet7);
                }
                this.nextMaximalClique(treeSet6, treeSet5, treeSet7, treeSet4);
                treeSet4.remove(mappedVertex);
            }
        }
    }

    public void checkIfMaxClique(TreeSet<MappedVertex> treeSet) {
        int n = 0;
        double d = 0.0;
        String string = "";
        logger.debug((Object)("clique: " + treeSet));
        for (MappedVertex mappedVertex : treeSet) {
            logger.debug((Object)(mappedVertex + " isgroup: " + mappedVertex.isGroup()));
            if (mappedVertex.isGroup()) {
                logger.debug((Object)(" groupsiz: " + mappedVertex.getGroupSize() + " groupsim: " + mappedVertex.getGroupSimilarity()));
                d += mappedVertex.getGroupSimilarity();
                n = n + mappedVertex.getGroupSize() - 1;
                for (MappedVertex mappedVertex2 : mappedVertex.getGroupMembers()) {
                    if (string.equals("")) {
                        string = string + mappedVertex2.toString();
                        continue;
                    }
                    string = string + ", " + mappedVertex2.toString();
                }
            } else {
                logger.debug((Object)("labelsim: " + mappedVertex.getLabelSimilarity()));
                d += mappedVertex.getLabelSimilarity();
                string = string.equals("") ? string + mappedVertex.toString() : string + ", " + mappedVertex.toString();
            }
            logger.debug((Object)("totalSimilarity: " + d));
        }
        logger.debug((Object)("labelSimilarity absolute: " + d));
        d /= (double)(treeSet.size() + n);
        if (logger.isDebugEnabled()) {
            System.out.println("clique: " + string);
            System.out.println("labelSimilarity: " + d);
        }
        String string2 = string;
        if (d == 1.0) {
            string = string + "; 1";
        } else {
            int n2 = (int)(d * 100.0);
            Integer n3 = new Integer(n2);
            string = string + "; 0." + n3.toString();
        }
        this.checkMax(d, string2, string);
    }

    public void checkMax(double d, String string, String string2) {
        if (d >= this.maxSimilarity) {
            if (d > this.maxSimilarity) {
                this.cliqueList.clear();
            }
            this.cliqueList.add(string);
        }
        if (d > this.maxSimilarity) {
            this.maxSimilarityPathWithSimNumber = string2;
            logger.debug((Object)("maxSimilarityPathWithSimNumber: " + this.maxSimilarityPathWithSimNumber));
        }
        this.maxSimilarity = Math.max(this.maxSimilarity, d);
    }

    public TreeSet<String> getCliqueList() {
        return this.cliqueList;
    }
}

