/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.graph;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.api.impl.GraphSimilarityMeasure;
import simpack.util.graph.MappedVertex;
import simpack.util.graph.comparator.MappedVertexComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxCommonSubgraphIsoValiente
extends GraphSimilarityMeasure {
    public static Logger logger = Logger.getLogger(MaxCommonSubgraphIsoValiente.class);
    public static String DEFAULT_NODE_LABEL_SIMILARITY_MEASURE = "Levenshtein";
    public static int DEFAULT_MIN_CLIQUE_SIZE = 2;
    public static double DEFAULT_STRUCTURE_WEIGHT = 0.5;
    public static double DEFAULT_LABEL_WEIGHT = 0.5;
    public static boolean NODE_GROUPING = false;
    public static String DEFAULT_DENOMINATOR = "average";
    protected int minCliqueSize = DEFAULT_MIN_CLIQUE_SIZE;
    protected double structureWeight = DEFAULT_STRUCTURE_WEIGHT;
    protected double labelWeight = DEFAULT_LABEL_WEIGHT;
    protected IGraphAccessor graphAccessor1;
    protected IGraphAccessor graphAccessor2;
    protected double graphsSize = 0.0;
    protected int countCliq = 0;
    protected int countLoop = 0;
    protected int countMV = 0;
    protected TreeSet<IGraphNode> nodeSet1 = new TreeSet();
    protected TreeSet<IGraphNode> nodeSet2 = new TreeSet();
    protected ArrayList<MappedVertex> mappedVertexList = new ArrayList();
    protected TreeMap<MappedVertex, TreeSet<MappedVertex>> adjacentMap = new TreeMap(new MappedVertexComparator());
    protected TreeSet<String> cliqueList = new TreeSet();
    protected double maxSimilarity = 0.0;
    protected double tmpMaxSimilarity = 0.0;
    protected int maxVertex = 0;
    protected int tmpMaxVertex = 0;
    protected String maxVertexPathWithSimNumber;
    protected String maxSimilarityPathWithSimNumber;
    protected long startMillis;
    protected Timestamp ts;
    protected long millis;
    protected Calendar eDate;

    public MaxCommonSubgraphIsoValiente(IGraphAccessor iGraphAccessor, IGraphAccessor iGraphAccessor2) {
        this(iGraphAccessor, iGraphAccessor2, DEFAULT_MIN_CLIQUE_SIZE, DEFAULT_STRUCTURE_WEIGHT, DEFAULT_LABEL_WEIGHT, DEFAULT_DENOMINATOR);
    }

    public MaxCommonSubgraphIsoValiente(IGraphAccessor iGraphAccessor, IGraphAccessor iGraphAccessor2, int n, double d, double d2, String string) {
        this.graphAccessor1 = iGraphAccessor;
        this.graphAccessor2 = iGraphAccessor2;
        this.minCliqueSize = n;
        this.structureWeight = d;
        this.labelWeight = d2;
        if (string.equals("first")) {
            this.graphsSize = iGraphAccessor.getNodeSet().size();
        } else if (string.equals("small")) {
            this.graphsSize = iGraphAccessor.getNodeSet().size() > iGraphAccessor2.getNodeSet().size() ? (double)iGraphAccessor2.getNodeSet().size() : (double)iGraphAccessor.getNodeSet().size();
        } else if (string.equals("big")) {
            this.graphsSize = iGraphAccessor.getNodeSet().size() > iGraphAccessor2.getNodeSet().size() ? (double)iGraphAccessor.getNodeSet().size() : (double)iGraphAccessor2.getNodeSet().size();
        } else if (string.equals("average")) {
            this.graphsSize = (double)(iGraphAccessor.getNodeSet().size() + iGraphAccessor2.getNodeSet().size()) / 2.0;
        } else {
            logger.debug((Object)"valid denominators are \"first\", \"small\", \"big\" and \"average\". default \"average\" is taken");
            this.graphsSize = (double)(iGraphAccessor.getNodeSet().size() + iGraphAccessor2.getNodeSet().size()) / 2.0;
        }
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        TreeSet<MappedVertex> treeSet = new TreeSet<MappedVertex>(new MappedVertexComparator());
        TreeSet<MappedVertex> treeSet2 = new TreeSet<MappedVertex>(new MappedVertexComparator());
        TreeSet<MappedVertex> treeSet3 = new TreeSet<MappedVertex>(new MappedVertexComparator());
        this.nodeSet1 = this.graphAccessor1.getNodeSet();
        this.nodeSet2 = this.graphAccessor2.getNodeSet();
        this.adjacentMap = this.map();
        if (logger.isDebugEnabled()) {
            for (IGraphNode iterator2 : this.graphAccessor1.getNodeSet()) {
                System.out.println("nodeG1: " + iterator2);
                System.out.println("pre: " + iterator2.getPredecessorSet());
                System.out.println("suc: " + iterator2.getSuccessorSet());
            }
            for (IGraphNode iGraphNode : this.graphAccessor2.getNodeSet()) {
                System.out.println("nodeG2: " + iGraphNode);
                System.out.println("pre: " + iGraphNode.getPredecessorSet());
                System.out.println("suc: " + iGraphNode.getSuccessorSet());
            }
            Set<MappedVertex> set = this.adjacentMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                MappedVertex mappedVertex = (MappedVertex)iterator.next();
                System.out.println(mappedVertex);
                if (mappedVertex.isGroup()) {
                    System.out.println("grpsiz " + mappedVertex.getGroupSize() + "  grpsim " + mappedVertex.getGroupSimilarity() + "  Map: " + this.adjacentMap.get(mappedVertex));
                } else {
                    System.out.println("labelsim " + mappedVertex.getLabelSimilarity() + "  Map: " + this.adjacentMap.get(mappedVertex));
                }
                for (MappedVertex mappedVertex2 : this.adjacentMap.get(mappedVertex)) {
                    System.out.println(mappedVertex2 + " sim " + mappedVertex2.getLabelSimilarity());
                }
            }
        }
        for (MappedVertex mappedVertex : this.mappedVertexList) {
            ++this.countMV;
            if (Math.IEEEremainder(this.countMV, 10000.0) == 0.0) {
                this.eDate = Calendar.getInstance();
                this.millis = this.eDate.getTime().getTime();
                this.ts = new Timestamp(this.millis);
                System.out.println(this.countMV + ") " + mappedVertex + " " + this.ts + " = " + (this.millis - this.startMillis) / 1000L + " sec");
            }
            treeSet.add(mappedVertex);
        }
        this.nextMaximalClique(treeSet, treeSet3, treeSet2, this.minCliqueSize);
        this.similarity = this.maxSimilarity;
        this.setCalculated(true);
        return true;
    }

    public TreeMap<MappedVertex, TreeSet<MappedVertex>> map() {
        for (IGraphNode iGraphNode : this.nodeSet1) {
            for (IGraphNode iGraphNode2 : this.nodeSet2) {
                MappedVertex mappedVertex = new MappedVertex(iGraphNode, iGraphNode2);
                TreeSet<MappedVertex> treeSet = new TreeSet<MappedVertex>(new MappedVertexComparator());
                for (IGraphNode iGraphNode3 : this.nodeSet1) {
                    for (IGraphNode iGraphNode4 : this.nodeSet2) {
                        MappedVertex mappedVertex2 = new MappedVertex(iGraphNode3, iGraphNode4);
                        if (mappedVertex.smaller(mappedVertex2) >= 0 || iGraphNode.equals(iGraphNode3) || iGraphNode2.equals(iGraphNode4) || !(iGraphNode.getPredecessorSet().contains(iGraphNode3) && iGraphNode2.getPredecessorSet().contains(iGraphNode4) || iGraphNode.getSuccessorSet().contains(iGraphNode3) && iGraphNode2.getSuccessorSet().contains(iGraphNode4)) && (iGraphNode.getAdjacentSet().contains(iGraphNode3) || iGraphNode2.getAdjacentSet().contains(iGraphNode4))) continue;
                        treeSet.add(mappedVertex2);
                    }
                }
                this.mappedVertexList.add(mappedVertex);
                this.adjacentMap.put(mappedVertex, treeSet);
            }
        }
        return this.adjacentMap;
    }

    public void nextMaximalClique(TreeSet<MappedVertex> treeSet, TreeSet<MappedVertex> treeSet2, TreeSet<MappedVertex> treeSet3, int n) {
        ++this.countLoop;
        if (Math.IEEEremainder(this.countLoop, 2000000.0) == 0.0) {
            logger.debug((Object)("countLoop: " + this.countLoop));
        }
        TreeSet<MappedVertex> treeSet4 = new TreeSet<MappedVertex>(new MappedVertexComparator());
        for (MappedVertex serializable : treeSet3) {
            treeSet4.add(serializable);
        }
        if (treeSet.isEmpty()) {
            if (treeSet2.isEmpty() && treeSet4.size() >= n) {
                ++this.countCliq;
                if (Math.IEEEremainder(this.countCliq, 200000.0) == 0.0) {
                    logger.debug((Object)("Cliq: " + this.countCliq + " " + treeSet4));
                }
                this.checkIfMaxClique(treeSet4);
            }
        } else {
            while (!treeSet.isEmpty()) {
                MappedVertex mappedVertex = treeSet.first();
                treeSet.remove(mappedVertex);
                TreeSet<MappedVertex> treeSet5 = new TreeSet<MappedVertex>(new MappedVertexComparator());
                TreeSet<MappedVertex> treeSet6 = new TreeSet<MappedVertex>(new MappedVertexComparator());
                if (logger.isDebugEnabled()) {
                    System.out.println("mappedVertex: " + mappedVertex);
                    System.out.println("adjacent for mappedVertex: " + this.adjacentMap.get(mappedVertex));
                }
                for (MappedVertex mappedVertex2 : this.adjacentMap.get(mappedVertex)) {
                    if (treeSet.contains(mappedVertex2)) {
                        treeSet5.add(mappedVertex2);
                    }
                    if (!treeSet2.contains(mappedVertex2)) continue;
                    treeSet6.add(mappedVertex2);
                }
                treeSet3.add(mappedVertex);
                if (logger.isDebugEnabled()) {
                    System.out.println("clique: " + treeSet3);
                    System.out.println("new candidates: " + treeSet5);
                }
                this.nextMaximalClique(treeSet5, treeSet6, treeSet3, n);
                treeSet3.remove(mappedVertex);
                treeSet2.add(mappedVertex);
            }
        }
    }

    public void checkIfMaxClique(TreeSet<MappedVertex> treeSet) {
        logger.debug((Object)("clique: " + treeSet));
        double d = 0.0;
        String string = "";
        for (MappedVertex mappedVertex : treeSet) {
            d += mappedVertex.calculateLabelSimilarity();
            if (string.equals("")) {
                string = string + mappedVertex.toString();
                continue;
            }
            string = string + ", " + mappedVertex.toString();
        }
        double d2 = (double)treeSet.size() / this.graphsSize;
        double d3 = this.labelWeight * (d /= this.graphsSize) + this.structureWeight * d2;
        if (logger.isDebugEnabled()) {
            System.out.println("clique: " + string);
            System.out.println("labelSimilarity: " + d);
            System.out.println("structureSimilarity: " + d2);
            System.out.println("overallSimilarity: " + d3);
        }
        String string2 = string;
        if (d3 == 1.0) {
            string = string + "; 1";
        } else {
            int n = (int)(d3 * 100.0);
            Integer n2 = new Integer(n);
            string = string + "; 0." + n2.toString();
        }
        this.checkMax(treeSet.size(), d3, string2, string);
    }

    public void checkMax(int n, double d, String string, String string2) {
        if (d >= this.maxSimilarity) {
            if (d > this.maxSimilarity) {
                this.cliqueList.clear();
            }
            this.cliqueList.add(string);
        }
        if (n > this.maxVertex || n == this.maxVertex && d > this.tmpMaxSimilarity) {
            this.maxVertexPathWithSimNumber = string2;
            logger.debug((Object)("maxVertexPathWithSimNumber: " + this.maxVertexPathWithSimNumber));
            this.maxVertex = n;
            this.tmpMaxSimilarity = Math.max(this.tmpMaxSimilarity, d);
        }
        if (d > this.maxSimilarity || d == this.maxSimilarity && n > this.tmpMaxVertex) {
            this.maxSimilarityPathWithSimNumber = string2;
            logger.debug((Object)("maxSimilarityPathWithSimNumber: " + this.maxSimilarityPathWithSimNumber));
            this.maxSimilarity = d;
            this.tmpMaxVertex = Math.max(this.tmpMaxVertex, n);
        }
    }

    public TreeSet<String> getCliqueList() {
        return this.cliqueList;
    }
}

