/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.graph;

import org.apache.log4j.Logger;
import simpack.api.IDistanceConversion;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.api.impl.SimilarityMeasure;
import simpack.exception.InvalidElementException;

public class ShortestPath
extends SimilarityMeasure {
    static Logger logger = Logger.getLogger(ShortestPath.class);
    private IGraphAccessor graphAccessor;
    private IGraphNode nodeA;
    private IGraphNode nodeB;
    private IDistanceConversion conversion;

    public ShortestPath(IGraphAccessor iGraphAccessor, IGraphNode iGraphNode, IGraphNode iGraphNode2) throws InvalidElementException {
        this.graphAccessor = iGraphAccessor;
        this.nodeA = iGraphNode;
        this.nodeB = iGraphNode2;
        if (!iGraphAccessor.contains(iGraphNode)) {
            throw new InvalidElementException(((Object)iGraphNode).toString() + " not in graph");
        }
        if (!iGraphAccessor.contains(iGraphNode2)) {
            throw new InvalidElementException(((Object)iGraphNode2).toString() + " not in graph");
        }
    }

    public ShortestPath(IGraphAccessor iGraphAccessor, IGraphNode iGraphNode, IGraphNode iGraphNode2, IDistanceConversion iDistanceConversion) throws InvalidElementException {
        this.graphAccessor = iGraphAccessor;
        this.nodeA = iGraphNode;
        this.nodeB = iGraphNode2;
        this.conversion = iDistanceConversion;
        if (!iGraphAccessor.contains(iGraphNode)) {
            throw new InvalidElementException(((Object)iGraphNode).toString() + " not in graph");
        }
        if (!iGraphAccessor.contains(iGraphNode2)) {
            throw new InvalidElementException(((Object)iGraphNode2).toString() + " not in graph");
        }
    }

    public boolean calculate() {
        this.setCalculated(false);
        try {
            double d = this.graphAccessor.getShortestPath(this.nodeA, this.nodeB);
            this.similarity = this.conversion != null ? new Double(this.conversion.convert(d)) : new Double(d);
            this.setCalculated(true);
            return true;
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
            return false;
        }
    }
}

