/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.graph;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import simpack.accessor.string.StringAccessor;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.api.impl.GraphSimilarityMeasure;
import simpack.api.impl.SimilarityMeasure;
import simpack.measure.sequence.Levenshtein;
import simpack.util.graph.GraphNode;
import simpack.util.graph.GroupNode;
import simpack.util.graph.MappedVertex;
import simpack.util.graph.comparator.MappedVertexComparator;
import simpack.util.graph.comparator.NamedGraphNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubgraphIsomorphism
extends GraphSimilarityMeasure {
    public static Logger logger = Logger.getLogger(SubgraphIsomorphism.class);
    public static String DEFAULT_NODE_LABEL_SIMILARITY_MEASURE = "Levenshtein";
    public static int DEFAULT_MIN_CLIQUE_SIZE = 2;
    public static double DEFAULT_STRUCTURE_WEIGHT = 0.5;
    public static double DEFAULT_LABEL_WEIGHT = 0.5;
    public static boolean NODE_GROUPING = false;
    public static String DEFAULT_DENOMINATOR = "average";
    protected String similarityMeasure = DEFAULT_NODE_LABEL_SIMILARITY_MEASURE;
    protected int minCliqueSize = DEFAULT_MIN_CLIQUE_SIZE;
    protected double structureWeight = DEFAULT_STRUCTURE_WEIGHT;
    protected double labelWeight = DEFAULT_LABEL_WEIGHT;
    protected boolean groupNodes = NODE_GROUPING;
    protected IGraphAccessor graphAccessor1;
    protected IGraphAccessor graphAccessor2;
    protected double graphsSize = 0.0;
    protected int countCliq = 0;
    protected int countLoop = 0;
    protected int countMV = 0;
    protected int countLoopAdjacentMap = 0;
    protected TreeSet<IGraphNode> nodeSet1 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
    protected TreeSet<IGraphNode> nodeSet2 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
    protected ArrayList<MappedVertex> mappedVertexList = new ArrayList();
    protected ArrayList<MappedVertex> startCandidateList = new ArrayList();
    protected TreeMap<MappedVertex, TreeSet<MappedVertex>> adjacentMap = new TreeMap(new MappedVertexComparator());
    protected TreeMap<IGraphNode, Double> deleteSet = new TreeMap(new NamedGraphNodeComparator());
    protected TreeSet<String> cliqueList = new TreeSet();
    protected IGraphNode node1;
    protected IGraphNode node2;
    protected double maxSimilarity = 0.0;
    protected double tmpMaxSimilarity = 0.0;
    protected int maxVertex = 0;
    protected int tmpMaxVertex = 0;
    protected String maxVertexPathWithSimNumber;
    protected String maxSimilarityPathWithSimNumber;
    protected long startMillis;
    protected Timestamp ts;
    protected long millis;
    protected Calendar eDate;

    public SubgraphIsomorphism(IGraphAccessor iGraphAccessor, IGraphAccessor iGraphAccessor2) {
        this(iGraphAccessor, iGraphAccessor2, DEFAULT_MIN_CLIQUE_SIZE, DEFAULT_LABEL_WEIGHT, DEFAULT_STRUCTURE_WEIGHT, DEFAULT_DENOMINATOR, NODE_GROUPING);
    }

    public SubgraphIsomorphism(IGraphAccessor iGraphAccessor, IGraphAccessor iGraphAccessor2, int n, double d, double d2, String string, boolean bl) {
        this.graphAccessor1 = iGraphAccessor;
        this.graphAccessor2 = iGraphAccessor2;
        this.minCliqueSize = n;
        this.labelWeight = d2;
        this.structureWeight = d;
        this.groupNodes = bl;
        if (string.equals("first")) {
            this.graphsSize = iGraphAccessor.getNodeSet().size();
        } else if (string.equals("small")) {
            this.graphsSize = iGraphAccessor.getNodeSet().size() > iGraphAccessor2.getNodeSet().size() ? (double)iGraphAccessor2.getNodeSet().size() : (double)iGraphAccessor.getNodeSet().size();
        } else if (string.equals("big")) {
            this.graphsSize = iGraphAccessor.getNodeSet().size() > iGraphAccessor2.getNodeSet().size() ? (double)iGraphAccessor.getNodeSet().size() : (double)iGraphAccessor2.getNodeSet().size();
        } else if (string.equals("average")) {
            this.graphsSize = (double)(iGraphAccessor.getNodeSet().size() + iGraphAccessor2.getNodeSet().size()) / 2.0;
        } else {
            logger.debug((Object)"valid denominators are \"first\", \"small\", \"big\" and \"average\". default \"average\" is taken");
            this.graphsSize = (double)(iGraphAccessor.getNodeSet().size() + iGraphAccessor2.getNodeSet().size()) / 2.0;
        }
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        TreeSet<MappedVertex> treeSet = new TreeSet<MappedVertex>(new MappedVertexComparator());
        TreeSet<MappedVertex> treeSet2 = new TreeSet<MappedVertex>(new MappedVertexComparator());
        this.nodeSet1 = this.graphAccessor1.getNodeSet();
        this.nodeSet2 = this.graphAccessor2.getNodeSet();
        if (this.groupNodes) {
            this.setGroups(this.graphAccessor1, "G1");
            this.setGroups(this.graphAccessor2, "G2");
        }
        this.mappedVertexList = this.getVertexList();
        TreeSet<IGraphNode> treeSet3 = new TreeSet<IGraphNode>();
        TreeSet<IGraphNode> treeSet4 = new TreeSet<IGraphNode>();
        this.adjacentMap = this.getAdjacentMap();
        if (logger.isDebugEnabled()) {
            for (IGraphNode iterator2 : this.graphAccessor1.getNodeSet()) {
                System.out.println("nodeG1: " + iterator2);
                System.out.println("pre: " + iterator2.getPredecessorSet());
                System.out.println("suc: " + iterator2.getSuccessorSet());
            }
            for (IGraphNode iGraphNode : this.graphAccessor2.getNodeSet()) {
                System.out.println("nodeG2: " + iGraphNode);
                System.out.println("pre: " + iGraphNode.getPredecessorSet());
                System.out.println("suc: " + iGraphNode.getSuccessorSet());
            }
            Set<MappedVertex> set = this.adjacentMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                MappedVertex mappedVertex = (MappedVertex)iterator.next();
                System.out.println(mappedVertex);
                if (mappedVertex.isGroup()) {
                    System.out.println("grpsiz " + mappedVertex.getGroupSize() + "  grpsim " + mappedVertex.getGroupSimilarity() + "  Map: " + this.adjacentMap.get(mappedVertex));
                } else {
                    System.out.println("labelsim " + mappedVertex.getLabelSimilarity() + "  Map: " + this.adjacentMap.get(mappedVertex));
                }
                for (MappedVertex mappedVertex2 : this.adjacentMap.get(mappedVertex)) {
                    System.out.println(mappedVertex2 + " sim " + mappedVertex2.getLabelSimilarity());
                }
            }
        }
        for (MappedVertex mappedVertex : this.startCandidateList) {
            ++this.countMV;
            if (Math.IEEEremainder(this.countMV, 100.0) == 0.0) {
                this.eDate = Calendar.getInstance();
                this.millis = this.eDate.getTime().getTime();
                this.ts = new Timestamp(this.millis);
                logger.debug((Object)(this.countMV + ") " + mappedVertex + " " + this.ts + " = " + (this.millis - this.startMillis) / 1000L + " sec"));
            }
            treeSet.add(mappedVertex);
            this.nextMaximalClique(treeSet, treeSet3, treeSet4, treeSet2, this.minCliqueSize);
        }
        logger.debug((Object)("maxSimilarity: " + this.maxSimilarityPathWithSimNumber));
        logger.debug((Object)("maxVertex: " + this.maxVertexPathWithSimNumber));
        this.similarity = this.maxSimilarity;
        this.setCalculated(true);
        return true;
    }

    public void setGroups(IGraphAccessor iGraphAccessor, String string) {
        Integer n = 0;
        TreeSet<IGraphNode> treeSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
        for (IGraphNode iGraphNode : iGraphAccessor.getNodeSet()) {
            logger.debug((Object)("node: " + iGraphNode));
            boolean bl = true;
            if (iGraphNode.getHasGroup() || iGraphNode.getSuccessorSet() == null || iGraphNode.getSuccessorSet().size() <= 1) continue;
            TreeSet<IGraphNode> treeSet2 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
            TreeSet<IGraphNode> treeSet3 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
            TreeSet<IGraphNode> treeSet4 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
            treeSet2 = iGraphNode.getSuccessorSet();
            IGraphNode iGraphNode2 = treeSet2.first();
            treeSet3 = iGraphNode2.getPredecessorSet();
            logger.debug((Object)("predecessorSet of 1st successor: " + treeSet3));
            for (IGraphNode iGraphNode3 : treeSet2) {
                if ((iGraphNode3.getSuccessorSet() == null || iGraphNode3.getSuccessorSet().size() == 0) && iGraphNode3.getPredecessorSet().size() == treeSet3.size()) {
                    for (IGraphNode iGraphNode4 : treeSet3) {
                        if (iGraphNode3.getPredecessorSet().contains(iGraphNode4)) continue;
                        bl = false;
                    }
                    continue;
                }
                bl = false;
            }
            for (IGraphNode iGraphNode5 : treeSet3) {
                if (iGraphNode5.getSuccessorSet().size() == treeSet2.size()) continue;
                bl = false;
            }
            logger.debug((Object)("is groupable: " + bl));
            if (!bl) continue;
            iGraphNode.setHasGroup();
            Object object3 = n;
            Integer n2 = n = Integer.valueOf(n + 1);
            object3 = new GroupNode(string.concat("_GROUP_").concat(n.toString()));
            treeSet.add((IGraphNode)object3);
            logger.debug((Object)("groupNode: " + ((GraphNode)object3).toString()));
            ((GroupNode)object3).setGroupSize(treeSet2.size());
            for (IGraphNode iGraphNode6 : treeSet2) {
                if (iGraphNode6.getIsGroup()) continue;
                treeSet4.add(iGraphNode6);
            }
            ((GroupNode)object3).setGroupNodes(treeSet4);
            logger.debug((Object)("memberSet: " + treeSet4));
            for (IGraphNode iGraphNode7 : treeSet3) {
                ((GraphNode)object3).addPredecessor(iGraphNode7);
                iGraphNode7.setHasGroup();
                iGraphNode7.addSuccessor((IGraphNode)object3);
            }
        }
        for (IGraphNode iGraphNode : treeSet) {
            iGraphAccessor.addNode(iGraphNode);
        }
    }

    public ArrayList<MappedVertex> getVertexList() {
        TreeSet<IGraphNode> treeSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
        logger.debug((Object)("set1 size: " + this.nodeSet1.size() + " set2 size: " + this.nodeSet2.size()));
        for (IGraphNode object : this.nodeSet1) {
            if (object.getSuccessorSet().size() != 0) continue;
            treeSet.add(object);
        }
        logger.debug(treeSet);
        this.markNodes(treeSet, 0.0);
        if (logger.isDebugEnabled()) {
            Iterator<Object> iterator = this.deleteSet.keySet();
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                IGraphNode iGraphNode = (IGraphNode)iterator2.next();
                if (this.deleteSet.get(iGraphNode) != 0.0) continue;
                System.out.println("delete: " + iGraphNode);
            }
        }
        for (IGraphNode iGraphNode : this.nodeSet1) {
            for (IGraphNode iGraphNode2 : this.nodeSet2) {
                if (iGraphNode.getIsGroup() != iGraphNode2.getIsGroup()) continue;
                MappedVertex mappedVertex = new MappedVertex(iGraphNode, iGraphNode2);
                logger.debug((Object)("mv: " + mappedVertex + " groups: " + iGraphNode.getIsGroup()));
                this.mappedVertexList.add(mappedVertex);
                logger.debug((Object)(iGraphNode.getSuccessorSet().size() + " " + this.deleteSet.get(iGraphNode) + " " + iGraphNode2.getSuccessorSet().size()));
                if (iGraphNode.getSuccessorSet().size() > 0 && this.deleteSet.get(iGraphNode) == 1.0 && iGraphNode2.getSuccessorSet().size() > 0) {
                    this.startCandidateList.add(mappedVertex);
                }
                if (iGraphNode.getIsGroup()) {
                    if (iGraphNode.getGroupSize() > iGraphNode2.getGroupSize()) {
                        this.groupSimilarity(mappedVertex, iGraphNode2.getGroupNodes(), iGraphNode.getGroupNodes(), "reverse");
                        continue;
                    }
                    this.groupSimilarity(mappedVertex, iGraphNode.getGroupNodes(), iGraphNode2.getGroupNodes(), "normal");
                    continue;
                }
                if (this.similarityMeasure.equals("Levenshtein")) {
                    Levenshtein<String> levenshtein = new Levenshtein<String>(new StringAccessor(((Object)iGraphNode).toString()), new StringAccessor(((Object)iGraphNode2).toString()));
                    mappedVertex.setLabelSimilarity(levenshtein.getSimilarity());
                    continue;
                }
                logger.error((Object)"Not yet implemented!");
            }
        }
        if (logger.isDebugEnabled()) {
            for (MappedVertex mappedVertex : this.mappedVertexList) {
                System.out.println("mappedVertex: " + mappedVertex);
            }
        }
        return this.mappedVertexList;
    }

    public void markNodes(TreeSet<IGraphNode> treeSet, Double d) {
        TreeSet<IGraphNode> treeSet2 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
        TreeSet<IGraphNode> treeSet3 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
        if (d == 0.0) {
            for (IGraphNode iGraphNode : treeSet) {
                if (this.deleteSet.containsKey(iGraphNode)) {
                    treeSet3.add(iGraphNode);
                    continue;
                }
                this.deleteSet.put(iGraphNode, 0.0);
            }
        } else {
            for (IGraphNode iGraphNode : treeSet) {
                if (this.deleteSet.containsKey(iGraphNode)) {
                    treeSet3.add(iGraphNode);
                }
                this.deleteSet.put(iGraphNode, 1.0);
            }
        }
        for (IGraphNode iGraphNode : treeSet) {
            if (treeSet3.contains(iGraphNode)) continue;
            for (IGraphNode iGraphNode2 : iGraphNode.getPredecessorSet()) {
                treeSet2.add(iGraphNode2);
            }
        }
        d = Math.IEEEremainder(d + 1.0, 2.0);
        logger.debug((Object)(d + " " + treeSet2));
        if (treeSet2.size() > 0) {
            this.markNodes(treeSet2, d);
        }
    }

    public TreeMap<MappedVertex, TreeSet<MappedVertex>> getAdjacentMap() {
        TreeSet<IGraphNode> treeSet = new TreeSet();
        TreeSet<IGraphNode> treeSet2 = new TreeSet();
        TreeSet<IGraphNode> treeSet3 = new TreeSet();
        TreeSet<IGraphNode> treeSet4 = new TreeSet();
        for (MappedVertex mappedVertex : this.mappedVertexList) {
            logger.debug((Object)("mappedVertex: " + mappedVertex));
            ++this.countLoopAdjacentMap;
            if (Math.IEEEremainder(this.countLoopAdjacentMap, 1000.0) == 0.0) {
                System.out.println("loop adjacency: " + this.countLoopAdjacentMap + " mv: " + mappedVertex);
            }
            TreeSet<MappedVertex> treeSet5 = new TreeSet<MappedVertex>(new MappedVertexComparator());
            IGraphNode iGraphNode = mappedVertex.getLeftNode();
            IGraphNode iGraphNode2 = mappedVertex.getRightNode();
            treeSet = iGraphNode.getPredecessorSet();
            treeSet2 = iGraphNode2.getPredecessorSet();
            treeSet3 = iGraphNode.getSuccessorSet();
            treeSet4 = iGraphNode2.getSuccessorSet();
            if (logger.isDebugEnabled()) {
                System.out.println("nodes: " + iGraphNode + ", " + iGraphNode2);
                System.out.println("sourceSet1: " + treeSet);
                System.out.println("sourceSet2: " + treeSet2);
                System.out.println("targetSet1: " + treeSet3);
                System.out.println("targetSet2: " + treeSet4);
            }
            if (treeSet != null && treeSet2 != null) {
                treeSet5 = this.adjacentNodes(treeSet5, treeSet, treeSet2);
            }
            if (treeSet3 != null && treeSet4 != null) {
                if (iGraphNode.getHasGroup() && iGraphNode2.getHasGroup()) {
                    logger.debug((Object)"have group!");
                    treeSet5 = this.adjacentGroups(treeSet5, treeSet3, treeSet4);
                } else {
                    treeSet5 = this.adjacentNodes(treeSet5, treeSet3, treeSet4);
                }
            }
            logger.debug((Object)("commonAdjacentSet: " + treeSet5));
            this.adjacentMap.put(mappedVertex, treeSet5);
            if (!logger.isDebugEnabled()) continue;
            for (MappedVertex mappedVertex2 : treeSet5) {
                System.out.println("MV: " + mappedVertex + " " + mappedVertex.isGroup() + " m: " + mappedVertex2 + " " + mappedVertex2.isGroup());
            }
        }
        return this.adjacentMap;
    }

    public TreeSet<MappedVertex> adjacentNodes(TreeSet<MappedVertex> treeSet, TreeSet<IGraphNode> treeSet2, TreeSet<IGraphNode> treeSet3) {
        for (IGraphNode iGraphNode : treeSet2) {
            for (IGraphNode iGraphNode2 : treeSet3) {
                if (iGraphNode.getIsGroup() || iGraphNode2.getIsGroup()) continue;
                MappedVertex mappedVertex = new MappedVertex(iGraphNode, iGraphNode2);
                for (MappedVertex mappedVertex2 : this.mappedVertexList) {
                    if (!mappedVertex.equals(mappedVertex2)) continue;
                    treeSet.add(mappedVertex2);
                }
                if (!logger.isDebugEnabled()) continue;
                System.out.println("mappedVertex: " + mappedVertex);
                System.out.println("equal similarity: " + ((Object)iGraphNode).toString().equals(((Object)iGraphNode2).toString()));
            }
        }
        return treeSet;
    }

    public TreeSet<MappedVertex> adjacentGroups(TreeSet<MappedVertex> treeSet, TreeSet<IGraphNode> treeSet2, TreeSet<IGraphNode> treeSet3) {
        for (IGraphNode iGraphNode : treeSet2) {
            for (IGraphNode iGraphNode2 : treeSet3) {
                if (!iGraphNode.getIsGroup() || !iGraphNode2.getIsGroup()) continue;
                MappedVertex mappedVertex = new MappedVertex(iGraphNode, iGraphNode2);
                for (MappedVertex mappedVertex2 : this.mappedVertexList) {
                    if (!mappedVertex.equals(mappedVertex2)) continue;
                    treeSet.add(mappedVertex2);
                }
                if (!logger.isDebugEnabled()) continue;
                System.out.println("mappedVertex: " + mappedVertex + " " + mappedVertex.isGroup());
                System.out.println("group1: " + iGraphNode.getGroupNodes());
                System.out.println("group2: " + iGraphNode2.getGroupNodes());
                System.out.println("size: " + mappedVertex.getGroupSize());
            }
        }
        return treeSet;
    }

    public void groupSimilarity(MappedVertex mappedVertex, TreeSet<IGraphNode> treeSet, TreeSet<IGraphNode> treeSet2, String string) {
        ArrayList arrayList;
        ArrayList arrayList2;
        HashMap<IGraphNode, ArrayList> hashMap = new HashMap<IGraphNode, ArrayList>();
        HashMap<IGraphNode, ArrayList> hashMap2 = new HashMap<IGraphNode, ArrayList>();
        ArrayList<MappedVertex> arrayList3 = new ArrayList<MappedVertex>();
        Double d = 0.0;
        int n = 0;
        for (IGraphNode object2 : treeSet) {
            arrayList2 = new ArrayList();
            arrayList = new ArrayList();
            for (IGraphNode iGraphNode : treeSet2) {
                if (this.similarityMeasure.equals("Levenshtein")) {
                    Object object = new Levenshtein<String>(new StringAccessor(((Object)object2).toString()), new StringAccessor(((Object)iGraphNode).toString()));
                    arrayList2.add(((SimilarityMeasure)object).getSimilarity());
                    arrayList.add(iGraphNode);
                    continue;
                }
                logger.error((Object)"Not yet implemented!");
            }
            hashMap.put(object2, arrayList);
            hashMap2.put(object2, arrayList2);
        }
        for (IGraphNode iGraphNode : treeSet) {
            arrayList2 = new ArrayList();
            arrayList = new ArrayList();
            arrayList2 = (ArrayList)hashMap2.get(iGraphNode);
            arrayList = (ArrayList)hashMap.get(iGraphNode);
            Double d2 = 0.0;
            for (Double d3 : arrayList2) {
                d2 = Math.max(d2, d3);
            }
            n = arrayList2.indexOf(d2);
            d = d + d2;
            IGraphNode iGraphNode2 = (IGraphNode)arrayList.get(n);
            MappedVertex mappedVertex2 = string.equals("normal") ? new MappedVertex(iGraphNode, iGraphNode2) : new MappedVertex(iGraphNode2, iGraphNode);
            arrayList3.add(mappedVertex2);
            for (Object object : treeSet) {
                ((ArrayList)hashMap2.get(object)).remove(n);
                ((ArrayList)hashMap.get(object)).remove(n);
            }
        }
        for (MappedVertex mappedVertex3 : arrayList3) {
            mappedVertex.addGroupMember(mappedVertex3);
        }
        mappedVertex.setGroupSimilarity(d);
        mappedVertex.setGroupSize(Math.min(treeSet.size(), treeSet2.size()));
        if (logger.isDebugEnabled()) {
            System.out.println("MappedVertex: " + mappedVertex);
            System.out.println("groupMembers: " + arrayList3);
            System.out.println("groupSimilarity: " + d);
        }
    }

    public void nextMaximalClique(TreeSet<MappedVertex> treeSet, TreeSet<IGraphNode> treeSet2, TreeSet<IGraphNode> treeSet3, TreeSet<MappedVertex> treeSet4, int n) {
        ++this.countLoop;
        if (Math.IEEEremainder(this.countLoop, 2000000.0) == 0.0) {
            logger.debug((Object)("countLoop: " + this.countLoop));
        }
        int n2 = 0;
        TreeSet<MappedVertex> treeSet5 = new TreeSet<MappedVertex>(new MappedVertexComparator());
        for (MappedVertex serializable : treeSet4) {
            treeSet5.add(serializable);
        }
        if (treeSet.isEmpty()) {
            for (MappedVertex mappedVertex : treeSet5) {
                if (mappedVertex.isGroup()) {
                    n2 += mappedVertex.getGroupSize();
                    continue;
                }
                ++n2;
            }
            if (n2 >= n) {
                ++this.countCliq;
                if (Math.IEEEremainder(this.countCliq, 200000.0) == 0.0) {
                    logger.debug((Object)("Cliq: " + this.countCliq + " " + treeSet5));
                }
                this.checkIfMaxClique(treeSet5);
            }
        } else {
            while (!treeSet.isEmpty()) {
                MappedVertex mappedVertex = treeSet.first();
                treeSet.remove(mappedVertex);
                this.node1 = mappedVertex.getLeftNode();
                this.node2 = mappedVertex.getRightNode();
                TreeSet<MappedVertex> treeSet6 = new TreeSet<MappedVertex>(new MappedVertexComparator());
                TreeSet<IGraphNode> treeSet7 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
                TreeSet<IGraphNode> treeSet8 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
                if (logger.isDebugEnabled()) {
                    System.out.println("mappedVertex: " + mappedVertex);
                    System.out.println("impossible before l: " + treeSet2);
                    System.out.println("impossible before r: " + treeSet3);
                    System.out.println("adjacent for mappedVertex: " + this.adjacentMap.get(mappedVertex));
                }
                for (MappedVertex mappedVertex2 : this.adjacentMap.get(mappedVertex)) {
                    if (!(treeSet2.contains(mappedVertex2.getLeftNode()) || treeSet3.contains(mappedVertex2.getRightNode()) || treeSet4.contains(mappedVertex2))) {
                        treeSet6.add(mappedVertex2);
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    System.out.println("new candidate not added: " + mappedVertex2);
                    System.out.println(!treeSet2.contains(this.node1) + " " + !treeSet3.contains(this.node2) + " " + !treeSet4.contains(mappedVertex2));
                }
                logger.debug((Object)("only new candidates: " + treeSet6));
                for (MappedVertex mappedVertex3 : treeSet) {
                    if (logger.isDebugEnabled()) {
                        System.out.println("old candidate: " + mappedVertex3);
                        System.out.println(this.adjacentMap.get(mappedVertex).contains(mappedVertex3) + " " + !mappedVertex3.getLeftNode().equals(this.node1) + " " + !mappedVertex3.getRightNode().equals(this.node2) + " " + !this.node1.getAdjacentSet().contains(mappedVertex3.getLeftNode()) + " " + !this.node2.getAdjacentSet().contains(mappedVertex3.getRightNode()));
                    }
                    if (!this.adjacentMap.get(mappedVertex).contains(mappedVertex3) && (mappedVertex3.getLeftNode().equals(this.node1) || mappedVertex3.getRightNode().equals(this.node2) || this.node1.getAdjacentSet().contains(mappedVertex3.getLeftNode()) || this.node2.getAdjacentSet().contains(mappedVertex3.getRightNode()))) continue;
                    treeSet6.add(mappedVertex3);
                }
                for (IGraphNode iGraphNode : treeSet2) {
                    treeSet7.add(iGraphNode);
                }
                for (IGraphNode iGraphNode : treeSet3) {
                    treeSet8.add(iGraphNode);
                }
                for (IGraphNode iGraphNode : this.node1.getAdjacentSet()) {
                    treeSet7.add(iGraphNode);
                }
                for (IGraphNode iGraphNode : this.node2.getAdjacentSet()) {
                    treeSet8.add(iGraphNode);
                }
                treeSet7.add(this.node1);
                treeSet8.add(this.node2);
                treeSet4.add(mappedVertex);
                if (logger.isDebugEnabled()) {
                    System.out.println("clique: " + treeSet4);
                    System.out.println("all candidates: " + treeSet6);
                    System.out.println("impossible after l: " + treeSet7);
                    System.out.println("impossible after r: " + treeSet8);
                }
                this.nextMaximalClique(treeSet6, treeSet7, treeSet8, treeSet4, n);
                treeSet4.remove(mappedVertex);
            }
        }
    }

    public void checkIfMaxClique(TreeSet<MappedVertex> treeSet) {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        String string = "";
        for (MappedVertex mappedVertex : treeSet) {
            if (mappedVertex.isGroup()) {
                d += mappedVertex.getGroupSimilarity();
                n = n + mappedVertex.getGroupSize() - 1;
                for (MappedVertex mappedVertex2 : mappedVertex.getGroupMembers()) {
                    if (string.equals("")) {
                        string = string + mappedVertex2.toString();
                        continue;
                    }
                    string = string + ", " + mappedVertex2.toString();
                }
                continue;
            }
            d += mappedVertex.getLabelSimilarity();
            if (string.equals("")) {
                string = string + mappedVertex.toString();
                continue;
            }
            string = string + ", " + mappedVertex.toString();
        }
        d2 = (double)(treeSet.size() + n) / this.graphsSize;
        d3 = this.labelWeight * (d /= this.graphsSize) + this.structureWeight * d2;
        if (logger.isDebugEnabled()) {
            System.out.println("clique: " + string);
            System.out.println("labelSimilarity: " + d);
            System.out.println("structureSimilarity: " + d2);
            System.out.println("overallSimilarity: " + d3);
        }
        String string2 = string;
        if (d3 == 1.0) {
            string = string + "; 1";
        } else {
            int n2 = (int)(d3 * 100.0);
            Integer n3 = new Integer(n2);
            string = string + "; 0." + n3.toString();
        }
        this.checkMax(treeSet.size() + n, d3, string2, string);
    }

    public void checkMax(int n, double d, String string, String string2) {
        if (d >= this.maxSimilarity) {
            if (d > this.maxSimilarity) {
                this.cliqueList.clear();
            }
            this.cliqueList.add(string);
        }
        if (n > this.maxVertex || n == this.maxVertex && d > this.tmpMaxSimilarity) {
            this.maxVertexPathWithSimNumber = string2;
            logger.debug((Object)("maxVertexPathWithSimNumber: " + this.maxVertexPathWithSimNumber));
            this.maxVertex = n;
            this.tmpMaxSimilarity = Math.max(this.tmpMaxSimilarity, d);
        }
        if (d > this.maxSimilarity || d == this.maxSimilarity && n > this.tmpMaxVertex) {
            this.maxSimilarityPathWithSimNumber = string2;
            logger.debug((Object)("maxSimilarityPathWithSimNumber: " + this.maxSimilarityPathWithSimNumber));
            this.maxSimilarity = d;
            this.tmpMaxVertex = Math.max(this.tmpMaxVertex, n);
        }
    }

    public TreeSet<String> getCliqueList() {
        return this.cliqueList;
    }

    public double getGraphsSize() {
        return this.graphsSize;
    }
}

