/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.it;

import org.apache.log4j.Logger;
import simpack.api.impl.SimilarityMeasure;

public class Jensen_Shannon
extends SimilarityMeasure {
    private static Logger logger = Logger.getLogger(Jensen_Shannon.class);
    private static final double log2 = Math.log(2.0);
    private double[] a;
    private double[] b;

    public Jensen_Shannon(double[] dArray, double[] dArray2) {
        this.a = dArray;
        this.b = dArray2;
    }

    public double h(double d) {
        return -d * Math.log(d);
    }

    private double computeSimilarity() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.a.length; ++i) {
            if (this.a[i] == 0.0 || this.b[i] == 0.0) continue;
            d2 = this.h(this.a[i] + this.b[i]) - this.h(this.a[i]) - this.h(this.b[i]);
            if (!new Double(d2).isNaN()) {
                logger.debug((Object)d2);
            }
            d -= d2;
        }
        return d;
    }

    public boolean calculate() {
        double d = this.computeSimilarity();
        this.similarity = 0.5 * d / log2 / (double)this.a.length;
        this.setCalculated(true);
        return true;
    }
}

