/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.it;

import org.apache.log4j.Logger;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.api.impl.SimilarityMeasure;
import simpack.exception.InvalidElementException;

public class Resnik
extends SimilarityMeasure {
    static Logger logger = Logger.getLogger(Resnik.class);
    private double N;
    private double numCommons;
    private IGraphAccessor graphAccessor;
    private IGraphNode x;
    private IGraphNode y;

    public Resnik(double d, double d2) {
        this.N = d;
        this.numCommons = d2;
    }

    public Resnik(IGraphAccessor iGraphAccessor, IGraphNode iGraphNode, IGraphNode iGraphNode2) throws InvalidElementException {
        this.graphAccessor = iGraphAccessor;
        this.x = iGraphNode;
        this.y = iGraphNode2;
        if (!iGraphAccessor.contains(iGraphNode)) {
            throw new InvalidElementException(((Object)iGraphNode).toString() + " not in set");
        }
        if (!iGraphAccessor.contains(iGraphNode2)) {
            throw new InvalidElementException(((Object)iGraphNode2).toString() + " not in set");
        }
    }

    public boolean calculate() {
        this.setCalculated(false);
        if (this.graphAccessor == null) {
            this.similarity = new Double(-1.0 * Math.log(this.numCommons / this.N));
            this.setCalculated(true);
            return true;
        }
        IGraphNode iGraphNode = null;
        try {
            iGraphNode = this.graphAccessor.getMostRecentCommonAncestor(this.x, this.y);
            if (logger.isDebugEnabled()) {
                System.out.println("MRCA of " + ((Object)this.x).toString() + " and " + ((Object)this.y).toString() + " is " + ((Object)iGraphNode).toString());
            }
            double d = this.graphAccessor.size();
            double d2 = 0.0;
            d2 = this.graphAccessor.getSuccessors(iGraphNode, false).size() + 1;
            double d3 = d2 / d;
            this.similarity = d3 == 0.0 ? new Double(0.0) : new Double(-1.0 * Math.log(d3));
            this.setCalculated(true);
            return true;
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
            return false;
        }
    }
}

