/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.sequence;

import java.util.List;
import org.apache.log4j.Logger;
import simpack.accessor.string.StringAccessor;
import simpack.api.IDistanceConversion;
import simpack.api.ISequenceAccessor;
import simpack.api.impl.SequenceSimilarityMeasure;
import simpack.exception.WeightBalanceException;
import simpack.util.conversion.WorstCaseDistanceConversion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Levenshtein<E>
extends SequenceSimilarityMeasure<E> {
    private static final Logger logger = Logger.getLogger(Levenshtein.class);
    public static double DEFAULT_WEIGHT_INSERT = 1.0;
    public static double DEFAULT_WEIGHT_DELETE = 1.0;
    public static double DEFAULT_WEIGHT_REPLACE = 1.0;
    public static double DEFAULT_WEIGHT_REPLACE_EQUAL = 0.0;
    protected double weightInsert = DEFAULT_WEIGHT_INSERT;
    protected double weightDelete = DEFAULT_WEIGHT_DELETE;
    protected double weightReplace = DEFAULT_WEIGHT_REPLACE;
    protected double weightReplaceEqual = DEFAULT_WEIGHT_REPLACE_EQUAL;
    protected IDistanceConversion conversion;

    public Levenshtein(ISequenceAccessor<E> iSequenceAccessor, ISequenceAccessor<E> iSequenceAccessor2) {
        this(iSequenceAccessor, iSequenceAccessor2, DEFAULT_WEIGHT_INSERT, DEFAULT_WEIGHT_DELETE, DEFAULT_WEIGHT_REPLACE, DEFAULT_WEIGHT_REPLACE_EQUAL, new WorstCaseDistanceConversion());
    }

    public Levenshtein(ISequenceAccessor<E> iSequenceAccessor, ISequenceAccessor<E> iSequenceAccessor2, IDistanceConversion iDistanceConversion) {
        this(iSequenceAccessor, iSequenceAccessor2, DEFAULT_WEIGHT_INSERT, DEFAULT_WEIGHT_DELETE, DEFAULT_WEIGHT_REPLACE, DEFAULT_WEIGHT_REPLACE_EQUAL, iDistanceConversion);
    }

    public Levenshtein(ISequenceAccessor<E> iSequenceAccessor, ISequenceAccessor<E> iSequenceAccessor2, double d, double d2, double d3, double d4, IDistanceConversion iDistanceConversion) {
        super(iSequenceAccessor, iSequenceAccessor2);
        if (d + d2 < d3 || d + d2 < d4) {
            throw new WeightBalanceException("c(weightInsert) + c(weightDelete) <= c(weightReplace)");
        }
        this.weightInsert = d;
        this.weightDelete = d2;
        this.weightReplace = d3;
        this.weightReplaceEqual = d4;
        this.conversion = iDistanceConversion;
    }

    @Override
    public boolean calculate() {
        double d;
        double d2;
        int n;
        this.setCalculated(false);
        List list = this.sequenceAccessor1.getSequence();
        List list2 = this.sequenceAccessor2.getSequence();
        logger.debug((Object)list.toString());
        logger.debug((Object)list2.toString());
        double[][] dArray = new double[list.size() + 1][list2.size() + 1];
        for (n = 0; n <= list.size(); ++n) {
            dArray[n][0] = n;
        }
        for (n = 0; n <= list2.size(); ++n) {
            dArray[0][n] = n;
        }
        for (n = 1; n <= list2.size(); ++n) {
            for (int i = 1; i <= list.size(); ++i) {
                d2 = dArray[i][n - 1] + this.weightInsert;
                d = dArray[i - 1][n] + this.weightDelete;
                double d3 = dArray[i - 1][n - 1];
                d3 = !list.get(i - 1).equals(list2.get(n - 1)) ? (d3 += this.weightReplace) : (d3 += this.weightReplaceEqual);
                dArray[i][n] = Math.min(d2, Math.min(d3, d));
            }
        }
        double d4 = dArray[list.size()][list2.size()];
        d2 = 0.0;
        if (this.conversion instanceof WorstCaseDistanceConversion) {
            d2 = this.calculateWorstCaseDistance(((Object)this.sequenceAccessor1).toString(), ((Object)this.sequenceAccessor2).toString());
            ((WorstCaseDistanceConversion)this.conversion).setWorstCaseDistance(d2);
        }
        d = this.conversion.convert(d4);
        logger.debug((Object)("dist = " + d4 + ", wDist = " + d2 + ", sim = " + d));
        this.similarity = new Double(d);
        this.setCalculated(true);
        return true;
    }

    protected double calculateWorstCaseDistance(String string, String string2) {
        double d = string.length();
        double d2 = string2.length();
        double d3 = 0.0;
        if (d2 == d) {
            d3 = d * this.weightReplace;
        }
        if (d2 > d) {
            d3 = d * this.weightReplace;
            d3 += (d2 - d) * this.weightInsert;
        }
        if (d2 < d) {
            d3 = d2 * this.weightReplace;
            d3 += (d - d2) * this.weightDelete;
        }
        return d3;
    }

    public static void main(String[] stringArray) {
        Levenshtein<String> levenshtein = null;
        try {
            levenshtein = new Levenshtein<String>(new StringAccessor("Levenshtein"), new StringAccessor("shteinLeven"));
        }
        catch (WeightBalanceException weightBalanceException) {
            weightBalanceException.printStackTrace();
        }
        System.out.println(levenshtein.getSimilarity());
    }
}

