/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.string;

import java.util.List;
import org.apache.log4j.Logger;
import simpack.accessor.string.StringAccessor;
import simpack.api.ISequenceAccessor;
import simpack.api.impl.SequenceSimilarityMeasure;
import simpack.api.impl.SimilarityMeasure;
import simpack.exception.InvalidSimilarityMeasureNameException;
import simpack.measure.sequence.Levenshtein;
import simpack.util.conversion.WorstCaseDistanceConversion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AveragedStringMatching
extends SimilarityMeasure {
    static Logger logger = Logger.getLogger(AveragedStringMatching.class);
    private ISequenceAccessor<String> sa1;
    private ISequenceAccessor<String> sa2;
    private String sim;

    public AveragedStringMatching(ISequenceAccessor<String> iSequenceAccessor, ISequenceAccessor<String> iSequenceAccessor2) throws InvalidSimilarityMeasureNameException {
        this(iSequenceAccessor, iSequenceAccessor2, "Levenshtein-SimPack");
    }

    public AveragedStringMatching(ISequenceAccessor<String> iSequenceAccessor, ISequenceAccessor<String> iSequenceAccessor2, String string) throws InvalidSimilarityMeasureNameException {
        this.sa1 = iSequenceAccessor;
        this.sa2 = iSequenceAccessor2;
        this.sim = string;
        if (!(string.equals("Levenshtein-SimPack") || string.equals("Levenshtein-SecondString") || string.equals("Levenshtein-SimMetrics"))) {
            throw new InvalidSimilarityMeasureNameException();
        }
    }

    @Override
    public boolean calculate() {
        double d = 0.0;
        List<String> list = this.sa1.getSequence();
        for (String string : list) {
            double d2 = Double.NEGATIVE_INFINITY;
            List<String> list2 = this.sa2.getSequence();
            for (String string2 : list2) {
                SequenceSimilarityMeasure sequenceSimilarityMeasure = null;
                double d3 = 0.0;
                if (this.sim.equals("Levenshtein-SimPack")) {
                    sequenceSimilarityMeasure = new Levenshtein<String>(new StringAccessor(string), new StringAccessor(string2));
                    d3 = sequenceSimilarityMeasure.getSimilarity();
                } else if (this.sim.equals("Levenshtein-SecondString")) {
                    sequenceSimilarityMeasure = new simpack.measure.external.secondstring.Levenshtein(new StringAccessor(string), new StringAccessor(string2));
                    d3 = Math.abs(sequenceSimilarityMeasure.getSimilarity());
                    double d4 = this.calculateWorstCaseDistance(string.length(), string2.length(), 1, 1, 1);
                    WorstCaseDistanceConversion worstCaseDistanceConversion = new WorstCaseDistanceConversion(d4);
                    d3 = worstCaseDistanceConversion.convert(d3);
                } else if (this.sim.equals("Levenshtein-SimMetrics")) {
                    sequenceSimilarityMeasure = new simpack.measure.external.simmetrics.Levenshtein(string, string2);
                    d3 = sequenceSimilarityMeasure.getSimilarity();
                }
                logger.debug((Object)(string + " <-> " + string2 + " = " + d3));
                if (!(d3 >= d2)) continue;
                d2 = d3;
            }
            d += d2;
        }
        double d5 = d / (double)list.size();
        this.similarity = new Double(d5);
        this.setCalculated(true);
        return true;
    }

    private double calculateWorstCaseDistance(int n, int n2, int n3, int n4, int n5) {
        double d = 0.0;
        if (n2 > n) {
            d = n * n3;
            int n6 = n2 - n;
            d += (double)(n6 * n4);
        } else if (n == n2) {
            d = n * n3;
        } else if (n2 < n) {
            d = n2 * n3;
            int n7 = n - n2;
            d += (double)(n7 * n5);
        }
        return d;
    }
}

