/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.string;

import org.apache.log4j.Logger;
import simpack.api.impl.SimilarityMeasure;

public class Jaro
extends SimilarityMeasure {
    public static Logger logger = Logger.getLogger(Jaro.class);
    private String str1;
    private String str2;

    public Jaro(String string, String string2) {
        this.str1 = string;
        this.str2 = string2;
    }

    public boolean calculate() {
        this.str1 = this.str1.toLowerCase();
        this.str2 = this.str2.toLowerCase();
        int n = this.halfLengthOfShorter(this.str1, this.str2);
        String string = this.commonChars(this.str1, this.str2, n);
        String string2 = this.commonChars(this.str2, this.str1, n);
        if (string.length() != string2.length()) {
            logger.error((Object)("common1 != common2: '" + string + "' != '" + string2 + "'"));
            this.similarity = new Double(-1.0);
            this.setCalculated(true);
            return true;
        }
        if (string.length() == 0 || string2.length() == 0) {
            this.similarity = new Double(0.0);
            this.setCalculated(true);
            return true;
        }
        int n2 = string.length();
        int n3 = this.transpositions(string, string2);
        double d = ((double)n2 / (double)this.str1.length() + (double)n2 / (double)this.str2.length() + (double)(n2 - n3) / (double)n2) / 3.0;
        this.similarity = new Double(d);
        this.setCalculated(true);
        return true;
    }

    private int halfLengthOfShorter(String string, String string2) {
        return string.length() > string2.length() ? string2.length() / 2 + 1 : string.length() / 2 + 1;
    }

    private String commonChars(String string, String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer(string2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl = false;
            for (int j = Math.max(0, i - n); !bl && j < Math.min(i + n, string2.length()); ++j) {
                if (stringBuffer2.charAt(j) != c) continue;
                bl = true;
                stringBuffer.append(c);
                stringBuffer2.setCharAt(j, '*');
            }
        }
        return stringBuffer.toString();
    }

    private int transpositions(String string, String string2) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            ++n;
        }
        return n /= 2;
    }
}

