/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.tree;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.PriorityQueue;
import simpack.api.ITreeAccessor;
import simpack.api.ITreeNode;
import simpack.api.ITreeNodeComparator;
import simpack.api.impl.TreeSimilarityMeasure;
import simpack.exception.InvalidElementException;
import simpack.util.tree.EquivalenceClassCalculator;
import simpack.util.tree.NodePriority;
import simpack.util.tree.TreeNode;
import simpack.util.tree.TreeNodePriorityTuple;
import simpack.util.tree.TreeUtil;
import simpack.util.tree.comparator.AlwaysTrueTreeNodeComparator;
import simpack.util.tree.comparator.NodeComparator;
import simpack.util.tree.visitor.BuildTreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BottomUpMaximumSubtree
extends TreeSimilarityMeasure {
    private ITreeNode tree1;
    private List<ITreeNode> list1 = null;
    private PriorityQueue<TreeNodePriorityTuple> queue1 = new PriorityQueue<TreeNodePriorityTuple>(3, new NodeComparator());
    private LinkedHashMap<ITreeNode, Integer> size1 = new LinkedHashMap();
    private ArrayList<ITreeNode> subtreeRootNodesTree1 = new ArrayList();
    private ITreeNode tree2;
    private List<ITreeNode> list2 = null;
    private boolean ordered;
    private boolean labeled;
    private PriorityQueue<TreeNodePriorityTuple> queue2 = new PriorityQueue<TreeNodePriorityTuple>(3, new NodeComparator());
    private LinkedHashMap<ITreeNode, Integer> size2 = new LinkedHashMap();
    private ArrayList<ITreeNode> subtreeRootNodesTree2 = new ArrayList();
    private EquivalenceClassCalculator equivalenceClass = null;
    private HashMap<TreeNode, TreeNode> orderedMapping;

    public BottomUpMaximumSubtree(ITreeAccessor iTreeAccessor, ITreeAccessor iTreeAccessor2) throws NullPointerException, InvalidElementException {
        this(iTreeAccessor, iTreeAccessor2, new AlwaysTrueTreeNodeComparator());
    }

    public BottomUpMaximumSubtree(ITreeAccessor iTreeAccessor, ITreeAccessor iTreeAccessor2, ITreeNodeComparator<ITreeNode> iTreeNodeComparator) throws NullPointerException, InvalidElementException {
        this(iTreeAccessor, iTreeAccessor2, iTreeNodeComparator, false);
    }

    public BottomUpMaximumSubtree(ITreeAccessor iTreeAccessor, ITreeAccessor iTreeAccessor2, ITreeNodeComparator<ITreeNode> iTreeNodeComparator, boolean bl) throws NullPointerException, InvalidElementException {
        this(iTreeAccessor, iTreeAccessor2, iTreeNodeComparator, bl, false);
    }

    public BottomUpMaximumSubtree(ITreeAccessor iTreeAccessor, ITreeAccessor iTreeAccessor2, ITreeNodeComparator<ITreeNode> iTreeNodeComparator, boolean bl, boolean bl2) throws NullPointerException, InvalidElementException {
        super(iTreeNodeComparator);
        if (iTreeAccessor == null || iTreeAccessor2 == null || iTreeAccessor.getRoot() == null || iTreeAccessor2.getRoot() == null) {
            throw new NullPointerException("Invalid accessors passed!");
        }
        this.ordered = bl;
        this.labeled = bl2;
        this.tree1 = iTreeAccessor.getRoot();
        this.tree2 = iTreeAccessor2.getRoot();
        this.list1 = TreeUtil.enumerationToList(this.tree1.postorderEnumeration());
        this.list2 = TreeUtil.enumerationToList(this.tree2.postorderEnumeration());
        if (this.list1 == null || this.list2 == null) {
            throw new NullPointerException("Postorder lists were not initialized.");
        }
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        try {
            this.equivalenceClass = new EquivalenceClassCalculator(this.tree1, this.list1, this.tree2, this.list2, this.ordered, this.labeled);
            if (!this.equivalenceClass.calculate() || !this.equivalenceClass.isCalculated()) {
                return false;
            }
            this.queue1 = this.calculateQueue(this.list1, this.equivalenceClass.getEquivalenceClassesTree1(), this.size1);
            this.queue2 = this.calculateQueue(this.list2, this.equivalenceClass.getEquivalenceClassesTree2(), this.size2);
        }
        catch (Exception exception) {
            return false;
        }
        ITreeNode iTreeNode = this.findMaxCommonSubtree();
        if (iTreeNode == null) {
            return false;
        }
        this.setCalculated(true);
        List<ITreeNode> list = null;
        try {
            list = TreeUtil.enumerationToList(iTreeNode.preorderEnumeration());
        }
        catch (InvalidElementException invalidElementException) {
            return false;
        }
        if (list == null) {
            return false;
        }
        HashMap<TreeNode, TreeNode> hashMap = null;
        try {
            hashMap = this.mapTrees(this.getSubtreeRootNodesTree1().get(0), this.getSubtreeRootNodesTree2().get(0));
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (InvalidElementException invalidElementException) {
            return false;
        }
        if (hashMap == null) {
            return false;
        }
        BuildTreeVisitor buildTreeVisitor = new BuildTreeVisitor(hashMap, this.getSubtreeRootNodesTree1().get(0));
        ITreeNode iTreeNode2 = buildTreeVisitor.getTree();
        this.similarity = TreeUtil.getSimilarity1to1(this.getTree1(), this.getTree2(), iTreeNode2);
        return true;
    }

    private ITreeNode findMaxCommonSubtree() {
        ArrayList<TreeNodePriorityTuple> arrayList = this.copyQueue(this.queue1);
        ArrayList<TreeNodePriorityTuple> arrayList2 = this.copyQueue(this.queue2);
        TreeNodePriorityTuple treeNodePriorityTuple = null;
        TreeNodePriorityTuple treeNodePriorityTuple2 = null;
        while (!this.queue1.isEmpty() && !this.queue2.isEmpty()) {
            treeNodePriorityTuple = this.queue1.peek();
            treeNodePriorityTuple2 = this.queue2.peek();
            if (treeNodePriorityTuple.getPriority().getCode().equals(treeNodePriorityTuple2.getPriority().getCode())) {
                this.subtreeRootNodesTree1.add(treeNodePriorityTuple.getNode());
                this.subtreeRootNodesTree2.add(treeNodePriorityTuple2.getNode());
                this.subtreeRootNodesTree1.addAll(this.findSame(treeNodePriorityTuple, arrayList));
                this.subtreeRootNodesTree2.addAll(this.findSame(treeNodePriorityTuple2, arrayList2));
                break;
            }
            if (NodePriority.compare(treeNodePriorityTuple.getPriority(), treeNodePriorityTuple2.getPriority()) == -1) {
                this.queue1.remove(treeNodePriorityTuple);
                continue;
            }
            this.queue2.remove(treeNodePriorityTuple2);
        }
        if (treeNodePriorityTuple == null || treeNodePriorityTuple2 == null) {
            return null;
        }
        return treeNodePriorityTuple.getNode();
    }

    private ArrayList<ITreeNode> findSame(TreeNodePriorityTuple treeNodePriorityTuple, ArrayList<TreeNodePriorityTuple> arrayList) {
        ArrayList<ITreeNode> arrayList2 = new ArrayList<ITreeNode>();
        for (TreeNodePriorityTuple treeNodePriorityTuple2 : arrayList) {
            if (treeNodePriorityTuple2.equals(treeNodePriorityTuple) || !treeNodePriorityTuple2.getPriority().getCode().equals(treeNodePriorityTuple.getPriority().getCode())) continue;
            arrayList2.add(treeNodePriorityTuple2.getNode());
        }
        return arrayList2;
    }

    private ArrayList<TreeNodePriorityTuple> copyQueue(PriorityQueue<TreeNodePriorityTuple> priorityQueue) {
        ArrayList<TreeNodePriorityTuple> arrayList = new ArrayList<TreeNodePriorityTuple>();
        for (TreeNodePriorityTuple treeNodePriorityTuple : priorityQueue) {
            arrayList.add(treeNodePriorityTuple);
        }
        return arrayList;
    }

    private PriorityQueue<TreeNodePriorityTuple> calculateQueue(List<ITreeNode> list, LinkedHashMap<ITreeNode, Integer> linkedHashMap, LinkedHashMap<ITreeNode, Integer> linkedHashMap2) throws InvalidElementException {
        PriorityQueue<TreeNodePriorityTuple> priorityQueue = new PriorityQueue<TreeNodePriorityTuple>(3, new NodeComparator());
        ListIterator<ITreeNode> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            ITreeNode iTreeNode = listIterator.next();
            linkedHashMap2.put(iTreeNode, new Integer(1));
            if (!iTreeNode.isLeaf()) {
                object = iTreeNode.children();
                while (object.hasMoreElements()) {
                    javax.swing.tree.TreeNode treeNode = object.nextElement();
                    if (treeNode instanceof ITreeNode) {
                        linkedHashMap2.put(iTreeNode, linkedHashMap2.get(iTreeNode) + linkedHashMap2.get((ITreeNode)treeNode));
                        continue;
                    }
                    throw new InvalidElementException("Unexpected child type in Tree while calculating child size.");
                }
            }
            object = new TreeNodePriorityTuple(iTreeNode, new NodePriority(linkedHashMap2.get(iTreeNode), linkedHashMap.get(iTreeNode)));
            priorityQueue.add((TreeNodePriorityTuple)object);
        }
        return priorityQueue;
    }

    public HashMap<TreeNode, TreeNode> mapTrees(ITreeNode iTreeNode, ITreeNode iTreeNode2) throws InvalidElementException {
        if (this.ordered) {
            return this.mapOrderedTrees(iTreeNode, iTreeNode2);
        }
        return this.mapUnorderedTrees(iTreeNode, iTreeNode2);
    }

    private HashMap<TreeNode, TreeNode> mapUnorderedTrees(ITreeNode iTreeNode, ITreeNode iTreeNode2) throws InvalidElementException {
        HashMap<TreeNode, TreeNode> hashMap = new HashMap<TreeNode, TreeNode>();
        if (iTreeNode == null || iTreeNode2 == null) {
            return null;
        }
        if (!iTreeNode.getRoot().equals(this.tree1.getRoot()) || !iTreeNode2.getRoot().equals(this.tree2.getRoot())) {
            return null;
        }
        if (!this.equivalenceClass.getEquivalenceClassesTree1().get(iTreeNode).equals(this.equivalenceClass.getEquivalenceClassesTree2().get(iTreeNode2))) {
            return null;
        }
        List<ITreeNode> list = null;
        list = TreeUtil.enumerationToList(iTreeNode.preorderEnumeration());
        if (list == null) {
            throw new InvalidElementException();
        }
        hashMap.put((TreeNode)iTreeNode, (TreeNode)iTreeNode2);
        HashMap<ITreeNode, Boolean> hashMap2 = new HashMap<ITreeNode, Boolean>();
        ListIterator<ITreeNode> listIterator = list.listIterator(1);
        block0: while (listIterator.hasNext()) {
            ITreeNode iTreeNode3 = listIterator.next();
            Enumeration<javax.swing.tree.TreeNode> enumeration = hashMap.get(iTreeNode3.getParent()).children();
            while (enumeration.hasMoreElements()) {
                javax.swing.tree.TreeNode treeNode = enumeration.nextElement();
                if (treeNode instanceof ITreeNode) {
                    ITreeNode iTreeNode4 = (ITreeNode)treeNode;
                    if (!this.equivalenceClass.getEquivalenceClassesTree1().get(iTreeNode3).equals(this.equivalenceClass.getEquivalenceClassesTree2().get(iTreeNode4)) || hashMap2.containsKey(iTreeNode4) && ((Boolean)hashMap2.get(iTreeNode4)).booleanValue()) continue;
                    hashMap.put((TreeNode)iTreeNode3, (TreeNode)iTreeNode4);
                    hashMap2.put(iTreeNode4, true);
                    continue block0;
                }
                throw new InvalidElementException();
            }
        }
        return hashMap;
    }

    private HashMap<TreeNode, TreeNode> mapOrderedTrees(ITreeNode iTreeNode, ITreeNode iTreeNode2) {
        this.orderedMapping = new HashMap();
        if (this.mapOrderedSubtrees(iTreeNode, iTreeNode2)) {
            return this.orderedMapping;
        }
        return null;
    }

    private boolean mapOrderedSubtrees(ITreeNode iTreeNode, ITreeNode iTreeNode2) {
        if (iTreeNode == null || iTreeNode2 == null) {
            return false;
        }
        if (!iTreeNode.getRoot().equals(this.tree1.getRoot()) || !iTreeNode2.getRoot().equals(this.tree2.getRoot())) {
            return false;
        }
        if (!this.equivalenceClass.getEquivalenceClassesTree1().get(iTreeNode).equals(this.equivalenceClass.getEquivalenceClassesTree2().get(iTreeNode2))) {
            return false;
        }
        if (this.comparator.compare(iTreeNode, iTreeNode2) != 0) {
            return false;
        }
        this.orderedMapping.put((TreeNode)iTreeNode, (TreeNode)iTreeNode2);
        if (iTreeNode.getChildCount() > iTreeNode2.getChildCount()) {
            return false;
        }
        if (!iTreeNode.isLeaf()) {
            ITreeNode iTreeNode3;
            ITreeNode iTreeNode4 = iTreeNode.getFirstChild();
            if (!this.mapOrderedSubtrees(iTreeNode4, iTreeNode3 = iTreeNode2.getFirstChild())) {
                return false;
            }
            for (int i = 2; i <= iTreeNode.getChildCount(); ++i) {
                if (this.mapOrderedSubtrees(iTreeNode4 = iTreeNode.getChildAfter(iTreeNode4), iTreeNode3 = iTreeNode2.getChildAfter(iTreeNode3))) continue;
                return false;
            }
        }
        return true;
    }

    public LinkedHashMap<ITreeNode, Integer> getEquivalenceClassTree1() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.equivalenceClass.getEquivalenceClassesTree1();
    }

    public LinkedHashMap<ITreeNode, Integer> getEquivalenceClassTree2() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.equivalenceClass.getEquivalenceClassesTree2();
    }

    public LinkedHashMap<ITreeNode, Integer> getSizeTree1() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.size1;
    }

    public LinkedHashMap<ITreeNode, Integer> getSizeTree2() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.size2;
    }

    public ArrayList<ITreeNode> getSubtreeRootNodesTree1() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.subtreeRootNodesTree1;
    }

    public ArrayList<ITreeNode> getSubtreeRootNodesTree2() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.subtreeRootNodesTree2;
    }

    public ITreeNode getTree1() {
        return this.tree1;
    }

    public ITreeNode getTree2() {
        return this.tree2;
    }
}

