/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.tree;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.alg.DijkstraShortestPath;
import org._3pq.jgrapht.graph.SimpleDirectedWeightedGraph;
import simpack.api.ITreeAccessor;
import simpack.api.ITreeNode;
import simpack.api.ITreeNodeComparator;
import simpack.api.impl.AbstractDistanceConversion;
import simpack.api.impl.TreeSimilarityMeasure;
import simpack.exception.InvalidElementException;
import simpack.util.conversion.WorstCaseDistanceConversion;
import simpack.util.tree.GraphVertexTuple;
import simpack.util.tree.TreeNodeTuple;
import simpack.util.tree.TreeUtil;
import simpack.util.tree.comparator.AlwaysTrueTreeNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeEditDistance
extends TreeSimilarityMeasure {
    public static double DEFAULT_WEIGHT_DELETE = 1.0;
    public static double DEFAULT_WEIGHT_INSERT = 1.0;
    public static double DEFAULT_WEIGHT_SUBSTITUE = 1.0;
    public static double DEFAULT_WEIGHT_SUBSTITUE_EQUAL = 0.0;
    public static double DEFAULT_PATH_LENGTH_LIMIT = Double.POSITIVE_INFINITY;
    private ITreeNode tree1;
    private List<ITreeNode> list1 = null;
    private HashMap<ITreeNode, Integer> depth1 = new HashMap();
    private ITreeNode tree2;
    private List<ITreeNode> list2 = null;
    private HashMap<ITreeNode, Integer> depth2 = new HashMap();
    private double pathLengthLimit = DEFAULT_PATH_LENGTH_LIMIT;
    private SimpleDirectedWeightedGraph editDistanceGraph;
    private GraphVertexTuple firstVertex;
    private GraphVertexTuple lastVertex;
    private double weightDelete = DEFAULT_WEIGHT_DELETE;
    private double weightInsert = DEFAULT_WEIGHT_INSERT;
    private double weightSubstitute = DEFAULT_WEIGHT_SUBSTITUE;
    private double weightSubstituteEqual = DEFAULT_WEIGHT_SUBSTITUE_EQUAL;
    private DijkstraShortestPath shortestPath;
    private AbstractDistanceConversion conversion;

    public TreeEditDistance(ITreeAccessor iTreeAccessor, ITreeAccessor iTreeAccessor2) throws NullPointerException, InvalidElementException {
        this(iTreeAccessor, iTreeAccessor2, new AlwaysTrueTreeNodeComparator(), new WorstCaseDistanceConversion());
    }

    public TreeEditDistance(ITreeAccessor iTreeAccessor, ITreeAccessor iTreeAccessor2, ITreeNodeComparator<ITreeNode> iTreeNodeComparator, AbstractDistanceConversion abstractDistanceConversion) throws NullPointerException, InvalidElementException {
        this(iTreeAccessor, iTreeAccessor2, iTreeNodeComparator, abstractDistanceConversion, DEFAULT_PATH_LENGTH_LIMIT, DEFAULT_WEIGHT_INSERT, DEFAULT_WEIGHT_DELETE, DEFAULT_WEIGHT_SUBSTITUE);
    }

    public TreeEditDistance(ITreeAccessor iTreeAccessor, ITreeAccessor iTreeAccessor2, Double d, Double d2, Double d3, Double d4) throws NullPointerException, InvalidElementException {
        this(iTreeAccessor, iTreeAccessor2, new AlwaysTrueTreeNodeComparator(), new WorstCaseDistanceConversion(), d, d2, d3, d4);
    }

    public TreeEditDistance(ITreeAccessor iTreeAccessor, ITreeAccessor iTreeAccessor2, ITreeNodeComparator<ITreeNode> iTreeNodeComparator, AbstractDistanceConversion abstractDistanceConversion, Double d, Double d2, Double d3, Double d4) throws NullPointerException, InvalidElementException {
        this(iTreeAccessor, iTreeAccessor2, iTreeNodeComparator, abstractDistanceConversion, d, d2, d3, d4, null);
    }

    public TreeEditDistance(ITreeAccessor iTreeAccessor, ITreeAccessor iTreeAccessor2, ITreeNodeComparator<ITreeNode> iTreeNodeComparator, AbstractDistanceConversion abstractDistanceConversion, Double d, Double d2, Double d3, Double d4, Double d5) throws NullPointerException, InvalidElementException {
        super(iTreeNodeComparator);
        this.conversion = abstractDistanceConversion;
        if (iTreeAccessor == null || iTreeAccessor2 == null || iTreeAccessor.getRoot() == null || iTreeAccessor2.getRoot() == null) {
            throw new NullPointerException("Invalid accessors passed!");
        }
        this.tree1 = iTreeAccessor.getRoot();
        this.tree2 = iTreeAccessor2.getRoot();
        this.list1 = TreeUtil.enumerationToList(this.tree1.preorderEnumeration());
        this.list2 = TreeUtil.enumerationToList(this.tree2.preorderEnumeration());
        if (d != null) {
            this.pathLengthLimit = d;
        }
        if (d2 != null) {
            this.weightInsert = d2;
        }
        if (d3 != null) {
            this.weightDelete = d3;
        }
        if (d4 != null) {
            this.weightSubstitute = d4;
        }
        if (d5 != null) {
            this.weightSubstituteEqual = d5;
        }
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        if (this.calculateGraph()) {
            this.shortestPath = new DijkstraShortestPath((Graph)this.editDistanceGraph, (Object)this.firstVertex, (Object)this.lastVertex, this.pathLengthLimit);
            if (this.shortestPath != null) {
                this.setCalculated(true);
                if (this.conversion instanceof WorstCaseDistanceConversion) {
                    ((WorstCaseDistanceConversion)this.conversion).setWorstCaseDistance(this.getWorstCaseSumOfNodes());
                }
                this.similarity = new Double(this.conversion.convert(this.getTreeEditDistance()));
                return true;
            }
        }
        return false;
    }

    private boolean calculateGraph() {
        GraphVertexTuple graphVertexTuple;
        int n;
        GraphVertexTuple[][] graphVertexTupleArray;
        int n2 = this.list1.size();
        int n3 = this.list2.size();
        HashMap<ITreeNode, Integer> hashMap = new HashMap<ITreeNode, Integer>();
        HashMap<ITreeNode, Integer> hashMap2 = new HashMap<ITreeNode, Integer>();
        this.preorderTreeDepth(this.tree1, hashMap, this.depth1);
        this.preorderTreeDepth(this.tree2, hashMap2, this.depth2);
        int[] nArray = new int[n2 + 1];
        int[] nArray2 = new int[n3 + 1];
        ListIterator<ITreeNode> listIterator = this.list1.listIterator();
        while (listIterator.hasNext()) {
            graphVertexTupleArray = (GraphVertexTuple[][])listIterator.next();
            nArray[hashMap.get((Object)graphVertexTupleArray).intValue()] = this.depth1.get(graphVertexTupleArray);
        }
        listIterator = this.list2.listIterator();
        while (listIterator.hasNext()) {
            graphVertexTupleArray = (ITreeNode)listIterator.next();
            nArray2[hashMap2.get((Object)graphVertexTupleArray).intValue()] = this.depth2.get(graphVertexTupleArray);
        }
        this.editDistanceGraph = new SimpleDirectedWeightedGraph();
        graphVertexTupleArray = new GraphVertexTuple[n2 + 1][n3 + 1];
        for (n = 0; n <= n2; ++n) {
            for (int i = 0; i <= n3; ++i) {
                graphVertexTuple = new GraphVertexTuple(new Integer(n), new Integer(i));
                if (n > 0 && i > 0) {
                    graphVertexTuple.setTreeNodeTuple(new TreeNodeTuple(this.list1.get(n - 1), this.list2.get(i - 1)));
                }
                graphVertexTupleArray[n][i] = graphVertexTuple;
                if (this.editDistanceGraph.addVertex((Object)graphVertexTuple)) continue;
                return false;
            }
        }
        this.firstVertex = graphVertexTupleArray[0][0];
        this.lastVertex = graphVertexTupleArray[n2][n3];
        for (n = 0; n < n2; ++n) {
            Edge edge = this.editDistanceGraph.addEdge((Object)graphVertexTupleArray[n][n3], (Object)graphVertexTupleArray[n + 1][n3]);
            if (edge == null) {
                return false;
            }
            edge.setWeight(this.weightDelete);
        }
        for (n = 0; n < n3; ++n) {
            Edge edge = this.editDistanceGraph.addEdge((Object)graphVertexTupleArray[n2][n], (Object)graphVertexTupleArray[n2][n + 1]);
            if (edge == null) {
                return false;
            }
            edge.setWeight(this.weightInsert);
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                if (nArray[n + 1] >= nArray2[i + 1]) {
                    graphVertexTuple = this.editDistanceGraph.addEdge((Object)graphVertexTupleArray[n][i], (Object)graphVertexTupleArray[n + 1][i]);
                    if (graphVertexTuple == null) {
                        return false;
                    }
                    graphVertexTuple.setWeight(this.weightDelete);
                }
                if (nArray[n + 1] == nArray2[i + 1]) {
                    graphVertexTuple = this.editDistanceGraph.addEdge((Object)graphVertexTupleArray[n][i], (Object)graphVertexTupleArray[n + 1][i + 1]);
                    if (graphVertexTuple == null) {
                        return false;
                    }
                    if (this.comparator.compare(this.list1.get(n), this.list2.get(i)) == 0) {
                        graphVertexTuple.setWeight(this.weightSubstituteEqual);
                    } else {
                        graphVertexTuple.setWeight(this.weightSubstitute);
                    }
                }
                if (nArray[n + 1] > nArray2[i + 1]) continue;
                graphVertexTuple = this.editDistanceGraph.addEdge((Object)graphVertexTupleArray[n][i], (Object)graphVertexTupleArray[n][i + 1]);
                if (graphVertexTuple == null) {
                    return false;
                }
                graphVertexTuple.setWeight(this.weightInsert);
            }
        }
        return true;
    }

    private void preorderTreeDepth(ITreeNode iTreeNode, HashMap<ITreeNode, Integer> hashMap, HashMap<ITreeNode, Integer> hashMap2) {
        hashMap.clear();
        hashMap2.clear();
        Stack<ITreeNode> stack = new Stack<ITreeNode>();
        stack.push(iTreeNode.getRoot());
        int n = 1;
        do {
            ITreeNode iTreeNode2 = (ITreeNode)stack.pop();
            hashMap.put(iTreeNode2, n++);
            if (iTreeNode2.isRoot()) {
                hashMap2.put(iTreeNode2, 0);
            } else {
                hashMap2.put(iTreeNode2, hashMap2.get(iTreeNode2.getParent()) + 1);
            }
            try {
            }
            catch (NoSuchElementException noSuchElementException) {
                continue;
            }
            for (ITreeNode iTreeNode3 = iTreeNode2.getLastChild(); iTreeNode3 != null; iTreeNode3 = iTreeNode3.getPreviousSibling()) {
                stack.push(iTreeNode3);
            }
        } while (!stack.isEmpty());
    }

    public boolean hasValidEditDistance() {
        return this.isCalculated() && this.getTreeEditDistance() != Double.POSITIVE_INFINITY && this.shortestPath.getPathEdgeList() != null;
    }

    public double getTreeEditDistance() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.shortestPath.getPathLength();
    }

    public double getWorstCaseSumOfNodes() {
        return this.list1.size() + this.list2.size();
    }

    public double getWorstCaseSubstituteAll() {
        Edge edge2;
        double d = -1.0;
        SimpleDirectedWeightedGraph simpleDirectedWeightedGraph = new SimpleDirectedWeightedGraph();
        Set set = this.editDistanceGraph.vertexSet();
        Set set2 = this.editDistanceGraph.edgeSet();
        simpleDirectedWeightedGraph.addAllVertices((Collection)set);
        simpleDirectedWeightedGraph.addAllEdges((Collection)set2);
        set2 = simpleDirectedWeightedGraph.edgeSet();
        for (Edge edge2 : set2) {
            GraphVertexTuple graphVertexTuple = (GraphVertexTuple)edge2.getSource();
            GraphVertexTuple graphVertexTuple2 = (GraphVertexTuple)edge2.getTarget();
            if (graphVertexTuple2.getLeft() != graphVertexTuple.getLeft() + 1 || graphVertexTuple2.getRight() != graphVertexTuple.getRight() + 1) continue;
            edge2.setWeight(this.weightSubstitute);
        }
        edge2 = new DijkstraShortestPath((Graph)simpleDirectedWeightedGraph, (Object)this.firstVertex, (Object)this.lastVertex, this.pathLengthLimit);
        d = edge2.getPathLength();
        return d;
    }

    public double getWorstCaseRetainStructure() {
        double d = 0.0;
        GraphVertexTuple graphVertexTuple = this.firstVertex;
        while (graphVertexTuple != this.lastVertex) {
            Edge edge5;
            Edge edge2 = null;
            Edge edge3 = null;
            Edge edge4 = null;
            List list = this.editDistanceGraph.outgoingEdgesOf((Object)graphVertexTuple);
            for (Edge edge5 : list) {
                GraphVertexTuple graphVertexTuple2 = (GraphVertexTuple)edge5.oppositeVertex((Object)graphVertexTuple);
                int n = graphVertexTuple.getLeft();
                int n2 = graphVertexTuple.getRight();
                int n3 = graphVertexTuple2.getLeft();
                int n4 = graphVertexTuple2.getRight();
                if (n3 == n + 1 && n4 == n2 + 1) {
                    edge4 = edge5;
                    break;
                }
                if (n3 == n + 1 && n4 == n2) {
                    edge2 = edge5;
                    continue;
                }
                edge3 = edge5;
            }
            double d2 = 0.0;
            if (edge4 != null) {
                edge5 = edge4;
                d2 = this.weightSubstitute;
            } else if (edge2 != null) {
                edge5 = edge2;
                d2 = edge5.getWeight();
            } else {
                edge5 = edge3;
                d2 = edge5.getWeight();
            }
            d += d2;
            graphVertexTuple = (GraphVertexTuple)edge5.oppositeVertex((Object)graphVertexTuple);
        }
        return d;
    }

    public double getWeightDelete() {
        return this.weightDelete;
    }

    public void setWeightDelete(double d) {
        this.weightDelete = d;
    }

    public double getWeightInsert() {
        return this.weightInsert;
    }

    public void setWeightInsert(double d) {
        this.weightInsert = d;
    }

    public double getWeightSubstitute() {
        return this.weightSubstitute;
    }

    public void setWeightSubstitute(double d) {
        this.weightSubstitute = d;
    }

    public DijkstraShortestPath getShortestPath() {
        return this.shortestPath;
    }
}

