/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.vector;

import java.util.Vector;
import org.apache.log4j.Logger;
import simpack.api.impl.FeatureVectorSimilarityMeasure;
import simpack.api.impl.SimilarityMeasure;
import simpack.exception.InvalidVectorSizeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Alignment<E>
extends SimilarityMeasure {
    private static Logger logger = Logger.getLogger(Alignment.class);
    private Vector<E> v1;
    private Vector<E> v2;
    private Vector<E> v1Aligned;
    private Vector<E> v2Aligned;
    private simpack.util.Vector<Double> v1AlignedBinary;
    private simpack.util.Vector<Double> v2AlignedBinary;
    private FeatureVectorSimilarityMeasure m;

    public Alignment(Vector<E> vector, Vector<E> vector2, FeatureVectorSimilarityMeasure featureVectorSimilarityMeasure) {
        this.m = featureVectorSimilarityMeasure;
        this.v1 = vector;
        this.v2 = vector2;
        this.align();
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        try {
            this.m.setVector(this.v1AlignedBinary, this.v2AlignedBinary);
            if (this.m.calculate()) {
                this.setCalculated(true);
                this.similarity = new Double(this.m.getSimilarity());
                return this.m.isCalculated();
            }
            return false;
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
            return false;
        }
    }

    private void align() {
        Object object2;
        Vector<E> vector = new Vector<E>(this.v1.size());
        Vector<E> vector2 = new Vector<E>(this.v1.size());
        Vector<E> vector3 = new Vector<E>(this.v2.size());
        for (Object object2 : this.v1) {
            vector.add(object2);
            vector2.add(object2);
        }
        for (Object object2 : this.v2) {
            vector3.add(object2);
        }
        this.v1.removeAll(this.v2);
        this.v2.removeAll(vector);
        vector.retainAll(vector3);
        this.v1.addAll(vector);
        this.v1.addAll(this.v2);
        Vector<E> vector4 = this.v1;
        this.v1 = vector2;
        this.v2 = vector3;
        logger.debug((Object)vector4.toString());
        logger.debug((Object)this.v1.toString());
        logger.debug((Object)this.v2.toString());
        this.v1Aligned = new Vector();
        this.v2Aligned = new Vector();
        this.v1AlignedBinary = new simpack.util.Vector();
        this.v2AlignedBinary = new simpack.util.Vector();
        object2 = vector4.iterator();
        while (object2.hasNext()) {
            Object e = object2.next();
            if (this.v1.contains(e)) {
                this.v1AlignedBinary.add(1.0);
                this.v1Aligned.add(e);
            } else {
                this.v1AlignedBinary.add(0.0);
                this.v1Aligned.add(null);
            }
            if (this.v2.contains(e)) {
                this.v2AlignedBinary.add(1.0);
                this.v2Aligned.add(e);
                continue;
            }
            this.v2AlignedBinary.add(0.0);
            this.v2Aligned.add(null);
        }
        logger.debug((Object)this.v1AlignedBinary.toString());
        logger.debug((Object)this.v2AlignedBinary.toString());
    }
}

