/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.vector;

import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import simpack.accessor.string.StringAccessor;
import simpack.api.impl.FeatureVectorSimilarityMeasure;
import simpack.api.impl.SimilarityMeasure;
import simpack.exception.InvalidVectorSizeException;
import simpack.measure.sequence.Levenshtein;
import simpack.measure.vector.Cosine;
import simpack.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentComparison
extends SimilarityMeasure {
    private static final Logger logger = Logger.getLogger(AlignmentComparison.class);
    private FeatureVectorSimilarityMeasure featureVector = new Cosine();
    private String textNodeComparator = "Levenshtein";
    private double thresholdText = 0.75;
    private Map<Object, Object> map1;
    private Map<Object, Object> map2;

    public AlignmentComparison(Map<Object, Object> map, Map<Object, Object> map2, String string, double d) {
        this.map1 = map;
        this.map2 = map2;
        this.textNodeComparator = string;
        this.thresholdText = d;
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        try {
            this.similarity = new Double(this.score());
            this.setCalculated(true);
            return true;
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
            return false;
        }
    }

    private Double score() throws InvalidVectorSizeException {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll(this.map1.keySet());
        hashSet.addAll(this.map2.keySet());
        Vector<Double> vector = new Vector<Double>();
        Vector<Double> vector2 = new Vector<Double>();
        for (Object e : hashSet) {
            if (this.map1.containsKey(e) && this.map2.containsKey(e)) {
                Object object = this.map1.get(e);
                Object object2 = this.map2.get(e);
                if (object != null && object2 != null) {
                    boolean bl = this.compareText(object, object2);
                    if (bl) {
                        vector.add(1.0);
                        vector2.add(1.0);
                        vector.add(2.0);
                        vector2.add(2.0);
                        continue;
                    }
                    vector.add(1.0);
                    vector2.add(1.0);
                    vector.add(-0.5);
                    vector2.add(0.5);
                    continue;
                }
                vector.add(1.0);
                vector2.add(1.0);
                vector.add(-0.5);
                vector2.add(0.5);
                continue;
            }
            if (this.map1.containsKey(e)) {
                vector.add(1.0);
                vector2.add(0.0);
                continue;
            }
            if (!this.map2.containsKey(e)) continue;
            vector.add(0.0);
            vector2.add(1.0);
        }
        this.featureVector.setVector(vector, vector2);
        if (logger.isDebugEnabled()) {
            for (int i = 0; i < vector.size(); ++i) {
                System.out.println(vector.get(i) + " " + vector2.get(i));
            }
        }
        return this.featureVector.getSimilarity();
    }

    private boolean compareText(Object object, Object object2) {
        String string = object.toString();
        String string2 = object2.toString();
        if (this.textNodeComparator == "EQUAL") {
            return string.equalsIgnoreCase(string2);
        }
        if (this.textNodeComparator == "Levenshtein") {
            Levenshtein<String> levenshtein = new Levenshtein<String>(new StringAccessor(string), new StringAccessor(string2));
            double d = levenshtein.getSimilarity();
            return d >= this.thresholdText;
        }
        return false;
    }
}

