/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.vector;

import simpack.api.IDistanceConversion;
import simpack.api.impl.FeatureVectorSimilarityMeasure;
import simpack.exception.InvalidVectorSizeException;
import simpack.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Euclidean
extends FeatureVectorSimilarityMeasure {
    private IDistanceConversion conversion = FeatureVectorSimilarityMeasure.CONVERSION;

    public Euclidean() {
    }

    public Euclidean(Vector<? extends Number> vector, Vector<? extends Number> vector2) throws InvalidVectorSizeException {
        this(vector, vector2, null);
    }

    public Euclidean(Vector<? extends Number> vector, Vector<? extends Number> vector2, IDistanceConversion iDistanceConversion) throws InvalidVectorSizeException {
        super(vector, vector2);
        if (iDistanceConversion != null) {
            this.conversion = iDistanceConversion;
        }
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        try {
            double d = this.v1.getEuclideanDistance(this.v2);
            this.similarity = new Double(this.conversion.convert(d));
            this.setCalculated(true);
            return true;
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
            return false;
        }
    }
}

