/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.vector;

import simpack.api.impl.FeatureVectorSimilarityMeasure;
import simpack.exception.InvalidVectorSizeException;
import simpack.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jaccard
extends FeatureVectorSimilarityMeasure {
    public Jaccard() {
    }

    public Jaccard(Vector<? extends Number> vector, Vector<? extends Number> vector2) throws InvalidVectorSizeException {
        super(vector, vector2);
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        double d = 0.0;
        try {
            d = this.v1.getDotProduct(this.v2);
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
            return false;
        }
        double d2 = Math.pow(this.v1.getNorm(2.0), 2.0);
        double d3 = Math.pow(this.v2.getNorm(2.0), 2.0);
        this.similarity = new Double(d / (d2 + d3 - d));
        this.setCalculated(true);
        return true;
    }
}

