/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.vector;

import simpack.api.impl.FeatureVectorSimilarityMeasure;
import simpack.exception.InvalidVectorSizeException;
import simpack.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pearson
extends FeatureVectorSimilarityMeasure {
    public Pearson() {
    }

    public Pearson(Vector<? extends Number> vector, Vector<? extends Number> vector2) throws InvalidVectorSizeException {
        super(vector, vector2);
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        double d = 0.0;
        try {
            d = this.v1.getDotProduct(this.v2);
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
            return false;
        }
        double d2 = this.v1.getNorm(1.0) * this.v2.getNorm(1.0);
        double d3 = Math.pow(this.v1.getNorm(2.0), 2.0);
        double d4 = Math.pow(this.v1.getNorm(1.0), 2.0);
        double d5 = Math.pow(this.v2.getNorm(2.0), 2.0);
        double d6 = Math.pow(this.v2.getNorm(1.0), 2.0);
        double d7 = this.v1.size();
        this.similarity = new Double(d - d2 / d7) / Math.sqrt((d3 - d4 / d7) * (d5 - d6 / d7));
        this.setCalculated(true);
        return true;
    }
}

