/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.accessor.string;

import java.util.List;
import junit.framework.TestCase;
import simpack.accessor.string.StringAccessor;
import simpack.tokenizer.SplittedStringTokenizer;

public class StringAccessorTest
extends TestCase {
    public void testStringAccessor() {
        StringAccessor stringAccessor = new StringAccessor("Test");
        List<String> list = stringAccessor.getSequence();
        StringAccessorTest.assertEquals((String)list.get(0), (String)"T");
        StringAccessorTest.assertEquals((String)list.get(1), (String)"e");
        StringAccessorTest.assertEquals((String)list.get(2), (String)"s");
        StringAccessorTest.assertEquals((String)list.get(3), (String)"t");
    }

    public void testStringAccessorWithSplittedStringAccessor() {
        StringAccessor stringAccessor = new StringAccessor("TestABaumAFeierabend", new SplittedStringTokenizer("A"));
        List<String> list = stringAccessor.getSequence();
        StringAccessorTest.assertEquals((String)list.get(0), (String)"Test");
        StringAccessorTest.assertEquals((String)list.get(1), (String)"Baum");
        StringAccessorTest.assertEquals((String)list.get(2), (String)"Feierabend");
    }

    public void testGetElementFrequencies() {
        StringAccessor stringAccessor = new StringAccessor("test");
        int[] nArray = stringAccessor.getElementFrequencies();
        int[] nArray2 = new int[]{2, 1, 1, 2};
        for (int i = 0; i < nArray.length; ++i) {
            StringAccessorTest.assertEquals((int)nArray2[i], (int)nArray[i]);
        }
    }

    public void testGetElementFrequencyString() {
        StringAccessor stringAccessor = new StringAccessor("Querbeet");
        StringAccessorTest.assertEquals((int)3, (int)stringAccessor.getElementFrequency("e"));
    }
}

