/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.accessor.tree;

import ch.toe.famix.FAMIXInstance;
import ch.toe.famix.model.Attribute;
import ch.toe.famix.model.BehaviouralEntity;
import ch.toe.famix.model.Class;
import ch.toe.famix.model.Context;
import ch.toe.famix.model.FormalParameter;
import ch.toe.famix.model.Method;
import ch.toe.famix.model.Model;
import ch.toe.famix.model.Package;
import junit.framework.TestCase;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import simpack.accessor.tree.AstTreeAccessor;
import simpack.accessor.tree.FamixTreeAccessor;
import simpack.api.ITreeNode;
import simpack.util.tree.TreeUtil;

public class TreeAccessorTest
extends TestCase {
    private FAMIXInstance famix;
    private ASTNode astNode;

    protected void setUp() throws Exception {
        super.setUp();
        this.famix = TreeAccessorTest.generateFamixModel();
        TreeAccessorTest.assertNotNull((Object)this.famix);
        this.astNode = TreeAccessorTest.generateAstModel();
        TreeAccessorTest.assertNotNull((Object)this.astNode);
    }

    public void testAstAccessor() {
        AstTreeAccessor astTreeAccessor = new AstTreeAccessor(this.astNode);
        ITreeNode iTreeNode = astTreeAccessor.getRoot();
        TreeAccessorTest.assertNotNull((Object)iTreeNode);
        TreeAccessorTest.assertEquals((int)TreeUtil.calculateSize(iTreeNode), (int)25);
    }

    public void testFAMIXAccessor() {
        FamixTreeAccessor famixTreeAccessor = new FamixTreeAccessor(this.famix);
        ITreeNode iTreeNode = famixTreeAccessor.getRoot();
        TreeAccessorTest.assertNotNull((Object)iTreeNode);
        TreeAccessorTest.assertEquals((int)TreeUtil.calculateSize(iTreeNode), (int)8);
    }

    public static ASTNode generateAstModel() {
        String string = "package internal.test;public class Tester {\tprivate int field = 1;\tpublic Tester() {\t\tfield = 2;\t}\tpublic int getField() {\t\treturn Integer.toInt(new String(field));\t}}";
        ASTParser aSTParser = ASTParser.newParser((int)3);
        aSTParser.setSource(string.toCharArray());
        return aSTParser.createAST(null);
    }

    public static FAMIXInstance generateFamixModel() {
        Model model = new Model("TestSuite", "n/a", "3", "Java");
        FAMIXInstance fAMIXInstance = new FAMIXInstance(model);
        Package package_ = fAMIXInstance.addPackage("base", null);
        Package package_2 = new Package("test", package_);
        package_2.setBelongsTo((Context)package_);
        Class clazz = new Class("HelloWorld");
        package_2.getClasses().add(clazz);
        clazz.getAttributes().add(new Attribute("output", clazz));
        Method method = new Method("printText", "printText(String)", clazz);
        clazz.getMethods().add(method);
        method.getFormalParameters().add(new FormalParameter("output", (BehaviouralEntity)method, new Integer(1)));
        return fAMIXInstance;
    }
}

