/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.external.simmetrics;

import junit.framework.TestCase;
import simmetrics.api.InterfaceTokeniser;
import simmetrics.tokenisers.TokeniserQGram3;
import simmetrics.tokenisers.TokeniserWhitespace;
import simpack.measure.external.simmetrics.QGramsDistance;
import simpack.tokenizer.TokeniserQGram4;
import simpack.tokenizer.TokeniserQGramN;

public class QGramsDistanceTest
extends TestCase {
    public void testCalculateSimilarity() {
        QGramsDistance qGramsDistance = new QGramsDistance("test", "test");
        QGramsDistanceTest.assertNotNull((Object)qGramsDistance);
        QGramsDistanceTest.assertTrue((boolean)qGramsDistance.calculate());
        QGramsDistanceTest.assertTrue((boolean)qGramsDistance.isCalculated());
        QGramsDistanceTest.assertEquals((Object)qGramsDistance.getSimilarity(), (Object)new Double(1.0));
        qGramsDistance = new QGramsDistance("test", "best");
        QGramsDistanceTest.assertNotNull((Object)qGramsDistance);
        QGramsDistanceTest.assertTrue((boolean)qGramsDistance.calculate());
        QGramsDistanceTest.assertTrue((boolean)qGramsDistance.isCalculated());
        QGramsDistanceTest.assertEquals((Object)qGramsDistance.getSimilarity(), (Object)new Double(0.5));
    }

    public void testCalculateSimilarityWithParameters() {
        QGramsDistance qGramsDistance = new QGramsDistance("test", "test", (InterfaceTokeniser)new TokeniserWhitespace());
        QGramsDistanceTest.assertNotNull((Object)qGramsDistance);
        QGramsDistanceTest.assertTrue((boolean)qGramsDistance.calculate());
        QGramsDistanceTest.assertTrue((boolean)qGramsDistance.isCalculated());
        QGramsDistanceTest.assertEquals((Object)qGramsDistance.getSimilarity(), (Object)new Double(1.0));
        qGramsDistance = new QGramsDistance("test", "test", (InterfaceTokeniser)new TokeniserQGram3());
        QGramsDistanceTest.assertNotNull((Object)qGramsDistance);
        QGramsDistanceTest.assertTrue((boolean)qGramsDistance.calculate());
        QGramsDistanceTest.assertTrue((boolean)qGramsDistance.isCalculated());
        QGramsDistanceTest.assertEquals((Object)qGramsDistance.getSimilarity(), (Object)new Double(1.0));
        qGramsDistance = new QGramsDistance("test west", "test best", (InterfaceTokeniser)new TokeniserQGram3());
        QGramsDistanceTest.assertNotNull((Object)qGramsDistance);
        QGramsDistanceTest.assertTrue((boolean)qGramsDistance.calculate());
        QGramsDistanceTest.assertTrue((boolean)qGramsDistance.isCalculated());
    }

    public void testCalculateSimilarityQGrams4() {
        TokeniserQGram4 tokeniserQGram4 = new TokeniserQGram4();
        QGramsDistance qGramsDistance = new QGramsDistance("testthis", "testthis", (InterfaceTokeniser)tokeniserQGram4);
        QGramsDistanceTest.assertNotNull((Object)qGramsDistance);
        QGramsDistanceTest.assertTrue((boolean)qGramsDistance.calculate());
        QGramsDistanceTest.assertTrue((boolean)qGramsDistance.isCalculated());
        QGramsDistanceTest.assertEquals((Object)qGramsDistance.getSimilarity(), (Object)new Double(1.0));
    }

    public void testCalculateSimilarityQGramsN() {
        TokeniserQGramN tokeniserQGramN = new TokeniserQGramN(7);
        System.out.println(tokeniserQGramN.tokenizeToSet("testthis"));
        QGramsDistance qGramsDistance = new QGramsDistance("testthis", "testthis", (InterfaceTokeniser)tokeniserQGramN);
        QGramsDistanceTest.assertNotNull((Object)qGramsDistance);
        QGramsDistanceTest.assertTrue((boolean)qGramsDistance.calculate());
        QGramsDistanceTest.assertTrue((boolean)qGramsDistance.isCalculated());
        QGramsDistanceTest.assertEquals((Object)qGramsDistance.getSimilarity(), (Object)new Double(1.0));
    }
}

