/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.graph;

import com.hp.hpl.jena.ontology.OntModelSpec;
import java.io.File;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import simpack.accessor.graph.JenaOntologyAccessor;
import simpack.measure.graph.SubgraphIsomorphism;

public class JenaOntologyTest
extends TestCase {
    public static Logger logger = Logger.getLogger(JenaOntologyTest.class);
    private JenaOntologyAccessor sumoSub;
    private JenaOntologyAccessor sumoRealignSub;
    private JenaOntologyAccessor sumoRenameSub;
    private JenaOntologyAccessor swetoSub;
    private String ontologyURI1 = "http://127.0.0.1/ontology/simplified_sumo_owl_test.owl";
    private String ontologyURI1_realign = "http://127.0.0.1/ontology/simplified_sumo_owl_test_realign.owl";
    private String ontologyURI1_rename = "http://127.0.0.1/ontology/simplified_sumo_owl_test_rename.owl";
    private String ontologyBaseURI1 = "http://127.0.0.1/ontology/simplified_sumo.owl#";
    private String ontologyRootURI1 = this.ontologyBaseURI1 + "SUMORoot";
    private String altOntologyURL1 = "file:ontology" + File.separator + "simplified_sumo.owl";
    private String ontologyURI2 = "http://127.0.0.1/ontology/testbed_v1_4_new_owl_test.owl";
    private String ontologyBaseURI2 = "http://lsdis.cs.uga.edu/proj/semdis/testbed/#";
    private String ontologyRootURI2 = this.ontologyBaseURI2 + "SWETORoot";
    private String altOntologyURL2 = "file:ontology" + File.separator + "testbed_v1_4_new_owl_test.owl";

    public void setUp() {
        this.sumoSub = new JenaOntologyAccessor(this.ontologyURI1, this.altOntologyURL1, this.ontologyBaseURI1, this.ontologyRootURI1, OntModelSpec.OWL_MEM_RDFS_INF);
        this.sumoRealignSub = new JenaOntologyAccessor(this.ontologyURI1_realign, this.altOntologyURL1, this.ontologyBaseURI1, this.ontologyRootURI1, OntModelSpec.OWL_MEM_RDFS_INF);
        this.sumoRenameSub = new JenaOntologyAccessor(this.ontologyURI1_rename, this.altOntologyURL1, this.ontologyBaseURI1, this.ontologyRootURI1, OntModelSpec.OWL_MEM_RDFS_INF);
        this.swetoSub = new JenaOntologyAccessor(this.ontologyURI2, this.altOntologyURL2, this.ontologyBaseURI2, this.ontologyRootURI2, OntModelSpec.OWL_MEM_RDFS_INF);
        JenaOntologyTest.assertNotNull((Object)this.sumoSub);
        JenaOntologyTest.assertNotNull((Object)this.sumoRealignSub);
        JenaOntologyTest.assertNotNull((Object)this.sumoRenameSub);
        JenaOntologyTest.assertNotNull((Object)this.swetoSub);
    }

    public void Similarity1() {
        SubgraphIsomorphism subgraphIsomorphism = new SubgraphIsomorphism(this.sumoSub, this.swetoSub, 7, SubgraphIsomorphism.DEFAULT_LABEL_WEIGHT, SubgraphIsomorphism.DEFAULT_STRUCTURE_WEIGHT, SubgraphIsomorphism.DEFAULT_DENOMINATOR, true);
        JenaOntologyTest.assertNotNull((Object)subgraphIsomorphism);
        JenaOntologyTest.assertTrue((boolean)subgraphIsomorphism.calculate());
        JenaOntologyTest.assertTrue((boolean)subgraphIsomorphism.isCalculated());
        JenaOntologyTest.assertEquals((Object)subgraphIsomorphism.getSimilarity(), (Object)0.20728261352858296);
        if (logger.isDebugEnabled()) {
            System.out.println("subgraph similarity: " + subgraphIsomorphism.getSimilarity());
            TreeSet<String> treeSet = subgraphIsomorphism.getCliqueList();
            for (String string : treeSet) {
                System.out.println("clique: " + string);
            }
        }
    }

    public void Similarity2() {
        SubgraphIsomorphism subgraphIsomorphism = new SubgraphIsomorphism(this.sumoRenameSub, this.swetoSub, 7, SubgraphIsomorphism.DEFAULT_LABEL_WEIGHT, SubgraphIsomorphism.DEFAULT_STRUCTURE_WEIGHT, SubgraphIsomorphism.DEFAULT_DENOMINATOR, true);
        JenaOntologyTest.assertNotNull((Object)subgraphIsomorphism);
        JenaOntologyTest.assertTrue((boolean)subgraphIsomorphism.calculate());
        JenaOntologyTest.assertTrue((boolean)subgraphIsomorphism.isCalculated());
        JenaOntologyTest.assertEquals((Object)subgraphIsomorphism.getSimilarity(), (Object)0.20728261352858296);
        if (logger.isDebugEnabled()) {
            System.out.println("subgraph similarity: " + subgraphIsomorphism.getSimilarity());
            TreeSet<String> treeSet = subgraphIsomorphism.getCliqueList();
            for (String string : treeSet) {
                System.out.println("clique: " + string);
            }
        }
    }

    public void Similarity3() {
        SubgraphIsomorphism subgraphIsomorphism = new SubgraphIsomorphism(this.sumoRealignSub, this.swetoSub, 7, SubgraphIsomorphism.DEFAULT_LABEL_WEIGHT, SubgraphIsomorphism.DEFAULT_STRUCTURE_WEIGHT, SubgraphIsomorphism.DEFAULT_DENOMINATOR, true);
        JenaOntologyTest.assertNotNull((Object)subgraphIsomorphism);
        JenaOntologyTest.assertTrue((boolean)subgraphIsomorphism.calculate());
        JenaOntologyTest.assertTrue((boolean)subgraphIsomorphism.isCalculated());
        JenaOntologyTest.assertEquals((Object)subgraphIsomorphism.getSimilarity(), (Object)0.21015793604876457);
        if (logger.isDebugEnabled()) {
            System.out.println("subgraph similarity: " + subgraphIsomorphism.getSimilarity());
            TreeSet<String> treeSet = subgraphIsomorphism.getCliqueList();
            for (String string : treeSet) {
                System.out.println("clique: " + string);
            }
        }
    }
}

