/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.graph;

import com.hp.hpl.jena.ontology.OntModelSpec;
import java.io.File;
import junit.framework.TestCase;
import simpack.accessor.graph.JenaOntologyAccessor;
import simpack.exception.InvalidElementException;
import simpack.measure.graph.ScaledShortestPath;
import simpack.util.graph.GraphNode;

public class ScaledShortestPathTest
extends TestCase {
    private String ontologyURI = "http://127.0.0.1/ontology/simplified_sumo.owl";
    private String ontologyBaseURI = "http://127.0.0.1/ontology/simplified_sumo.owl#";
    private String ontologyRootURI = "http://127.0.0.1/ontology/simplified_sumo.owl#SUMORoot";
    private String altOntologyURL = "file:ontology" + File.separator + "simplified_sumo.owl";
    private OntModelSpec ontModelSpec = OntModelSpec.OWL_MEM_RDFS_INF;

    public void testScaledShortestPath() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#HoofedMammal";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#BodyPart";
        ScaledShortestPath scaledShortestPath = null;
        try {
            scaledShortestPath = new ScaledShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ScaledShortestPathTest.assertNotNull(scaledShortestPath);
        ScaledShortestPathTest.assertTrue((boolean)scaledShortestPath.calculate());
        ScaledShortestPathTest.assertTrue((boolean)scaledShortestPath.isCalculated());
        ScaledShortestPathTest.assertEquals((Object)scaledShortestPath.getSimilarity(), (Object)new Double(-1.0 * Math.log(0.3333333333333333)));
    }

    public void testScaledShortestPathInvalidNodeException() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#HoofedMammalalalal";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#BodyPart";
        ScaledShortestPath scaledShortestPath = null;
        try {
            scaledShortestPath = new ScaledShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
            ScaledShortestPathTest.fail((String)"Should raise an InvalidNodeException");
        }
        catch (InvalidElementException invalidElementException) {
            ScaledShortestPathTest.assertTrue((boolean)true);
        }
    }

    public void testScaledShortestPathMultiplePathPossible() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#IndependentState";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#Industry";
        ScaledShortestPath scaledShortestPath = null;
        try {
            scaledShortestPath = new ScaledShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ScaledShortestPathTest.assertNotNull(scaledShortestPath);
        ScaledShortestPathTest.assertTrue((boolean)scaledShortestPath.calculate());
        ScaledShortestPathTest.assertTrue((boolean)scaledShortestPath.isCalculated());
        ScaledShortestPathTest.assertEquals((Object)scaledShortestPath.getSimilarity(), (Object)new Double(-1.0 * Math.log(0.25)));
    }

    public void testScaledShortestPathSameNode() {
        String string;
        String string2 = string = "http://127.0.0.1/ontology/simplified_sumo.owl#IndependentState";
        ScaledShortestPath scaledShortestPath = null;
        try {
            scaledShortestPath = new ScaledShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ScaledShortestPathTest.assertNotNull(scaledShortestPath);
        ScaledShortestPathTest.assertTrue((boolean)scaledShortestPath.calculate());
        ScaledShortestPathTest.assertTrue((boolean)scaledShortestPath.isCalculated());
        ScaledShortestPathTest.assertEquals((Object)scaledShortestPath.getSimilarity(), (Object)new Double(0.0));
    }

    public void testScaledShortestPathOneIsAncestorOfOther() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#Vertebrate";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#Organism";
        ScaledShortestPath scaledShortestPath = null;
        try {
            scaledShortestPath = new ScaledShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ScaledShortestPathTest.assertNotNull(scaledShortestPath);
        ScaledShortestPathTest.assertTrue((boolean)scaledShortestPath.calculate());
        ScaledShortestPathTest.assertTrue((boolean)scaledShortestPath.isCalculated());
        ScaledShortestPathTest.assertEquals((Object)scaledShortestPath.getSimilarity(), (Object)new Double(-1.0 * Math.log(0.08333333333333333)));
    }

    public void testScaledShortestPathOneIsRootOfOntology() {
        String string = this.ontologyRootURI;
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#Object";
        ScaledShortestPath scaledShortestPath = null;
        try {
            scaledShortestPath = new ScaledShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ScaledShortestPathTest.assertNotNull(scaledShortestPath);
        ScaledShortestPathTest.assertTrue((boolean)scaledShortestPath.calculate());
        ScaledShortestPathTest.assertTrue((boolean)scaledShortestPath.isCalculated());
        ScaledShortestPathTest.assertEquals((Object)scaledShortestPath.getSimilarity(), (Object)new Double(-1.0 * Math.log(0.125)));
    }

    public void testScaledShortestPathOneIsRootOfOntologyMutliplePathsPossible() {
        String string = this.ontologyRootURI;
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#Transaction";
        ScaledShortestPath scaledShortestPath = null;
        try {
            scaledShortestPath = new ScaledShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ScaledShortestPathTest.assertNotNull(scaledShortestPath);
        ScaledShortestPathTest.assertTrue((boolean)scaledShortestPath.calculate());
        ScaledShortestPathTest.assertTrue((boolean)scaledShortestPath.isCalculated());
        ScaledShortestPathTest.assertEquals((Object)scaledShortestPath.getSimilarity(), (Object)new Double(-1.0 * Math.log(0.08333333333333333)));
    }
}

