/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.graph;

import java.io.File;
import junit.framework.TestCase;
import simpack.accessor.graph.ScuflXMLGraphAccessor;
import simpack.accessor.string.StringAccessor;
import simpack.measure.graph.GraphIsomorphism;
import simpack.measure.sequence.Levenshtein;

public class ScufleWorkflowGraphIsoTest
extends TestCase {
    private String wf1;
    private String wf2;
    private String wf3;
    private ScuflXMLGraphAccessor scuf_dilbert_sub1;
    private ScuflXMLGraphAccessor scuf_dilbert_sub2;
    private ScuflXMLGraphAccessor scuf_dilbert_sub3;
    private double labelSimSum;
    private double labelSimSum2;

    public ScufleWorkflowGraphIsoTest() {
        this.wf2 = this.wf1 = "file:workflow" + File.separator + "FetchDailyDilbertComic.xml";
        this.wf3 = "file:workflow" + File.separator + "FetchDailyDilbertComic-LabelChanged.xml";
    }

    public void setUp() {
        this.scuf_dilbert_sub1 = new ScuflXMLGraphAccessor(this.wf1);
        this.scuf_dilbert_sub2 = new ScuflXMLGraphAccessor(this.wf2);
        this.scuf_dilbert_sub3 = new ScuflXMLGraphAccessor(this.wf3);
        ScufleWorkflowGraphIsoTest.assertNotNull((Object)this.scuf_dilbert_sub1);
        ScufleWorkflowGraphIsoTest.assertNotNull((Object)this.scuf_dilbert_sub2);
        ScufleWorkflowGraphIsoTest.assertNotNull((Object)this.scuf_dilbert_sub3);
        this.setUpGraphStuff();
    }

    public void testSimilarity() {
        GraphIsomorphism graphIsomorphism = new GraphIsomorphism(this.scuf_dilbert_sub1, this.scuf_dilbert_sub2);
        double d = 1.0;
        ScufleWorkflowGraphIsoTest.assertNotNull((Object)graphIsomorphism.calculate());
        ScufleWorkflowGraphIsoTest.assertNotNull((Object)graphIsomorphism.isCalculated());
        ScufleWorkflowGraphIsoTest.assertEquals((Object)graphIsomorphism.getSimilarity(), (Object)d);
    }

    public void testSimilarityLabelChanged() {
        GraphIsomorphism graphIsomorphism = new GraphIsomorphism(this.scuf_dilbert_sub1, this.scuf_dilbert_sub3);
        double d = 7.0;
        ScufleWorkflowGraphIsoTest.assertNotNull((Object)graphIsomorphism.calculate());
        ScufleWorkflowGraphIsoTest.assertNotNull((Object)graphIsomorphism.isCalculated());
        ScufleWorkflowGraphIsoTest.assertEquals((Object)graphIsomorphism.getSimilarity(), (Object)(this.labelSimSum2 / d));
    }

    private void setUpGraphStuff() {
        this.labelSimSum = 0.0;
        this.labelSimSum2 = 0.0;
        Levenshtein<String> levenshtein = new Levenshtein<String>(new StringAccessor("dilbertURL"), new StringAccessor("dilbertURL"));
        this.labelSimSum += levenshtein.getSimilarity().doubleValue();
        levenshtein = new Levenshtein<String>(new StringAccessor("getPage"), new StringAccessor("getPage"));
        this.labelSimSum += levenshtein.getSimilarity().doubleValue();
        levenshtein = new Levenshtein<String>(new StringAccessor("getImageLinks"), new StringAccessor("getImageLinks"));
        this.labelSimSum += levenshtein.getSimilarity().doubleValue();
        levenshtein = new Levenshtein<String>(new StringAccessor("comicURLRegex"), new StringAccessor("comicURLRegex"));
        this.labelSimSum += levenshtein.getSimilarity().doubleValue();
        levenshtein = new Levenshtein<String>(new StringAccessor("findComicURL"), new StringAccessor("findComicURL"));
        this.labelSimSum += levenshtein.getSimilarity().doubleValue();
        levenshtein = new Levenshtein<String>(new StringAccessor("todaysDilbert"), new StringAccessor("todaysDilbert"));
        this.labelSimSum += levenshtein.getSimilarity().doubleValue();
        levenshtein = new Levenshtein<String>(new StringAccessor("getComicStrip"), new StringAccessor("getComicStrip"));
        this.labelSimSum += levenshtein.getSimilarity().doubleValue();
        this.labelSimSum2 = this.labelSimSum - levenshtein.getSimilarity();
        levenshtein = new Levenshtein<String>(new StringAccessor("getDailyComicStrip"), new StringAccessor("getComicStrip"));
        this.labelSimSum2 += levenshtein.getSimilarity().doubleValue();
    }
}

