/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.graph;

import java.io.File;
import junit.framework.TestCase;
import simpack.accessor.graph.ScuflXMLGraphAccessor;
import simpack.accessor.string.StringAccessor;
import simpack.measure.graph.SubgraphIsomorphism;
import simpack.measure.sequence.Levenshtein;

public class ScufleWorkflowSubGraphIsoTest
extends TestCase {
    private String wf1 = "file:workflow" + File.separator + "FetchDailyDilbertComic.xml";
    private String wf2 = "file:workflow" + File.separator + "FetchGbrowseImageSelectTracks.xml";
    private ScuflXMLGraphAccessor scuf_dilbert_sub;
    private ScuflXMLGraphAccessor scuf_gbrows_sub;
    private int v1;
    private int v2;
    private double labelSimSum;
    private double wS;
    private double wL;
    private int maximumCliqueSize;

    public void setUp() {
        this.scuf_dilbert_sub = new ScuflXMLGraphAccessor(this.wf1);
        this.scuf_gbrows_sub = new ScuflXMLGraphAccessor(this.wf2);
        ScufleWorkflowSubGraphIsoTest.assertNotNull((Object)this.scuf_dilbert_sub);
        ScufleWorkflowSubGraphIsoTest.assertNotNull((Object)this.scuf_gbrows_sub);
        this.setUpGraphStuff();
    }

    public void testSimilarity() {
        SubgraphIsomorphism subgraphIsomorphism = new SubgraphIsomorphism(this.scuf_dilbert_sub, this.scuf_gbrows_sub);
        double d = this.labelSimSum / ((double)(this.v1 + this.v2) / 2.0);
        double d2 = (double)this.maximumCliqueSize / ((double)(this.v1 + this.v2) / 2.0);
        double d3 = this.wL * d + this.wS * d2;
        subgraphIsomorphism.calculate();
        ScufleWorkflowSubGraphIsoTest.assertEquals((Object)subgraphIsomorphism.getSimilarity(), (Object)d3);
    }

    public void testSimilarityGroupNodes() {
        SubgraphIsomorphism subgraphIsomorphism = new SubgraphIsomorphism(this.scuf_dilbert_sub, this.scuf_gbrows_sub, SubgraphIsomorphism.DEFAULT_MIN_CLIQUE_SIZE, SubgraphIsomorphism.DEFAULT_LABEL_WEIGHT, SubgraphIsomorphism.DEFAULT_STRUCTURE_WEIGHT, SubgraphIsomorphism.DEFAULT_DENOMINATOR, true);
        double d = this.labelSimSum / ((double)(this.v1 + this.v2) / 2.0);
        double d2 = (double)this.maximumCliqueSize / ((double)(this.v1 + this.v2) / 2.0);
        double d3 = this.wL * d + this.wS * d2;
        subgraphIsomorphism.calculate();
        ScufleWorkflowSubGraphIsoTest.assertEquals((Object)subgraphIsomorphism.getSimilarity(), (Object)d3);
    }

    public void testSimilarityNormalizeWRTSmallerGraph() {
        SubgraphIsomorphism subgraphIsomorphism = new SubgraphIsomorphism(this.scuf_dilbert_sub, this.scuf_gbrows_sub, SubgraphIsomorphism.DEFAULT_MIN_CLIQUE_SIZE, SubgraphIsomorphism.DEFAULT_LABEL_WEIGHT, SubgraphIsomorphism.DEFAULT_STRUCTURE_WEIGHT, "small", false);
        double d = this.labelSimSum / (double)this.v1;
        double d2 = (double)this.maximumCliqueSize / (double)this.v1;
        double d3 = this.wL * d + this.wS * d2;
        subgraphIsomorphism.calculate();
        ScufleWorkflowSubGraphIsoTest.assertEquals((Object)subgraphIsomorphism.getSimilarity(), (Object)d3);
    }

    public void testSimilarityNormalizeWRTBiggerGraph() {
        SubgraphIsomorphism subgraphIsomorphism = new SubgraphIsomorphism(this.scuf_dilbert_sub, this.scuf_gbrows_sub, SubgraphIsomorphism.DEFAULT_MIN_CLIQUE_SIZE, SubgraphIsomorphism.DEFAULT_LABEL_WEIGHT, SubgraphIsomorphism.DEFAULT_STRUCTURE_WEIGHT, "big", false);
        double d = this.labelSimSum / (double)this.v2;
        double d2 = (double)this.maximumCliqueSize / (double)this.v2;
        double d3 = this.wL * d + this.wS * d2;
        subgraphIsomorphism.calculate();
        ScufleWorkflowSubGraphIsoTest.assertEquals((Object)subgraphIsomorphism.getSimilarity(), (Object)d3);
    }

    private void setUpGraphStuff() {
        this.wL = 0.5;
        this.wS = 0.5;
        this.v1 = 7;
        this.v2 = 17;
        this.maximumCliqueSize = 6;
        this.labelSimSum = 0.0;
        Levenshtein<String> levenshtein = new Levenshtein<String>(new StringAccessor("comicURLRegex"), new StringAccessor("detailedViewURLRegex"));
        this.labelSimSum += levenshtein.getSimilarity().doubleValue();
        levenshtein = new Levenshtein<String>(new StringAccessor("findComicURL"), new StringAccessor("finddetailedViewImage"));
        this.labelSimSum += levenshtein.getSimilarity().doubleValue();
        levenshtein = new Levenshtein<String>(new StringAccessor("getComicStrip"), new StringAccessor("getDetailedView"));
        this.labelSimSum += levenshtein.getSimilarity().doubleValue();
        levenshtein = new Levenshtein<String>(new StringAccessor("getImageLinks"), new StringAccessor("getImageLinks"));
        this.labelSimSum += levenshtein.getSimilarity().doubleValue();
        levenshtein = new Levenshtein<String>(new StringAccessor("getPage"), new StringAccessor("GetPage"));
        this.labelSimSum += levenshtein.getSimilarity().doubleValue();
        levenshtein = new Levenshtein<String>(new StringAccessor("todaysDilbert"), new StringAccessor("gbrowseImage"));
        this.labelSimSum += levenshtein.getSimilarity().doubleValue();
    }
}

