/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.graph;

import com.hp.hpl.jena.ontology.OntModelSpec;
import java.io.File;
import junit.framework.TestCase;
import simpack.accessor.graph.JenaOntologyAccessor;
import simpack.exception.InvalidElementException;
import simpack.measure.graph.ShortestPath;
import simpack.util.conversion.CommonDistanceConversion;
import simpack.util.graph.GraphNode;

public class ShortestPathSimilarityTest
extends TestCase {
    private String ontologyURI = "http://127.0.0.1/ontology/simplified_sumo.owl";
    private String ontologyBaseURI = "http://127.0.0.1/ontology/simplified_sumo.owl#";
    private String ontologyRootURI = "http://127.0.0.1/ontology/simplified_sumo.owl#SUMORoot";
    private String altOntologyURL = "file:ontology" + File.separator + "simplified_sumo.owl";
    private OntModelSpec ontModelSpec = OntModelSpec.OWL_MEM_RDFS_INF;

    public void testShortestPath() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#HoofedMammal";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#BodyPart";
        ShortestPath shortestPath = null;
        try {
            shortestPath = new ShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)), new CommonDistanceConversion());
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ShortestPathSimilarityTest.assertNotNull(shortestPath);
        ShortestPathSimilarityTest.assertTrue((boolean)shortestPath.calculate());
        ShortestPathSimilarityTest.assertTrue((boolean)shortestPath.isCalculated());
        ShortestPathSimilarityTest.assertEquals((Object)shortestPath.getSimilarity(), (Object)new Double(0.1111111111111111));
    }

    public void testShortestPathInvalidNodeException() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#HoofedMammalalalal";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#BodyPart";
        ShortestPath shortestPath = null;
        try {
            shortestPath = new ShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)), new CommonDistanceConversion());
            ShortestPathSimilarityTest.fail((String)"Should raise an InvalidNodeException");
        }
        catch (InvalidElementException invalidElementException) {
            ShortestPathSimilarityTest.assertTrue((boolean)true);
        }
    }

    public void testShortestPathMultiplePathPossible() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#IndependentState";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#Industry";
        ShortestPath shortestPath = null;
        try {
            shortestPath = new ShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)), new CommonDistanceConversion());
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ShortestPathSimilarityTest.assertNotNull(shortestPath);
        ShortestPathSimilarityTest.assertTrue((boolean)shortestPath.calculate());
        ShortestPathSimilarityTest.assertTrue((boolean)shortestPath.isCalculated());
        ShortestPathSimilarityTest.assertEquals((Object)shortestPath.getSimilarity(), (Object)new Double(0.14285714285714285));
    }

    public void testShortestPathSameNode() {
        String string;
        String string2 = string = "http://127.0.0.1/ontology/simplified_sumo.owl#IndependentState";
        ShortestPath shortestPath = null;
        try {
            shortestPath = new ShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)), new CommonDistanceConversion());
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ShortestPathSimilarityTest.assertNotNull(shortestPath);
        ShortestPathSimilarityTest.assertTrue((boolean)shortestPath.calculate());
        ShortestPathSimilarityTest.assertTrue((boolean)shortestPath.isCalculated());
        ShortestPathSimilarityTest.assertEquals((Object)shortestPath.getSimilarity(), (Object)new Double(1.0));
    }

    public void testShortestPathOneIsAncestorOfOther() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#Vertebrate";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#Organism";
        ShortestPath shortestPath = null;
        try {
            shortestPath = new ShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)), new CommonDistanceConversion());
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ShortestPathSimilarityTest.assertNotNull(shortestPath);
        ShortestPathSimilarityTest.assertTrue((boolean)shortestPath.calculate());
        ShortestPathSimilarityTest.assertTrue((boolean)shortestPath.isCalculated());
        ShortestPathSimilarityTest.assertEquals((Object)shortestPath.getSimilarity(), (Object)new Double(0.3333333333333333));
    }

    public void testShortestPathOneIsRootOfOntology() {
        String string = this.ontologyRootURI;
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#Object";
        ShortestPath shortestPath = null;
        try {
            shortestPath = new ShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)), new CommonDistanceConversion());
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ShortestPathSimilarityTest.assertNotNull(shortestPath);
        ShortestPathSimilarityTest.assertTrue((boolean)shortestPath.calculate());
        ShortestPathSimilarityTest.assertTrue((boolean)shortestPath.isCalculated());
        ShortestPathSimilarityTest.assertEquals((Object)shortestPath.getSimilarity(), (Object)new Double(0.25));
    }

    public void testShortestPathOneIsRootOfOntologyMutliplePathsPossible() {
        String string = this.ontologyRootURI;
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#Transaction";
        ShortestPath shortestPath = null;
        try {
            shortestPath = new ShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)), new CommonDistanceConversion());
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ShortestPathSimilarityTest.assertNotNull(shortestPath);
        ShortestPathSimilarityTest.assertTrue((boolean)shortestPath.calculate());
        ShortestPathSimilarityTest.assertTrue((boolean)shortestPath.isCalculated());
        ShortestPathSimilarityTest.assertEquals((Object)shortestPath.getSimilarity(), (Object)new Double(0.3333333333333333));
    }
}

