/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.graph;

import com.hp.hpl.jena.ontology.OntModelSpec;
import java.io.File;
import junit.framework.TestCase;
import simpack.accessor.graph.JenaOntologyAccessor;
import simpack.exception.InvalidElementException;
import simpack.measure.graph.ShortestPath;
import simpack.util.graph.GraphNode;

public class ShortestPathTest
extends TestCase {
    private String ontologyURI = "http://127.0.0.1/ontology/simplified_sumo.owl";
    private String ontologyBaseURI = "http://127.0.0.1/ontology/simplified_sumo.owl#";
    private String ontologyRootURI = "http://127.0.0.1/ontology/simplified_sumo.owl#SUMORoot";
    private String altOntologyURL = "file:ontology" + File.separator + "simplified_sumo.owl";
    private OntModelSpec ontModelSpec = OntModelSpec.OWL_MEM_RDFS_INF;

    public void testShortestPath() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#HoofedMammal";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#BodyPart";
        ShortestPath shortestPath = null;
        try {
            shortestPath = new ShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ShortestPathTest.assertNotNull(shortestPath);
        ShortestPathTest.assertTrue((boolean)shortestPath.calculate());
        ShortestPathTest.assertTrue((boolean)shortestPath.isCalculated());
        ShortestPathTest.assertEquals((Object)shortestPath.getSimilarity(), (Object)new Double(8.0));
    }

    public void testShortestPath2() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#HoofedMammal";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#EuroDollar";
        ShortestPath shortestPath = null;
        try {
            shortestPath = new ShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ShortestPathTest.assertNotNull(shortestPath);
        ShortestPathTest.assertTrue((boolean)shortestPath.calculate());
        ShortestPathTest.assertTrue((boolean)shortestPath.isCalculated());
        ShortestPathTest.assertEquals((Object)shortestPath.getSimilarity(), (Object)new Double(14.0));
    }

    public void testShortestPathInvalidNodeException() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#HoofedMammalalalal";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#BodyPart";
        ShortestPath shortestPath = null;
        try {
            shortestPath = new ShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
            ShortestPathTest.fail((String)"Should raise an InvalidNodeException");
        }
        catch (InvalidElementException invalidElementException) {
            ShortestPathTest.assertTrue((boolean)true);
        }
    }

    public void testShortestPathMultiplePathPossible() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#IndependentState";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#Industry";
        ShortestPath shortestPath = null;
        try {
            shortestPath = new ShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ShortestPathTest.assertNotNull(shortestPath);
        ShortestPathTest.assertTrue((boolean)shortestPath.calculate());
        ShortestPathTest.assertTrue((boolean)shortestPath.isCalculated());
        ShortestPathTest.assertEquals((Object)shortestPath.getSimilarity(), (Object)new Double(6.0));
    }

    public void testShortestPathSameNode() {
        String string;
        String string2 = string = "http://127.0.0.1/ontology/simplified_sumo.owl#IndependentState";
        ShortestPath shortestPath = null;
        try {
            shortestPath = new ShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ShortestPathTest.assertNotNull(shortestPath);
        ShortestPathTest.assertTrue((boolean)shortestPath.calculate());
        ShortestPathTest.assertTrue((boolean)shortestPath.isCalculated());
        ShortestPathTest.assertEquals((Object)shortestPath.getSimilarity(), (Object)new Double(0.0));
    }

    public void testShortestPathOneIsAncestorOfOther() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#Vertebrate";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#Organism";
        ShortestPath shortestPath = null;
        try {
            shortestPath = new ShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ShortestPathTest.assertNotNull(shortestPath);
        ShortestPathTest.assertTrue((boolean)shortestPath.calculate());
        ShortestPathTest.assertTrue((boolean)shortestPath.isCalculated());
        ShortestPathTest.assertEquals((Object)shortestPath.getSimilarity(), (Object)new Double(2.0));
    }

    public void testShortestPathOneIsRootOfOntology() {
        String string = this.ontologyRootURI;
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#Object";
        ShortestPath shortestPath = null;
        try {
            shortestPath = new ShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ShortestPathTest.assertNotNull(shortestPath);
        ShortestPathTest.assertTrue((boolean)shortestPath.calculate());
        ShortestPathTest.assertTrue((boolean)shortestPath.isCalculated());
        ShortestPathTest.assertEquals((Object)shortestPath.getSimilarity(), (Object)new Double(3.0));
    }

    public void testShortestPathOneIsRootOfOntologyMutliplePathsPossible() {
        String string = this.ontologyRootURI;
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#Transaction";
        ShortestPath shortestPath = null;
        try {
            shortestPath = new ShortestPath(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ShortestPathTest.assertNotNull(shortestPath);
        ShortestPathTest.assertTrue((boolean)shortestPath.calculate());
        ShortestPathTest.assertTrue((boolean)shortestPath.isCalculated());
        ShortestPathTest.assertEquals((Object)shortestPath.getSimilarity(), (Object)new Double(2.0));
    }
}

