/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.it;

import com.hp.hpl.jena.ontology.OntModelSpec;
import java.io.File;
import junit.framework.TestCase;
import simpack.accessor.graph.JenaOntologyAccessor;
import simpack.exception.InvalidElementException;
import simpack.measure.it.JiangConrath;
import simpack.util.graph.GraphNode;

public class JiangConrathOntologyTest
extends TestCase {
    private String SUMO_OntologyURI = "http://127.0.0.1/ontology/simplified_sumo.owl";
    private String SUMO_OntologyBaseURI = "http://127.0.0.1/ontology/simplified_sumo.owl#";
    private String SUMO_OntologyRootURI = "http://127.0.0.1/ontology/simplified_sumo.owl#SUMORoot";
    private String altOntologyURL = "file:ontology" + File.separator + "simplified_sumo.owl";
    private String ontClassA = "http://127.0.0.1/ontology/simplified_sumo.owl#Shrimp";
    private String ontClassB = "http://127.0.0.1/ontology/simplified_sumo.owl#Wine";
    private String ontClassC = "http://lsdis.cs.uga.edu/proj/semdis/testbed/#Politician";
    private String ontClassD = "http://127.0.0.1/ontology/simplified_sumo.owl#Shellfish";
    private String ontClassE = "http://127.0.0.1/ontology/simplified_sumo.owl#Entity";
    private String ontClassF = "http://127.0.0.1/ontology/simplified_sumo.owl#DualObjectProcess";
    private String ontClassG = "http://127.0.0.1/ontology/simplified_sumo.owl#Meat";
    private OntModelSpec ontModelSpec = OntModelSpec.OWL_MEM_RDFS_INF;

    public void testJenaOntologyAccessor() {
        JiangConrath jiangConrath = null;
        try {
            jiangConrath = new JiangConrath(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassA), new GraphNode(this.ontClassB));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        JiangConrathOntologyTest.assertNotNull(jiangConrath);
        JiangConrathOntologyTest.assertTrue((boolean)jiangConrath.calculate());
        JiangConrathOntologyTest.assertTrue((boolean)jiangConrath.isCalculated());
        Double d = new Double(-2.0 * Math.log(0.15702479338842976) - (Math.log(0.008264462809917356) + Math.log(0.008264462809917356)));
        JiangConrathOntologyTest.assertEquals((Object)jiangConrath.getSimilarity(), (Object)d);
    }

    public void testCalculateSimilarityInvalidClassName() {
        JiangConrath jiangConrath = null;
        try {
            jiangConrath = new JiangConrath(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassA), new GraphNode(this.ontClassC));
            JiangConrathOntologyTest.fail((String)"Should raise an InvalidNodException");
        }
        catch (InvalidElementException invalidElementException) {
            JiangConrathOntologyTest.assertTrue((boolean)true);
        }
    }

    public void testCalculateSimilaritySameClass() {
        JiangConrath jiangConrath = null;
        try {
            jiangConrath = new JiangConrath(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassA), new GraphNode(this.ontClassA));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        JiangConrathOntologyTest.assertNotNull(jiangConrath);
        JiangConrathOntologyTest.assertTrue((boolean)jiangConrath.calculate());
        JiangConrathOntologyTest.assertTrue((boolean)jiangConrath.isCalculated());
        Double d = new Double(-2.0 * Math.log(0.024793388429752067) - (Math.log(0.008264462809917356) + Math.log(0.008264462809917356)));
        JiangConrathOntologyTest.assertEquals((Object)jiangConrath.getSimilarity(), (Object)d);
    }

    public void testCalculateSimilarityOneIsParentOfOther() {
        JiangConrath jiangConrath = null;
        try {
            jiangConrath = new JiangConrath(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassA), new GraphNode(this.ontClassD));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        JiangConrathOntologyTest.assertNotNull(jiangConrath);
        JiangConrathOntologyTest.assertTrue((boolean)jiangConrath.calculate());
        JiangConrathOntologyTest.assertTrue((boolean)jiangConrath.isCalculated());
        Double d = new Double(-2.0 * Math.log(0.024793388429752067) - (Math.log(0.008264462809917356) + Math.log(0.024793388429752067)));
        JiangConrathOntologyTest.assertEquals((Object)jiangConrath.getSimilarity(), (Object)d);
    }

    public void testCalculateSimilarityOneIsAncestorOfOther() {
        JiangConrath jiangConrath = null;
        try {
            jiangConrath = new JiangConrath(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassA), new GraphNode(this.ontClassG));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        JiangConrathOntologyTest.assertNotNull(jiangConrath);
        JiangConrathOntologyTest.assertTrue((boolean)jiangConrath.calculate());
        JiangConrathOntologyTest.assertTrue((boolean)jiangConrath.isCalculated());
        Double d = new Double(-2.0 * Math.log(0.11570247933884298) - (Math.log(0.008264462809917356) + Math.log(0.11570247933884298)));
        JiangConrathOntologyTest.assertEquals((Object)jiangConrath.getSimilarity(), (Object)d);
    }

    public void testCalculateSimilarityMRCAIsRootOfOntology() {
        JiangConrath jiangConrath = null;
        try {
            jiangConrath = new JiangConrath(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassE), new GraphNode(this.ontClassF));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        JiangConrathOntologyTest.assertNotNull(jiangConrath);
        JiangConrathOntologyTest.assertTrue((boolean)jiangConrath.calculate());
        JiangConrathOntologyTest.assertTrue((boolean)jiangConrath.isCalculated());
        Double d = new Double(-2.0 * Math.log(1.0) - (Math.log(0.9834710743801653) + Math.log(0.024793388429752067)));
        JiangConrathOntologyTest.assertEquals((Object)jiangConrath.getSimilarity(), (Object)d);
    }

    public void testCalculateSimilarityOneIsRootOfOntology() {
        JiangConrath jiangConrath = null;
        try {
            jiangConrath = new JiangConrath(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassE), new GraphNode(this.SUMO_OntologyRootURI));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        JiangConrathOntologyTest.assertNotNull(jiangConrath);
        JiangConrathOntologyTest.assertTrue((boolean)jiangConrath.calculate());
        JiangConrathOntologyTest.assertTrue((boolean)jiangConrath.isCalculated());
        Double d = new Double(-2.0 * Math.log(1.0) - (Math.log(1.0) + Math.log(0.9834710743801653)));
        JiangConrathOntologyTest.assertEquals((Object)jiangConrath.getSimilarity(), (Object)d);
    }
}

