/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.sequence;

import junit.framework.TestCase;
import simpack.accessor.string.StringAccessor;
import simpack.exception.WeightBalanceException;
import simpack.measure.sequence.Levenshtein;
import simpack.util.conversion.CommonDistanceConversion;
import simpack.util.conversion.LogarithmicDistanceConversion;
import simpack.util.conversion.WorstCaseDistanceConversion;

public class LevenshteinTest
extends TestCase {
    private StringAccessor sa1 = new StringAccessor("Language");
    private StringAccessor sa2 = new StringAccessor("Languages");
    private StringAccessor sa3 = new StringAccessor("Levenshtein");
    private StringAccessor sa4 = new StringAccessor("shteinLeven");

    public void testSimilarity() {
        Levenshtein<String> levenshtein = new Levenshtein<String>(this.sa1, this.sa1);
        LevenshteinTest.assertEquals((Object)levenshtein.getSimilarity(), (Object)new Double(1.0));
    }

    public void testSimilarity2() {
        Levenshtein<String> levenshtein = new Levenshtein<String>(this.sa1, this.sa2);
        LevenshteinTest.assertEquals((Object)levenshtein.getSimilarity(), (Object)new Double(0.8888888888888888));
    }

    public void testSimilarity3() {
        Levenshtein<String> levenshtein = new Levenshtein<String>(new StringAccessor(""), this.sa1);
        LevenshteinTest.assertEquals((Object)levenshtein.getSimilarity(), (Object)new Double(0.0));
    }

    public void testSimilarity4() {
        Levenshtein<String> levenshtein = new Levenshtein<String>(this.sa3, this.sa4);
        LevenshteinTest.assertEquals((Object)levenshtein.getSimilarity(), (Object)new Double(0.2727272727272727));
    }

    public void testSimilarityDifferentConversion() {
        Levenshtein<String> levenshtein = new Levenshtein<String>(this.sa1, this.sa2, new WorstCaseDistanceConversion());
        LevenshteinTest.assertEquals((Object)levenshtein.getSimilarity(), (Object)new Double(0.8888888888888888));
    }

    public void testSimilarityDifferentConversion2() {
        Levenshtein<String> levenshtein = new Levenshtein<String>(this.sa1, this.sa2, new CommonDistanceConversion());
        LevenshteinTest.assertEquals((Object)levenshtein.getSimilarity(), (Object)new Double(0.5));
    }

    public void testSimilarityDifferentConversion3() {
        Levenshtein<String> levenshtein = new Levenshtein<String>(this.sa1, this.sa2, new LogarithmicDistanceConversion());
        LevenshteinTest.assertEquals((Object)levenshtein.getSimilarity(), (Object)new Double(Math.exp(-1.0)));
    }

    public void testWeightBalanceException() {
        try {
            new Levenshtein<String>(this.sa1, this.sa2, 1.0, 1.0, 2.5, 0.0, new WorstCaseDistanceConversion());
            LevenshteinTest.fail((String)"Should raise a WeightBalanceException");
        }
        catch (WeightBalanceException weightBalanceException) {
            LevenshteinTest.assertTrue((boolean)true);
        }
        try {
            new Levenshtein<String>(this.sa1, this.sa2, 1.0, 1.0, 0.0, 2.5, new WorstCaseDistanceConversion());
            LevenshteinTest.fail((String)"Should raise a WeightBalanceException");
        }
        catch (WeightBalanceException weightBalanceException) {
            LevenshteinTest.assertTrue((boolean)true);
        }
        try {
            new Levenshtein<String>(this.sa1, this.sa2, 1.0, 1.0, 2.5, 2.5, new WorstCaseDistanceConversion());
            LevenshteinTest.fail((String)"Should raise a WeightBalanceException");
        }
        catch (WeightBalanceException weightBalanceException) {
            LevenshteinTest.assertTrue((boolean)true);
        }
    }
}

