/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.sequence;

import junit.framework.TestCase;
import simpack.accessor.string.StringAccessor;
import simpack.exception.WeightBalanceException;
import simpack.measure.sequence.Levenshtein;
import simpack.tokenizer.SplittedStringTokenizer;
import simpack.util.conversion.WorstCaseDistanceConversion;

public class WhiteSpaceStringSequenceLevenshteinTest
extends TestCase {
    private String profileDesc1 = new String("It is the most used service for acknowledgement of the hotel in a city of a country.");
    private String profileDesc2 = new String("This service returns accomodation information, hotel, restaurant etc in the city of the country.");
    private String profileDesc3 = new String("This service reserve hotel in a city of the country during the given duration.");
    private StringAccessor csa1 = new StringAccessor(this.profileDesc1, new SplittedStringTokenizer("\\s+"));
    private StringAccessor csa2 = new StringAccessor(this.profileDesc2, new SplittedStringTokenizer("\\s+"));
    private StringAccessor csa3 = new StringAccessor(this.profileDesc3, new SplittedStringTokenizer("\\s+"));

    public void testSimilarity() {
        Levenshtein<String> levenshtein = new Levenshtein<String>(this.csa1, this.csa1);
        WhiteSpaceStringSequenceLevenshteinTest.assertEquals((Object)levenshtein.getSimilarity(), (Object)new Double(1.0));
    }

    public void testSimilarity2() {
        Levenshtein<String> levenshtein = new Levenshtein<String>(this.csa1, this.csa2);
        WhiteSpaceStringSequenceLevenshteinTest.assertEquals((Object)levenshtein.getSimilarity(), (Object)new Double(0.8645833333333334));
    }

    public void testSimilarity3() {
        Levenshtein<String> levenshtein = new Levenshtein<String>(this.csa1, this.csa3);
        WhiteSpaceStringSequenceLevenshteinTest.assertEquals((Object)levenshtein.getSimilarity(), (Object)new Double(0.8214285714285714));
    }

    public void testSimilarity4() {
        Levenshtein<String> levenshtein = new Levenshtein<String>(this.csa2, this.csa3);
        WhiteSpaceStringSequenceLevenshteinTest.assertEquals((Object)levenshtein.getSimilarity(), (Object)new Double(0.8854166666666666));
    }

    public void testWeightBalanceException() {
        try {
            new Levenshtein<String>(this.csa1, this.csa2, 1.0, 1.0, 2.5, 0.0, new WorstCaseDistanceConversion());
            WhiteSpaceStringSequenceLevenshteinTest.fail((String)"Should raise a WeightBalanceException");
        }
        catch (WeightBalanceException weightBalanceException) {
            WhiteSpaceStringSequenceLevenshteinTest.assertTrue((boolean)true);
        }
        try {
            new Levenshtein<String>(this.csa1, this.csa2, 1.0, 1.0, 0.0, 2.5, new WorstCaseDistanceConversion());
            WhiteSpaceStringSequenceLevenshteinTest.fail((String)"Should raise a WeightBalanceException");
        }
        catch (WeightBalanceException weightBalanceException) {
            WhiteSpaceStringSequenceLevenshteinTest.assertTrue((boolean)true);
        }
        try {
            new Levenshtein<String>(this.csa1, this.csa2, 1.0, 1.0, 2.5, 2.5, new WorstCaseDistanceConversion());
            WhiteSpaceStringSequenceLevenshteinTest.fail((String)"Should raise a WeightBalanceException");
        }
        catch (WeightBalanceException weightBalanceException) {
            WhiteSpaceStringSequenceLevenshteinTest.assertTrue((boolean)true);
        }
    }
}

