/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.vector;

import junit.framework.TestCase;
import simpack.exception.InvalidVectorSizeException;
import simpack.measure.vector.Cosine;
import simpack.util.Vector;

public class CosineTest
extends TestCase {
    private Vector<Double> v1 = new Vector();
    private Vector<Double> v2 = new Vector();
    private Vector<Double> v3 = new Vector();

    public void setUp() {
        this.v1.add(1.0);
        this.v1.add(2.0);
        this.v1.add(3.0);
        this.v2.add(2.0);
        this.v2.add(5.0);
        this.v2.add(6.0);
        this.v3.add(1.0);
        this.v3.add(2.0);
    }

    public void testCosine() {
        Cosine cosine = null;
        try {
            cosine = new Cosine(this.v1, this.v2);
            CosineTest.assertNotNull((Object)cosine);
            CosineTest.assertTrue((boolean)cosine.calculate());
            CosineTest.assertTrue((boolean)cosine.isCalculated());
            double d = 0.0;
            d = this.v1.getDotProduct(this.v2);
            double d2 = this.v1.getNorm(2.0);
            double d3 = this.v2.getNorm(2.0);
            CosineTest.assertEquals((Object)cosine.getSimilarity(), (Object)(d / (d2 * d3)));
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
        }
    }

    public void testInvalidVectorSizeException() {
        try {
            Cosine cosine = new Cosine(this.v1, this.v3);
            CosineTest.fail((String)"Should throw an InvalidVectorSizeException");
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            CosineTest.assertTrue((boolean)true);
        }
    }
}

