/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.vector;

import junit.framework.TestCase;
import simpack.exception.InvalidVectorSizeException;
import simpack.measure.vector.Pearson;
import simpack.util.Vector;

public class PearsonTest
extends TestCase {
    private Vector<Double> v1 = new Vector();
    private Vector<Double> v2 = new Vector();
    private Vector<Double> v3 = new Vector();

    public void setUp() {
        this.v1.add(1.0);
        this.v1.add(2.0);
        this.v1.add(3.0);
        this.v2.add(2.0);
        this.v2.add(5.0);
        this.v2.add(6.0);
        this.v3.add(1.0);
        this.v3.add(2.0);
    }

    public void testPearson() {
        Pearson pearson = null;
        try {
            pearson = new Pearson(this.v1, this.v2);
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
        }
        PearsonTest.assertNotNull(pearson);
        PearsonTest.assertTrue((boolean)pearson.calculate());
        PearsonTest.assertTrue((boolean)pearson.isCalculated());
        double d = 0.0;
        try {
            d = this.v1.getDotProduct(this.v2);
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
        }
        double d2 = this.v1.getNorm(1.0) * this.v2.getNorm(1.0);
        double d3 = Math.pow(this.v1.getNorm(2.0), 2.0);
        double d4 = Math.pow(this.v1.getNorm(1.0), 2.0);
        double d5 = Math.pow(this.v2.getNorm(2.0), 2.0);
        double d6 = Math.pow(this.v2.getNorm(1.0), 2.0);
        double d7 = this.v1.size();
        PearsonTest.assertEquals((Object)pearson.getSimilarity(), (Object)(new Double(d - d2 / d7) / Math.sqrt((d3 - d4 / d7) * (d5 - d6 / d7))));
    }

    public void testInvalidVectorSizeException() {
        Pearson pearson = null;
        try {
            pearson = new Pearson(this.v1, this.v3);
            PearsonTest.fail((String)"Should throw an InvalidVectorSizeException");
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            PearsonTest.assertTrue((boolean)true);
        }
    }
}

