/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.weightingscheme;

import com.wcohen.ss.BasicStringWrapper;
import com.wcohen.ss.api.StringWrapper;
import java.util.ArrayList;
import junit.framework.TestCase;
import simpack.measure.weightingscheme.StringTFIDF;
import simpack.util.corpus.StringUtils;

public class StringTFIDFTest
extends TestCase {
    private ArrayList<StringWrapper> corpus;
    private String str1 = "Returns food of grocery store";
    private String str2 = "This service returns store food";
    private String str3 = "A grocery service selling food";
    private StringTFIDF tfidf;

    protected void setUp() throws Exception {
        this.corpus = new ArrayList();
        this.corpus.add((StringWrapper)new BasicStringWrapper(StringUtils.clean(this.str1)));
        this.corpus.add((StringWrapper)new BasicStringWrapper(StringUtils.clean(this.str2)));
        this.corpus.add((StringWrapper)new BasicStringWrapper(StringUtils.clean(this.str3)));
        StringTFIDFTest.assertNotNull(this.corpus);
    }

    public void testTFIDF() {
        String string = StringUtils.clean(this.str1);
        String string2 = StringUtils.clean(this.str2);
        String string3 = StringUtils.clean(this.str3);
        System.out.println(string + "\n" + string2 + "\n" + string3);
        this.tfidf = new StringTFIDF(this.corpus, string, string3);
        StringTFIDFTest.assertNotNull((Object)this.tfidf);
        double d = 0.22347915256519232;
        StringTFIDFTest.assertEquals((Object)this.tfidf.getSimilarity(), (Object)d);
    }

    public void testTFIDFEquality() {
        this.tfidf = new StringTFIDF(this.corpus, this.str1, this.str1);
        StringTFIDFTest.assertNotNull((Object)this.tfidf);
        StringTFIDFTest.assertEquals((Object)this.tfidf.getSimilarity(), (Object)0.9999999999999999);
    }
}

