/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.weightingscheme;

import com.wcohen.ss.BasicStringWrapper;
import com.wcohen.ss.api.StringWrapper;
import java.util.ArrayList;
import junit.framework.TestCase;
import simpack.measure.weightingscheme.StringTFIDF;
import simpack.tokenizer.SplittedStringTokenizerCohen;
import simpack.util.corpus.StringUtils;

public class StringTFIDFTest2
extends TestCase {
    private ArrayList<StringWrapper> corpus;
    private String str1 = "Auditory scene analysis based on time-frequency integration of shared FM and AM (II): Optimum time-domain integration and stream sound reconstruction.";
    private String str2 = "Auditory scene analysis based on time-frequency integration of shared FM and AM (I): Lagrange differential features and frequency-axis integration.";
    private String str3 = "Auditory stimulus optimization with feedback from fuzzy clustering of neuronal responses.";
    private StringTFIDF tfidf;

    protected void setUp() throws Exception {
        this.corpus = new ArrayList();
        this.corpus.add((StringWrapper)new BasicStringWrapper(StringUtils.clean(this.str1)));
        this.corpus.add((StringWrapper)new BasicStringWrapper(StringUtils.clean(this.str2)));
        this.corpus.add((StringWrapper)new BasicStringWrapper(StringUtils.clean(this.str3)));
        StringTFIDFTest2.assertNotNull(this.corpus);
    }

    public void testTFIDF() {
        String string = StringUtils.clean(this.str1);
        String string2 = StringUtils.clean(this.str2);
        System.out.println(string + "\n" + string2);
        this.tfidf = new StringTFIDF(this.corpus, string, string2, new SplittedStringTokenizerCohen("\\s+"));
        StringTFIDFTest2.assertNotNull((Object)this.tfidf);
        double d = 0.22347915256519232;
        StringTFIDFTest2.assertEquals((Object)this.tfidf.getSimilarity(), (Object)d);
    }

    public void testTFIDFEquality() {
        this.tfidf = new StringTFIDF(this.corpus, this.str1, this.str1, new SplittedStringTokenizerCohen("\\s{1}"));
        StringTFIDFTest2.assertNotNull((Object)this.tfidf);
        StringTFIDFTest2.assertEquals((Object)this.tfidf.getSimilarity(), (Object)0.9999999999999992);
    }
}

