/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.graph;

import java.io.Serializable;
import java.util.TreeSet;
import simpack.accessor.string.StringAccessor;
import simpack.api.IGraphNode;
import simpack.measure.sequence.Levenshtein;
import simpack.util.graph.comparator.MappedVertexComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedVertex
implements Serializable {
    private static final long serialVersionUID = -111393192702009001L;
    private static final String DEFAULT_SIMILARITY_MEASURE = "Levenshtein";
    private String similarityMeasure = "Levenshtein";
    private IGraphNode left;
    private IGraphNode right;
    private int groupSize = 0;
    private boolean groupFlag = false;
    private double labelSimilarity = 0.0;
    private double groupSimilarity = 0.0;
    private TreeSet<MappedVertex> groupMembers = new TreeSet<MappedVertex>(new MappedVertexComparator());

    public MappedVertex(IGraphNode iGraphNode, IGraphNode iGraphNode2) {
        this(iGraphNode, iGraphNode2, DEFAULT_SIMILARITY_MEASURE);
    }

    public MappedVertex(IGraphNode iGraphNode, IGraphNode iGraphNode2, String string) {
        this.left = iGraphNode;
        this.right = iGraphNode2;
        this.similarityMeasure = string;
    }

    public IGraphNode getLeftNode() {
        return this.left;
    }

    public IGraphNode getRightNode() {
        return this.right;
    }

    public void setGroupSize(int n) {
        this.groupSize = n;
        this.groupFlag = true;
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    public void setGroup() {
        this.groupFlag = true;
    }

    public boolean isGroup() {
        return this.groupFlag;
    }

    public void addGroupMember(MappedVertex mappedVertex) {
        this.groupMembers.add(mappedVertex);
    }

    public TreeSet<MappedVertex> getGroupMembers() {
        return this.groupMembers;
    }

    public void setLabelSimilarity(double d) {
        this.labelSimilarity = d;
    }

    public void setGroupSimilarity(double d) {
        this.groupSimilarity = d;
    }

    public double getGroupSimilarity() {
        return this.groupSimilarity;
    }

    public double getLabelSimilarity() {
        return this.labelSimilarity;
    }

    public double calculateLabelSimilarity() {
        double d = 0.0;
        if (this.similarityMeasure.equals(DEFAULT_SIMILARITY_MEASURE)) {
            Levenshtein<String> levenshtein = new Levenshtein<String>(new StringAccessor(((Object)this.getLeftNode()).toString()), new StringAccessor(((Object)this.getRightNode()).toString()));
            d = levenshtein.getSimilarity();
        }
        return d;
    }

    public int smaller(MappedVertex mappedVertex) {
        return this.toString().compareTo(mappedVertex.toString());
    }

    public boolean equals(Object object) {
        MappedVertex mappedVertex = (MappedVertex)object;
        if (!this.isGroup() && !mappedVertex.isGroup()) {
            return this.getLeftNode().equals(mappedVertex.getLeftNode()) && this.getRightNode().equals(mappedVertex.getRightNode());
        }
        if (this.isGroup() && !mappedVertex.isGroup() || !this.isGroup() && mappedVertex.isGroup()) {
            return false;
        }
        TreeSet<MappedVertex> treeSet = this.getGroupMembers();
        TreeSet<MappedVertex> treeSet2 = mappedVertex.getGroupMembers();
        return treeSet.equals(treeSet2);
    }

    public String toString() {
        if (!this.isGroup()) {
            return ((Object)this.getLeftNode()).toString() + ":" + ((Object)this.getRightNode()).toString();
        }
        String string = "<";
        TreeSet<MappedVertex> treeSet = this.getGroupMembers();
        for (MappedVertex mappedVertex : treeSet) {
            string = string + " " + ((Object)mappedVertex.getLeftNode()).toString() + ":" + ((Object)mappedVertex.getRightNode()).toString();
        }
        string = string + " >";
        return string;
    }
}

