/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.matrix;

import java.io.Serializable;
import java.util.Arrays;

public class OptimizedMatrix1D
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int size;
    private int[] positions;
    private double[] values;
    private final int upperDelimiter;
    private int realSize = 0;

    public OptimizedMatrix1D(int n) {
        this.size = n;
        this.upperDelimiter = n;
        this.positions = new int[4];
        this.values = new double[4];
        Arrays.fill(this.positions, this.upperDelimiter);
    }

    public OptimizedMatrix1D(int[] nArray, double[] dArray, int n, int n2) {
        this.positions = nArray;
        this.values = dArray;
        this.size = n;
        this.upperDelimiter = n;
        this.realSize = n2;
    }

    public int size() {
        return this.size;
    }

    private void moveOneBack(int n) {
        System.arraycopy(this.positions, n, this.positions, n + 1, this.realSize - n);
        System.arraycopy(this.values, n, this.values, n + 1, this.realSize - n);
    }

    private void ensureCapacity(int n) {
        if (n > this.positions.length) {
            int[] nArray = new int[this.positions.length * 3 / 2 + 1];
            double[] dArray = new double[this.positions.length * 3 / 2 + 1];
            Arrays.fill(nArray, this.upperDelimiter);
            System.arraycopy(this.positions, 0, nArray, 0, this.positions.length);
            System.arraycopy(this.values, 0, dArray, 0, this.values.length);
            this.positions = nArray;
            this.values = dArray;
        }
    }

    public void setQuick(int n, double d) {
        this.ensureCapacity(this.realSize + 1);
        if (this.realSize > 0 && n > this.positions[this.realSize - 1]) {
            this.positions[this.realSize] = n;
            this.values[this.realSize] = d;
            ++this.realSize;
            return;
        }
        this.insertValueAtPos(n, d);
    }

    private void insertValueAtPos(int n, double d) {
        int n2 = -1;
        int n3 = 0;
        int n4 = this.realSize - 1;
        int n5 = 0;
        while (n3 <= n4) {
            n5 = n3 + n4 >> 1;
            int n6 = this.positions[n5];
            if (n6 < n) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > n) {
                n4 = n5 - 1;
                continue;
            }
            this.values[n5] = d;
            return;
        }
        n2 = n < this.positions[n5] ? n5 : n5 + 1;
        if (this.positions[n2] != this.upperDelimiter) {
            this.moveOneBack(n2);
        }
        this.positions[n2] = n;
        this.values[n2] = d;
        ++this.realSize;
    }

    public double getQuick(int n) {
        int n2 = Arrays.binarySearch(this.positions, n);
        if (n2 < 0) {
            return 0.0;
        }
        return this.values[n2];
    }

    public OptimizedMatrix1D viewPart(int n, int n2) {
        int n3 = n + n2 - 1;
        if (n3 > this.size - 1) {
            n3 = this.size - 1;
        }
        if (n < 0) {
            n = 0;
        }
        n2 = n3 - n + 1;
        int n4 = 0;
        for (int i = 0; i < this.realSize; ++i) {
            if (this.positions[i] < n || this.positions[i] > n3) continue;
            ++n4;
        }
        int[] nArray = new int[n4];
        double[] dArray = new double[n4];
        int n5 = 0;
        for (int i = 0; i < this.realSize; ++i) {
            if (this.positions[i] < n || this.positions[i] > n3) continue;
            nArray[n5] = this.positions[i];
            dArray[n5] = this.values[i];
            ++n5;
        }
        return new OptimizedMatrix1D(nArray, dArray, this.size, n4);
    }

    public double zSum() {
        double d = 0.0;
        for (int i = 0; i < this.realSize; ++i) {
            d += this.values[i];
        }
        return d;
    }

    public double sumOfSquares() {
        double d = 0.0;
        for (int i = 0; i < this.realSize; ++i) {
            d += this.values[i] * this.values[i];
        }
        return d;
    }

    public double zDotProduct(OptimizedMatrix1D optimizedMatrix1D) {
        double d = 0.0;
        int n = 0;
        if (optimizedMatrix1D.realSize > 0) {
            for (int i = 0; i < this.realSize; ++i) {
                while (n < optimizedMatrix1D.realSize - 1 && optimizedMatrix1D.positions[n] < this.positions[i]) {
                    ++n;
                }
                if (this.positions[i] != optimizedMatrix1D.positions[n]) continue;
                d += this.values[i] * optimizedMatrix1D.values[n];
            }
        }
        return d;
    }

    public int[] getNonZeroPositions() {
        this.trim();
        return this.positions;
    }

    public double[] getNonZeroValues() {
        this.trim();
        return this.values;
    }

    public void trim() {
        if (this.realSize < this.positions.length) {
            int[] nArray = new int[this.realSize];
            double[] dArray = new double[this.realSize];
            System.arraycopy(this.positions, 0, nArray, 0, this.realSize);
            System.arraycopy(this.values, 0, dArray, 0, this.realSize);
            this.positions = nArray;
            this.values = dArray;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.realSize; ++i) {
            stringBuffer.append(this.positions[i] + ", " + this.values[i] + "\n");
        }
        return stringBuffer.toString();
    }
}

