/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.tree.visitor;

import java.util.Map;
import java.util.Stack;
import simpack.api.ITreeNode;
import simpack.util.tree.TreeNode;
import simpack.util.tree.visitor.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTreeVisitor
extends TreeVisitor {
    private Map<TreeNode, TreeNode> mapped;
    private ITreeNode tree;
    private ITreeNode mappedTree;
    private Stack<ITreeNode> currentParent = new Stack();
    private Stack<ITreeNode> currentParentMapped = new Stack();

    public BuildTreeVisitor(Map<TreeNode, TreeNode> map, ITreeNode iTreeNode) {
        super(iTreeNode);
        this.mapped = map;
        this.accept(iTreeNode);
    }

    @Override
    public boolean visit(ITreeNode iTreeNode) {
        if (!this.mapped.containsKey(iTreeNode)) {
            return false;
        }
        ITreeNode iTreeNode2 = (ITreeNode)iTreeNode.clone();
        if (iTreeNode.equals(this.root)) {
            this.tree = iTreeNode2;
            this.mappedTree = this.mapped.get(iTreeNode);
            this.currentParent.push(iTreeNode2);
            this.currentParentMapped.push(this.mappedTree);
        } else {
            this.currentParent.peek().add(iTreeNode2);
            this.currentParent.push(iTreeNode2);
            this.currentParentMapped.peek().add(this.mapped.get(iTreeNode));
            this.currentParentMapped.push(this.mapped.get(iTreeNode));
        }
        return true;
    }

    @Override
    public void postVisit(ITreeNode iTreeNode) {
        this.currentParent.pop();
        this.currentParentMapped.pop();
    }

    public ITreeNode getTree() {
        return this.tree;
    }

    public ITreeNode getMappedTree() {
        return this.mappedTree;
    }
}

