/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.tree.visitor.ast;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import simpack.util.tree.visitor.ast.Node;
import simpack.util.tree.visitor.ast.SourceCodeEntity;

public class JavaASTStructureTransformer
extends ASTVisitor {
    private int fStructureDepth = 0;
    private int fOverallDepth = 0;
    private Stack<Node> fStack = new Stack();

    public JavaASTStructureTransformer(Node node) {
        this.fStack.clear();
        this.fStack.push(node);
    }

    public int getOverallDepth() {
        return this.fOverallDepth;
    }

    public boolean visit(AssertStatement assertStatement) {
        this.pushValuedNode((ASTNode)assertStatement, assertStatement.getExpression().toString() + ":" + assertStatement.getMessage().toString());
        return false;
    }

    public void endVisit(AssertStatement assertStatement) {
        this.pop();
    }

    public boolean visit(Block block) {
        return true;
    }

    public void endVisit(Block block) {
    }

    public boolean visit(BreakStatement breakStatement) {
        this.pushValuedNode((ASTNode)breakStatement, breakStatement.getLabel() != null ? breakStatement.getLabel().toString() : "");
        return false;
    }

    public void endVisit(BreakStatement breakStatement) {
        this.pop();
    }

    public boolean visit(CatchClause catchClause) {
        this.pushValuedNode((ASTNode)catchClause, ((SimpleType)catchClause.getException().getType()).getName().getFullyQualifiedName());
        this.increaseLevel();
        catchClause.getBody().accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(CatchClause catchClause) {
        --this.fStructureDepth;
        this.pop();
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        this.pushValuedNode((ASTNode)constructorInvocation, constructorInvocation.toString());
        return false;
    }

    public void endVisit(ConstructorInvocation constructorInvocation) {
        this.pop();
    }

    public boolean visit(ContinueStatement continueStatement) {
        this.pushValuedNode((ASTNode)continueStatement, continueStatement.getLabel() != null ? continueStatement.getLabel().toString() : "");
        return false;
    }

    public void endVisit(ContinueStatement continueStatement) {
        this.pop();
    }

    public boolean visit(DoStatement doStatement) {
        this.pushValuedNode((ASTNode)doStatement, doStatement.getExpression().toString());
        this.increaseLevel();
        return true;
    }

    public void endVisit(DoStatement doStatement) {
        --this.fStructureDepth;
        this.pop();
    }

    public boolean visit(EmptyStatement emptyStatement) {
        this.pushEmptyNode((ASTNode)emptyStatement);
        return false;
    }

    public void endVisit(EmptyStatement emptyStatement) {
        this.pop();
    }

    public boolean visit(EnhancedForStatement enhancedForStatement) {
        this.pushValuedNode((ASTNode)enhancedForStatement, enhancedForStatement.getParameter().toString() + ":" + enhancedForStatement.getExpression().toString());
        this.increaseLevel();
        return true;
    }

    public void endVisit(EnhancedForStatement enhancedForStatement) {
        --this.fStructureDepth;
        this.pop();
    }

    public boolean visit(ExpressionStatement expressionStatement) {
        this.pushValuedNode((ASTNode)expressionStatement.getExpression(), expressionStatement.toString());
        return false;
    }

    public void endVisit(ExpressionStatement expressionStatement) {
        this.pop();
    }

    public boolean visit(ForStatement forStatement) {
        this.pushValuedNode((ASTNode)forStatement, forStatement.getExpression().toString());
        this.increaseLevel();
        return true;
    }

    public void endVisit(ForStatement forStatement) {
        --this.fStructureDepth;
        this.pop();
    }

    public boolean visit(IfStatement ifStatement) {
        String string = ifStatement.getExpression().toString();
        this.push(ifStatement.getNodeType(), string);
        this.increaseLevel();
        if (ifStatement.getThenStatement() != null) {
            this.push(90, string);
            ifStatement.getThenStatement().accept((ASTVisitor)this);
            this.pop();
        }
        if (ifStatement.getElseStatement() != null) {
            this.push(91, string);
            ifStatement.getElseStatement().accept((ASTVisitor)this);
            this.pop();
        }
        return false;
    }

    public void endVisit(IfStatement ifStatement) {
        --this.fStructureDepth;
        this.pop();
    }

    public boolean visit(LabeledStatement labeledStatement) {
        this.pushValuedNode((ASTNode)labeledStatement, labeledStatement.getLabel().getFullyQualifiedName());
        labeledStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(LabeledStatement labeledStatement) {
        this.pop();
    }

    public boolean visit(ReturnStatement returnStatement) {
        this.pushValuedNode((ASTNode)returnStatement, returnStatement.getExpression() != null ? returnStatement.getExpression().toString() : "");
        return false;
    }

    public void endVisit(ReturnStatement returnStatement) {
        this.pop();
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        this.pushValuedNode((ASTNode)superConstructorInvocation, superConstructorInvocation.toString());
        return false;
    }

    public void endVisit(SuperConstructorInvocation superConstructorInvocation) {
        this.pop();
    }

    public boolean visit(SwitchCase switchCase) {
        this.pushValuedNode((ASTNode)switchCase, switchCase.getExpression() != null ? switchCase.getExpression().toString() : "default");
        return false;
    }

    public void endVisit(SwitchCase switchCase) {
        this.pop();
    }

    public boolean visit(SwitchStatement switchStatement) {
        this.pushValuedNode((ASTNode)switchStatement, switchStatement.getExpression().toString());
        this.increaseLevel();
        this.visitList(switchStatement.statements());
        return false;
    }

    public void endVisit(SwitchStatement switchStatement) {
        --this.fStructureDepth;
        this.pop();
    }

    public boolean visit(SynchronizedStatement synchronizedStatement) {
        this.pushValuedNode((ASTNode)synchronizedStatement, synchronizedStatement.getExpression().toString());
        return true;
    }

    public void endVisit(SynchronizedStatement synchronizedStatement) {
        this.pop();
    }

    public boolean visit(ThrowStatement throwStatement) {
        this.pushValuedNode((ASTNode)throwStatement, throwStatement.getExpression().toString());
        return false;
    }

    public void endVisit(ThrowStatement throwStatement) {
        this.pop();
    }

    public boolean visit(TryStatement tryStatement) {
        this.pushEmptyNode((ASTNode)tryStatement);
        this.pushLabel(95);
        this.increaseLevel();
        tryStatement.getBody().accept((ASTVisitor)this);
        this.pop();
        --this.fStructureDepth;
        this.visitList(105, tryStatement.catchClauses());
        if (tryStatement.getFinally() != null) {
            this.pushLabel(106);
            this.increaseLevel();
            tryStatement.getFinally().accept((ASTVisitor)this);
            --this.fStructureDepth;
            this.pop();
        }
        return false;
    }

    public void endVisit(TryStatement tryStatement) {
        this.pop();
    }

    public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
        this.push(variableDeclarationStatement.getNodeType(), variableDeclarationStatement.toString());
        return false;
    }

    public void endVisit(VariableDeclarationStatement variableDeclarationStatement) {
        this.pop();
    }

    public boolean visit(WhileStatement whileStatement) {
        this.push(whileStatement.getNodeType(), whileStatement.getExpression().toString());
        this.increaseLevel();
        return true;
    }

    public void endVisit(WhileStatement whileStatement) {
        --this.fStructureDepth;
        this.pop();
    }

    private void visitList(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((ASTNode)iterator.next()).accept((ASTVisitor)this);
        }
    }

    private void visitList(int n, List list) {
        if (!list.isEmpty()) {
            this.pushLabel(n);
            this.visitList(list);
            this.pop();
        }
    }

    private void pushLabel(int n) {
        this.push(n, "");
    }

    private void pushValuedNode(ASTNode aSTNode, String string) {
        this.push(aSTNode.getNodeType(), string);
    }

    private void pushEmptyNode(ASTNode aSTNode) {
        this.push(aSTNode.getNodeType(), "");
    }

    private void push(int n, String string) {
        Node node = new Node(n, string.trim(), new SourceCodeEntity(string.trim(), n, this.fStructureDepth));
        node.setStatementDepth(this.fStructureDepth);
        this.getCurrentParent().add(node);
        this.fStack.push(node);
    }

    private void pop() {
        this.fStack.pop();
    }

    private Node getCurrentParent() {
        return this.fStack.peek();
    }

    private void increaseLevel() {
        ++this.fStructureDepth;
        this.fOverallDepth = this.fStructureDepth > this.fOverallDepth ? this.fStructureDepth : this.fOverallDepth;
    }
}

