/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.presentation;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.inference.OWLTaxonomyReasoner;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.io.vocabulary.OWLVocabularyAdapter;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.util.OWLManager;
import uk.ac.man.cs.img.owl.inference.NonInferencingTaxonomyReasoner;

public class PedroServlet
extends HttpServlet {
    public PedroServlet() {
        BasicConfigurator.configure();
        System.setProperty("org.semanticweb.owl.util.OWLConnection", "org.semanticweb.owl.impl.model.OWLConnectionImpl");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doRequest(request, response);
    }

    public void doRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getParameter("url") == null) {
            response.setContentType("text/html");
            PrintWriter out = new PrintWriter(response.getWriter());
            this.printHeader(out);
            this.printInfo(out);
            this.printForm(out);
            this.printFooter(out);
        } else {
            response.setContentType("text/plain");
            PrintWriter out = new PrintWriter(response.getWriter());
            String url = request.getParameter("url");
            String fragment = request.getParameter("fragment");
            if (url != null && !url.equals("")) {
                try {
                    URI uri = new URI(url.trim());
                    out.println(this.renderHierarchy(uri, fragment != null && fragment.equals("yes")));
                }
                catch (Exception e) {
                    out.println("Server Exception: " + e.getMessage());
                }
            } else {
                out.println("No URL supplied!");
            }
        }
    }

    protected void printHeader(PrintWriter out) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<!DOCTYPE html");
        out.println("     PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
        out.println("    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        out.println("<html lang=\"en\">");
        out.println("<head>");
        out.println("<title>OWL Ontology Pedro Servlet</title>");
        out.println("<style type=\"text/css\">");
        out.println("body {");
        out.println("font-family: arial;");
        out.println("background-color: #DDDDEE;");
        out.println("margin: 40 40 40 40;");
        out.println("}");
        out.println(".yes {");
        out.println("font-weight: bold;");
        out.println("color: green;");
        out.println("}");
        out.println(".no {");
        out.println("font-weight: bold;");
        out.println("color: red;");
        out.println("}");
        out.println(".faint {");
        out.println("background-color: #FFFFFF;");
        out.println("color: #AAAAAA;");
        out.println("}");
        out.println(".box {");
        out.println("padding: 0px 20px 10px 20px;");
        out.println("border:1px solid #888;");
        out.println("background-color: #FFFFFF;");
        out.println("}");
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
    }

    protected void printFooter(PrintWriter out) {
        this.printHost(out);
        out.println("</body>");
        out.println("</html>");
    }

    protected void printInfo(PrintWriter out) {
        out.println("<h1>OWL Ontology Pedro Servlet</h1>");
        out.println("<p>Paste the URL of an OWL-RDF ontology into the box below, select a format and hit return or press the Convert button. The servlet will return with a representation of the concept hierarchy in tab-delimited form. ");
        out.println("<hr/>");
    }

    protected void printForm(PrintWriter out) {
        out.println("<form action=\"Pedro\" method=\"get\">");
        out.println(" <table>");
        out.println("  <tr>");
        out.println("  <td><b>URL:</b></td>");
        out.println("  <td><input type=\"text\" size=\"80\" name=\"url\" value=\"\"/></td>");
        out.println("  <td><input type=\"submit\" value=\" Convert \"/></td>");
        out.println("  </tr>");
        out.println(" </table>");
        out.println("</form>");
    }

    protected void printHost(PrintWriter out) {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostName() + " [" + InetAddress.getLocalHost().getHostAddress() + "] ";
        }
        catch (UnknownHostException e) {
            host = "unknown";
        }
        out.println("<table>");
        out.println("<tr>");
        out.println("<td><span style='font-size:xx-small;'>OWL Servlet running on " + host + " under " + this.getServletContext().getServerInfo() + "</span></td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td><span style='font-size:xx-small;'>&copy; University of Manchester, 2003, &copy; University of Karlsruhe, 2003</span></td>");
        out.println("</tr>");
        out.println("</table>");
    }

    protected void printHelp(PrintWriter out) {
    }

    protected String renderHierarchy(URI uri, boolean fragment) {
        try {
            OWLConnection connection = OWLManager.getOWLConnection();
            OWLRDFParser parser = new OWLRDFParser();
            parser.setConnection(connection);
            OWLOntology ontology = parser.parseOntology(uri);
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            this.dumpHierarchy(ontology, pw, fragment);
            return ((Object)writer).toString();
        }
        catch (Exception ex) {
            return "Error: " + ex.getMessage();
        }
    }

    private void dumpHierarchy(OWLTaxonomyReasoner reasoner, PrintWriter pw, OWLClass clazz, boolean fragment, int level) throws OWLException {
        for (int i = 0; i < level; ++i) {
            pw.print("\t");
        }
        if (fragment) {
            pw.println(clazz.getURI().getFragment());
        } else {
            pw.println(clazz.getURI());
        }
        Set subs = reasoner.subClassesOf(clazz);
        Iterator sit = subs.iterator();
        while (sit.hasNext()) {
            Iterator innerIt = ((Set)sit.next()).iterator();
            while (innerIt.hasNext()) {
                OWLClass cl = (OWLClass)innerIt.next();
                this.dumpHierarchy(reasoner, pw, cl, fragment, level + 1);
            }
        }
    }

    private void dumpHierarchy(OWLOntology ontology, PrintWriter pw, boolean fragment) throws OWLException {
        try {
            NonInferencingTaxonomyReasoner reasoner = new NonInferencingTaxonomyReasoner();
            reasoner.setOntology(ontology);
            OWLClass thing = ontology.getClass(new URI(OWLVocabularyAdapter.INSTANCE.getThing()));
            this.dumpHierarchy((OWLTaxonomyReasoner)reasoner, pw, thing, fragment, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

