/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.util.OWLManager;
import uk.ac.man.cs.img.owl.io.tptp.Renderer;

public class ConverterServlet
extends HttpServlet {
    public ConverterServlet() {
        BasicConfigurator.configure();
        System.setProperty("org.semanticweb.owl.util.OWLConnection", "org.semanticweb.owl.impl.model.OWLConnectionImpl");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doRequest(request, response);
    }

    public void doRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getParameter("url") == null) {
            response.setContentType("text/html");
            PrintWriter out = new PrintWriter(response.getWriter());
            this.printHeader(out);
            this.printInfo(out);
            this.printForm(out);
            this.printFooter(out);
        } else {
            response.setContentType("text/plain");
            PrintWriter out = new PrintWriter(response.getWriter());
            String url = request.getParameter("url");
            String format = request.getParameter("format");
            if (url != null && !url.equals("") && format != null && !format.equals("")) {
                try {
                    URI uri = new URI(url.trim());
                    org.semanticweb.owl.io.abstract_syntax.Renderer renderer = new org.semanticweb.owl.io.abstract_syntax.Renderer();
                    if (!format.equals("abstract")) {
                        if (format.equals("fact")) {
                            renderer = new uk.ac.man.cs.img.owl.io.fact.Renderer();
                        } else if (format.equals("factplus")) {
                            renderer = new uk.ac.man.cs.img.owl.io.factplus.Renderer();
                        } else if (format.equals("tptp")) {
                            renderer = new Renderer();
                        } else if (format.equals("rdf")) {
                            renderer = new org.semanticweb.owl.io.owl_rdf.Renderer();
                        }
                    }
                    out.println(this.render(uri, (org.semanticweb.owl.io.Renderer)renderer));
                }
                catch (Exception e) {
                    out.println("Server Exception: " + e.getMessage());
                }
            } else {
                out.println("No URL supplied!");
            }
        }
    }

    protected void printHeader(PrintWriter out) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<!DOCTYPE html");
        out.println("     PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
        out.println("    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        out.println("<html lang=\"en\">");
        out.println("<head>");
        out.println("<title>OWL Ontology Converter</title>");
        out.println("<style type=\"text/css\">");
        out.println("body {");
        out.println("font-family: arial;");
        out.println("background-color: #DDDDEE;");
        out.println("margin: 40 40 40 40;");
        out.println("}");
        out.println(".yes {");
        out.println("font-weight: bold;");
        out.println("color: green;");
        out.println("}");
        out.println(".no {");
        out.println("font-weight: bold;");
        out.println("color: red;");
        out.println("}");
        out.println(".faint {");
        out.println("background-color: #FFFFFF;");
        out.println("color: #AAAAAA;");
        out.println("}");
        out.println(".box {");
        out.println("padding: 0px 20px 10px 20px;");
        out.println("border:1px solid #888;");
        out.println("background-color: #FFFFFF;");
        out.println("}");
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
    }

    protected void printFooter(PrintWriter out) {
        this.printHost(out);
        out.println("</body>");
        out.println("</html>");
    }

    protected void printInfo(PrintWriter out) {
        out.println("<h1>OWL Ontology Converter</h1>");
        out.println("<p>Paste the URL of an OWL-RDF ontology into the box below, select a format and hit return or press the Convert button. The servlet will then attempt to convert the ontology to the selected format. ");
        out.println("</p><p>No guarantees are provided as to the correctness of this converter.</p><p>Developed by Sean Bechhofer of the University of Manchester and Raphael Volz of the University of Karlsruhe.</p>");
        out.println("<hr/>");
    }

    protected void printForm(PrintWriter out) {
        out.println("<form action=\"Converter\" method=\"get\">");
        out.println(" <table>");
        out.println("  <tr>");
        out.println("  <td><b>URL:</b></td>");
        out.println("  <td><input type=\"text\" size=\"80\" name=\"url\" value=\"\"/></td>");
        out.println("  <td><input type=\"submit\" value=\" Convert \"/></td>");
        out.println("  </tr>");
        out.println(" </table>");
        out.println(" <table>");
        out.println("  <tr>");
        out.println("   <td><input type=\"radio\" name=\"format\" value=\"abstract\" checked=\"checked\"/></td>");
        out.println("   <td><b>Abstract Syntax</b></td>");
        out.println("   </tr><tr>");
        out.println("   <td><input type=\"radio\" name=\"format\" value=\"fact\"/></td>");
        out.println("   <td><b>FaCT</b>. Produces output suitable for the FaCT reasoner. Note that this includes a special encoding for individuals which allows FaCT to use the \"cheating semantics\" for enumerations. Domain and range restrictions are also translated to general axioms.</td>");
        out.println("   </tr><tr>");
        out.println("   <td><input type=\"radio\" name=\"format\" value=\"factplus\"/></td>");
        out.println("   <td><b>FaCT++</b>. Output suitable for the new implementation of FaCT.</td>");
        out.println("   </tr><tr>");
        out.println("   <td><input type=\"radio\" name=\"format\" value=\"tptp\"/></td>");
        out.println("   <td><b>TPTP</b>. Output suitable for FO theorem provers.</td>");
        out.println("   </tr>");
        out.println(" </table>");
        out.println("</form>");
    }

    protected void printHost(PrintWriter out) {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostName() + " [" + InetAddress.getLocalHost().getHostAddress() + "] ";
        }
        catch (UnknownHostException e) {
            host = "unknown";
        }
        out.println("<table>");
        out.println("<tr>");
        out.println("<td><span style='font-size:xx-small;'>OWL Converter running on " + host + " under " + this.getServletContext().getServerInfo() + "</span></td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td><span style='font-size:xx-small;'>&copy; University of Manchester, 2003, &copy; University of Karlsruhe, 2003</span></td>");
        out.println("</tr>");
        out.println("</table>");
    }

    protected void printHelp(PrintWriter out) {
    }

    protected String render(URI uri, org.semanticweb.owl.io.Renderer renderer) {
        try {
            OWLConnection connection = OWLManager.getOWLConnection();
            OWLRDFParser parser = new OWLRDFParser();
            parser.setConnection(connection);
            OWLOntology onto = parser.parseOntology(uri);
            StringWriter writer = new StringWriter();
            renderer.renderOntology(onto, (Writer)writer);
            return ((Object)writer).toString();
        }
        catch (Exception ex) {
            return "Error: " + ex.getMessage();
        }
    }
}

