/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.io.abstract_syntax.Renderer;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.util.OWLManager;
import org.semanticweb.owl.validation.SpeciesValidatorReporter;
import uk.ac.man.cs.img.owl.validation.ConstructChecker;
import uk.ac.man.cs.img.owl.validation.SpeciesValidator;

public class ValidatorServlet
extends HttpServlet {
    public ValidatorServlet() {
        BasicConfigurator.configure();
        System.setProperty("org.semanticweb.owl.util.OWLConnection", "org.semanticweb.owl.impl.model.OWLConnectionImpl");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doRequest(request, response);
    }

    public void doRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html;charset=utf-8");
        PrintWriter out = new PrintWriter(response.getWriter());
        this.printHeader(out);
        boolean printAbstract = true;
        boolean printLisp = false;
        boolean printConstructs = false;
        String url = request.getParameter("url");
        String abstractForm = request.getParameter("abstract");
        String constructs = request.getParameter("constructs");
        String lispForm = request.getParameter("fact");
        String rdf = request.getParameter("rdf");
        printAbstract = abstractForm != null && abstractForm.equals("yes");
        printConstructs = constructs != null && constructs.equals("yes");
        printLisp = lispForm != null && lispForm.equals("yes");
        URI uri = null;
        StringReader reader = null;
        URI physicalURI = null;
        try {
            if (url != null && !url.equals("")) {
                uri = new URI(url.trim());
            } else if (rdf != null && !rdf.equals("")) {
                reader = new StringReader(rdf);
                physicalURI = new URI("urn:wonderwebValidator");
            }
        }
        catch (URISyntaxException e) {
            out.println("URI Syntax Exception! " + url);
        }
        if (uri != null || reader != null) {
            try {
                OWLConnection connection = OWLManager.getOWLConnection();
                SpeciesValidator sv = new SpeciesValidator();
                sv.setConnection(connection);
                StringWriter lw = new StringWriter();
                StringWriter dw = new StringWriter();
                StringWriter fw = new StringWriter();
                StringWriter rw = new StringWriter();
                StringWriter mw = new StringWriter();
                final PrintWriter lpw = new PrintWriter(lw);
                final PrintWriter dpw = new PrintWriter(dw);
                final PrintWriter fpw = new PrintWriter(fw);
                final PrintWriter rpw = new PrintWriter(rw);
                final PrintWriter mpw = new PrintWriter(mw);
                sv.setReporter(new SpeciesValidatorReporter(){

                    public void ontology(OWLOntology onto) {
                    }

                    public void done(String str) {
                    }

                    public void message(String str) {
                        mpw.println("<li>" + str + "</li>");
                    }

                    public void explain(int l, String str) {
                        switch (l) {
                            case 0: {
                                lpw.println("<li>" + str + "</li>");
                                break;
                            }
                            case 1: {
                                dpw.println("<li>" + str + "</li>");
                                break;
                            }
                            case 3: {
                                fpw.println("<li>" + str + "</li>");
                                break;
                            }
                            case 7: {
                                rpw.println("<li>" + str + "</li>");
                            }
                        }
                    }

                    public void explain(int l, int code, String str) {
                        switch (l) {
                            case 0: {
                                lpw.println("<li>" + str + "</li>");
                                break;
                            }
                            case 1: {
                                dpw.println("<li>" + str + "</li>");
                                break;
                            }
                            case 3: {
                                fpw.println("<li>" + str + "</li>");
                                break;
                            }
                            case 7: {
                                rpw.println("<li>" + str + "</li>");
                            }
                        }
                    }
                });
                String level = request.getParameter("level");
                boolean ok = false;
                int l = 7;
                try {
                    if (level.equals("Lite")) {
                        ok = uri != null ? sv.isOWLLite(uri) : sv.isOWLLite((Reader)reader, physicalURI);
                        l = 0;
                    } else if (level.equals("DL")) {
                        ok = uri != null ? sv.isOWLDL(uri) : sv.isOWLDL((Reader)reader, physicalURI);
                        l = 1;
                    } else if (level.equals("Full")) {
                        ok = uri != null ? sv.isOWLFull(uri) : sv.isOWLFull((Reader)reader, physicalURI);
                        l = 3;
                    } else {
                        l = 999;
                    }
                    out.println("<h1>OWL Species Validation Report</h1>");
                    if (uri != null) {
                        out.println("URI: <a href=\"" + uri + "\">" + uri + "</a>");
                    }
                    if (l != 999) {
                        if (l < 0 && !lw.toString().equals("")) {
                            out.println("<h3>OWL Lite</h3>");
                            out.println("<ul>");
                            out.println(lw.toString());
                            out.println("</ul>");
                        }
                        if (l < 1 && !dw.toString().equals("")) {
                            out.println("<h3>OWL DL</h3>");
                            out.println("<ul>");
                            out.println(dw.toString());
                            out.println("</ul>");
                        }
                        if (l < 3 && !fw.toString().equals("")) {
                            out.println("<h3>OWL Full</h3>");
                            out.println("<ul>");
                            out.println(fw.toString());
                            out.println("</ul>");
                        }
                        if (l < 7 && !rw.toString().equals("")) {
                            out.println("<h3>OTHER</h3>");
                            out.println("<ul>");
                            out.println(rw.toString());
                            out.println("</ul>");
                        }
                        if (!mw.toString().equals("")) {
                            out.println("<h3>Additional Messages</h3>");
                            out.println("<ul>");
                            out.println(mw.toString());
                            out.println("</ul>");
                        }
                        out.println("<h2>Conclusion</h1>");
                        out.println("<p><strong>" + level + "</strong>: " + (ok ? "<span class=\"yes\">YES</span>" : "<span class=\"no\">NO</span>"));
                        out.println("<a href=\"why.html\">Why?</a></p>");
                        out.println("<hr/>");
                    }
                    connection = OWLManager.getOWLConnection();
                    OWLRDFParser parser = new OWLRDFParser();
                    parser.setConnection(connection);
                    OWLOntology onto = null;
                    if (uri != null) {
                        onto = parser.parseOntology(uri);
                    } else {
                        reader = new StringReader(rdf);
                        onto = parser.parseOntology((Reader)reader, physicalURI);
                    }
                    if (printConstructs) {
                        out.println("<h2>Constructs Used</h2>");
                        out.println("<div class='box'>");
                        out.println("<pre>");
                        out.println(this.constructs(onto));
                        out.println("</pre>");
                        out.println("</div>");
                        out.println("<hr/>");
                    }
                    if (printAbstract) {
                        out.println("<h2>Abstract Syntax Form</h2>");
                        out.println("<div class='box'>");
                        out.println("<pre>");
                        out.println(this.abstractForm(onto));
                        out.println("</pre>");
                        out.println("</div>");
                        out.println("<hr/>");
                    }
                    if (printLisp) {
                        out.println("<div class='box'>");
                        out.println("<pre>");
                        out.println(this.lispForm(onto));
                        out.println("</pre>");
                        out.println("</div>");
                        out.println("<hr/>");
                    }
                    out.println("<form action=\"Validator\" method=\"post\">");
                    out.println(" <table>");
                    out.println("  <tr>");
                    out.println("  <tr>");
                    out.println("  <td><b>RDF:</b></td>");
                    out.println("  <td><textarea rows=\"12\" cols=\"80\" name=\"rdf\">" + (rdf != null ? rdf : "") + "</textarea></td><td></td>");
                    out.println("  </tr>");
                    out.println("  <td><b>URL:</b></td>");
                    out.println("  <td><input type=\"text\" size=\"80\" name=\"url\" value=\"" + (uri != null ? uri.toString() : "") + "\"/></td>");
                    out.println("  <td><input type=\"submit\" value=\" Validate \"/></td>");
                    out.println("  </tr>");
                    out.println(" </table>");
                    out.println(" <table>");
                    out.println("  <tr>");
                    out.println("   <td><input type=\"radio\" name=\"level\" value=\"None\"" + (l == 999 ? "checked=\"checked\"" : "") + "/></td>");
                    out.println("   <td>None</td>");
                    out.println("   </tr><tr>");
                    out.println("   <td><input type=\"radio\" name=\"level\" value=\"Lite\"" + (l == 0 ? "checked=\"checked\"" : "") + "/></td>");
                    out.println("   <td>OWL Lite</td>");
                    out.println("   </tr><tr>");
                    out.println("   <td><input type=\"radio\" name=\"level\" value=\"DL\"" + (l == 1 ? "checked=\"checked\"" : "") + "/></td>");
                    out.println("   <td>OWL DL</td>");
                    out.println("   </tr><tr>");
                    out.println("   <td><input type=\"radio\" name=\"level\" value=\"Full\"" + (l == 3 ? "checked=\"checked\"" : "") + "/></td>");
                    out.println("   <td>OWL Full</td>");
                    out.println("   </tr><tr>");
                    out.println("   <td><input type=\"checkbox\" name=\"constructs\" value=\"yes\"" + (printConstructs ? "checked=\"checked\"" : "") + "/></td>");
                    out.println("   <td>Show Constructs Used</td>");
                    out.println("   </tr><tr>");
                    out.println("   <td><input type=\"checkbox\" name=\"abstract\" value=\"yes\"" + (printAbstract ? "checked=\"checked\"" : "") + "/></td>");
                    out.println("   <td>Show Abstract Form</td>");
                    out.println("   </tr>");
                    out.println(" </table>");
                    out.println("</form>");
                }
                catch (Exception e) {
                    out.println("Server Exception: " + e.getMessage());
                    this.printForm(out);
                }
            }
            catch (OWLException e) {
                out.println("OWL Exception! " + e.getMessage());
                this.printForm(out);
            }
        } else {
            this.printInfo(out);
            this.printForm(out);
        }
        this.printFooter(out);
    }

    protected void printHeader(PrintWriter out) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<!DOCTYPE html");
        out.println("     PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
        out.println("    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        out.println("<html lang=\"en\">");
        out.println("<head>");
        out.println("<title>WonderWeb OWL Ontology Validator</title>");
        out.println("<style type=\"text/css\">");
        out.println("body {");
        out.println("font-family: arial;");
        out.println("background-color: #EEEEEE;");
        out.println("margin: 40 40 40 40;");
        out.println("}");
        out.println(".yes {");
        out.println("font-weight: bold;");
        out.println("color: green;");
        out.println("}");
        out.println(".no {");
        out.println("font-weight: bold;");
        out.println("color: red;");
        out.println("}");
        out.println(".faint {");
        out.println("background-color: #FFFFFF;");
        out.println("color: #AAAAAA;");
        out.println("}");
        out.println(".box {");
        out.println("padding: 0px 20px 10px 20px;");
        out.println("border:1px solid #888;");
        out.println("background-color: #FFFFFF;");
        out.println("}");
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
    }

    protected void printFooter(PrintWriter out) {
        this.printHost(out);
        out.println("</body>");
        out.println("</html>");
    }

    protected void printInfo(PrintWriter out) {
        out.println("<h1>WonderWeb OWL Ontology Validator</h1>");
        out.println("<p>Paste the URL of an OWL-RDF ontology into the box below, select a language species and hit return or press the Validate button. Alternatvely, paste RDF into the textarea. This should be a complete RDF file, including headers. The servlet will then attempt to validate the ontology against the selected species. Any constructs found which relate to particular species of <a href=\"http://www.w3.org/2001/sw/WebOnt\">OWL</a> will be reported. ");
        out.println("<p>In addition, if requested, the validator will return a description of the classes,");
        out.println("properties and individuals in the ontology in terms of the OWL Abstract Syntax.</p>");
        out.println("</p><p>No guarantees are provided as to the correctness of this validator.</p><p>Developed by Sean Bechhofer of the University of Manchester and Raphael Volz of the University of Karlsruhe as part of the EU IST Project <a href='http://wonderweb.semanticweb.org'>WonderWeb</a>.</p>");
        out.println("<hr/>");
    }

    protected void printForm(PrintWriter out) {
        out.println("<form action=\"Validator\" method=\"post\">");
        out.println("<table>");
        out.println("<tr><td>");
        out.println(" <table>");
        out.println("  <tr>");
        out.println("  <td><b>RDF:</b></td>");
        out.println("  <td><textarea rows=\"12\" cols=\"80\" name=\"rdf\"></textarea></td><td></td>");
        out.println("  </tr>");
        out.println("  <tr>");
        out.println("  <td><b>URL:</b></td>");
        out.println("  <td><input type=\"text\" size=\"80\" name=\"url\"/></td>");
        out.println("  <td><input type=\"submit\" value=\" Validate \"/></td>");
        out.println("  </tr>");
        out.println(" </table>");
        out.println(" <table>");
        out.println("  <tr>");
        out.println("   <td><input type=\"radio\" name=\"level\" value=\"None\"/></td>");
        out.println("   <td>None</td>");
        out.println("   </tr><tr>");
        out.println("   <td><input type=\"radio\" name=\"level\" value=\"Lite\" checked=\"checked\"/></td>");
        out.println("   <td>OWL Lite</td>");
        out.println("   </tr><tr>");
        out.println("   <td><input type=\"radio\" name=\"level\" value=\"DL\"/></td>");
        out.println("   <td>OWL DL</td>");
        out.println("   </tr><tr>");
        out.println("   <td><input type=\"radio\" name=\"level\" value=\"Full\"/></td>");
        out.println("   <td>OWL Full</td>");
        out.println("   </tr><tr>");
        out.println("   <td><input type=\"checkbox\" name=\"constructs\" value=\"yes\"/></td>");
        out.println("   <td>Show Constructs Used</td>");
        out.println("   </tr><tr>");
        out.println("   <td><input type=\"checkbox\" name=\"abstract\" value=\"yes\" checked=\"checked\"/></td>");
        out.println("   <td>Show Abstract Form</td>");
        out.println("   </tr>");
        out.println(" </table>");
        out.println("</td></tr>");
        out.println("</table>");
        out.println("</form>");
    }

    protected void printHost(PrintWriter out) {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostName() + " [" + InetAddress.getLocalHost().getHostAddress() + "] ";
        }
        catch (UnknownHostException e) {
            host = "unknown";
        }
        out.println("<table>");
        out.println("<tr>");
        out.println("<td><span style='font-size:xx-small;'>OWL Validator running on " + host + " under " + this.getServletContext().getServerInfo() + "</span></td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td><span style='font-size:xx-small;'>&copy; University of Manchester, 2003, &copy; University of Karlsruhe, 2003</span></td>");
        out.println("</tr>");
        out.println("</table>");
    }

    protected void printHelp(PrintWriter out) {
    }

    protected String constructs(OWLOntology onto) {
        String result = "";
        try {
            ConstructChecker checker = new ConstructChecker();
            Iterator it = ConstructChecker.used((Set)checker.constructsUsed(onto)).iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                result = result + s + "<br/>";
            }
            return result;
        }
        catch (Exception ex) {
            return "Error: " + ex.getMessage();
        }
    }

    protected String abstractForm(OWLOntology onto) {
        try {
            Renderer renderer = new Renderer();
            StringWriter writer = new StringWriter();
            renderer.renderOntology(onto, (Writer)writer);
            String results = ((Object)writer).toString();
            results = results.replaceAll("<", "&lt;");
            results = results.replaceAll(">", "&gt;");
            return results;
        }
        catch (Exception ex) {
            return "Error: " + ex.getMessage();
        }
    }

    protected String lispForm(OWLOntology onto) {
        try {
            uk.ac.man.cs.img.owl.io.fact.Renderer renderer = new uk.ac.man.cs.img.owl.io.fact.Renderer();
            StringWriter writer = new StringWriter();
            renderer.renderOntology(onto, (Writer)writer);
            return ((Object)writer).toString();
        }
        catch (Exception ex) {
            return "Error: " + ex.getMessage();
        }
    }
}

