/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Collection;
import java.util.Set;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.iterator.MultiListIterator;

public class ELSyntaxUtils {
    public static boolean isEL(ATermAppl concept) {
        AFun fun = concept.getAFun();
        boolean isEL = false;
        if (ATermUtils.isPrimitive((ATermAppl)concept) || ATermUtils.isBottom((ATermAppl)concept)) {
            isEL = true;
        } else if (fun.equals(ATermUtils.ANDFUN)) {
            ATermList listEL = (ATermList)concept.getArgument(0);
            while (!listEL.isEmpty() && ELSyntaxUtils.isEL((ATermAppl)listEL.getFirst())) {
                listEL = listEL.getNext();
            }
            isEL = listEL.isEmpty();
        } else if (fun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl q = (ATermAppl)concept.getArgument(1);
            isEL = ELSyntaxUtils.isEL(q);
        } else {
            isEL = false;
        }
        return isEL;
    }

    public static ATermAppl simplify(ATermAppl elConcept) throws InternalReasonerException {
        ATermAppl simp = elConcept;
        AFun fun = elConcept.getAFun();
        if (fun.equals(ATermUtils.ANDFUN)) {
            ATermList conjuncts = (ATermList)elConcept.getArgument(0);
            Set set = CollectionUtils.makeSet();
            MultiListIterator i = new MultiListIterator(conjuncts);
            while (i.hasNext()) {
                ATermAppl c = i.next();
                if (ATermUtils.isAnd((ATermAppl)c)) {
                    i.append((ATermList)c.getArgument(0));
                    continue;
                }
                if (c.equals(ATermUtils.BOTTOM)) {
                    return ATermUtils.BOTTOM;
                }
                if (c.equals(ATermUtils.TOP)) continue;
                set.add(c);
            }
            if (set.size() > 1) {
                simp = ATermUtils.makeAnd((ATermList)ATermUtils.toSet((Collection)set));
            } else if (set.size() == 1) {
                simp = (ATermAppl)set.iterator().next();
            }
        } else if (fun.equals(ATermUtils.SOMEFUN)) {
            ATerm p = elConcept.getArgument(0);
            ATermAppl q = (ATermAppl)elConcept.getArgument(1);
            ATermAppl qSimp = ELSyntaxUtils.simplify(q);
            simp = qSimp.equals(ATermUtils.BOTTOM) ? ATermUtils.BOTTOM : ATermUtils.makeSomeValues((ATerm)p, (ATerm)qSimp);
        } else if (!(ATermUtils.isPrimitive((ATermAppl)elConcept) || ATermUtils.isBottom((ATermAppl)elConcept) || ATermUtils.isTop((ATermAppl)elConcept))) {
            throw new InternalReasonerException("Concept " + elConcept + " is not an EL concept");
        }
        return simp;
    }
}

