/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.el.ELSyntaxUtils;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleRestrictionCache {
    private Map<ATermAppl, ATermAppl> m_Domains = CollectionUtils.makeMap();
    private Map<ATermAppl, ATermAppl> m_Ranges = CollectionUtils.makeMap();

    public RoleRestrictionCache(RBox rbox) {
        this.prepareDomains(rbox);
        this.prepareRanges(rbox);
    }

    private void prepareDomains(RBox rbox) {
        for (Role role : rbox.getRoles()) {
            Set domains = role.getDomains();
            if (domains == null) continue;
            Set assertedDomains = CollectionUtils.makeSet();
            for (ATermAppl domain : domains) {
                if (!rbox.isDomainAsserted((ATerm)role.getName(), domain)) continue;
                assertedDomains.add(domain);
            }
            if (assertedDomains.isEmpty()) continue;
            RoleRestrictionCache.addTo(this.m_Domains, role.getName(), assertedDomains);
        }
    }

    private void prepareRanges(RBox rbox) {
        for (Role role : rbox.getRoles()) {
            Set ranges = role.getRanges();
            if (ranges == null) continue;
            Set assertedRanges = CollectionUtils.makeSet();
            for (ATermAppl range : ranges) {
                if (!rbox.isRangeAsserted((ATerm)role.getName(), range)) continue;
                assertedRanges.add(range);
            }
            RoleRestrictionCache.addTo(this.m_Ranges, role.getName(), assertedRanges);
        }
    }

    private static void addTo(Map<ATermAppl, ATermAppl> map, ATermAppl roleName, Set<ATermAppl> asserted) {
        if (asserted.isEmpty()) {
            return;
        }
        ATermAppl range = null;
        range = asserted.size() == 1 ? asserted.iterator().next() : ATermUtils.makeAnd((ATermList)ATermUtils.toSet(asserted));
        range = ELSyntaxUtils.simplify(ATermUtils.nnf((ATermAppl)range));
        map.put(roleName, range);
    }

    public Map<ATermAppl, ATermAppl> getDomains() {
        return this.m_Domains;
    }

    public Map<ATermAppl, ATermAppl> getRanges() {
        return this.m_Ranges;
    }

    public ATermAppl getDomain(ATermAppl prop) {
        return this.m_Domains.get(prop);
    }

    public ATermAppl getRange(ATermAppl prop) {
        return this.m_Ranges.get(prop);
    }
}

