/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.model;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryAtomImpl
implements QueryAtom {
    protected final QueryPredicate predicate;
    protected final List<ATermAppl> arguments;
    protected boolean ground;

    public QueryAtomImpl(QueryPredicate predicate, ATermAppl ... arguments) {
        this(predicate, Arrays.asList(arguments));
    }

    public QueryAtomImpl(QueryPredicate predicate, List<ATermAppl> arguments) {
        if (predicate == null) {
            throw new RuntimeException("Predicate cannot be null.");
        }
        this.predicate = predicate;
        this.arguments = arguments;
        this.ground = true;
        for (ATermAppl a : arguments) {
            if (!ATermUtils.isVar((ATermAppl)a)) continue;
            this.ground = false;
            break;
        }
    }

    @Override
    public QueryPredicate getPredicate() {
        return this.predicate;
    }

    @Override
    public List<ATermAppl> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isGround() {
        return this.ground;
    }

    @Override
    public QueryAtom apply(ResultBinding binding) {
        if (this.isGround()) {
            return this;
        }
        ArrayList<ATermAppl> newArguments = new ArrayList<ATermAppl>();
        for (ATermAppl a : this.arguments) {
            if (binding.isBound(a)) {
                newArguments.add(binding.getValue(a));
                continue;
            }
            newArguments.add(a);
        }
        return newArguments.isEmpty() ? this : new QueryAtomImpl(this.predicate, newArguments);
    }

    public int hashCode() {
        return 31 * this.predicate.hashCode() + ((Object)this.arguments).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryAtomImpl other = (QueryAtomImpl)obj;
        return this.predicate.equals((Object)other.predicate) && ((Object)this.arguments).equals(other.arguments);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.arguments.size(); ++i) {
            ATermAppl a = this.arguments.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ATermUtils.toString((ATermAppl)a));
        }
        return (Object)((Object)this.predicate) + "(" + sb.toString() + ")";
    }
}

