/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi;

import com.clarkparsia.owlapi.OWL;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLOntologyStorageException;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.model.UnknownOWLOntologyException;
import org.semanticweb.owl.util.OWLEntityCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyUtils {
    private static OWLOntologyManager manager = OWL.manager;
    private static OWLEntityCollector collector = new OWLEntityCollector();

    public static void addAxioms(OWLOntology ontology, Collection<? extends OWLAxiom> axioms) throws OWLException {
        OntologyUtils.updateOntology(ontology, axioms, true);
    }

    public static void addAxioms(OWLOntology ontology, OWLAxiom ... axioms) throws OWLException {
        OntologyUtils.addAxioms(ontology, Arrays.asList(axioms));
    }

    public static boolean containsClass(Set<Set<OWLClass>> classes, OWLClass cls) {
        for (Set<OWLClass> set : classes) {
            if (!set.contains(cls)) continue;
            return true;
        }
        return false;
    }

    public static Set<OWLEntity> getSignature(OWLAxiom axiom) {
        collector.reset();
        axiom.accept((OWLObjectVisitor)collector);
        return new HashSet<OWLEntity>(collector.getObjects());
    }

    public static OWLOntology getOntologyFromAxioms(Collection<OWLAxiom> axioms) {
        URI uri = URI.create("http://www.example.org/ontology" + new UID());
        return OntologyUtils.getOntologyFromAxioms(axioms, uri);
    }

    public static OWLOntology getOntologyFromAxioms(Collection<OWLAxiom> axioms, URI uri) {
        OWLOntology module;
        try {
            module = manager.createOntology(uri);
            ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
            for (OWLAxiom axiom : axioms) {
                changes.add(new AddAxiom(module, axiom));
            }
            manager.applyChanges(changes);
        }
        catch (OWLOntologyCreationException e) {
            throw new RuntimeException(e);
        }
        catch (OWLOntologyChangeException e) {
            throw new RuntimeException(e);
        }
        return module;
    }

    public static OWLOntology getOntologyFromAxioms(OWLAxiom ... axioms) {
        return OntologyUtils.getOntologyFromAxioms(Arrays.asList(axioms));
    }

    public static OWLOntologyManager getOWLOntologyManager() {
        return manager;
    }

    public static OWLOntology loadOntology(String uri) {
        try {
            return manager.loadOntology(URI.create(uri));
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public static OWLOntology loadOntology(String uri, boolean withAnnotations) {
        OWLOntology ont = OntologyUtils.loadOntology(uri);
        if (!withAnnotations) {
            OntologyUtils.removeAllAnnotations(ont, manager);
        }
        return ont;
    }

    public static void printAxioms(Collection<OWLAxiom> axioms) {
        for (OWLAxiom axiom : axioms) {
            System.out.println(axiom);
        }
    }

    public static void printOntology(OWLOntology ont) {
        OntologyUtils.printAxioms(ont.getAxioms());
    }

    public static void removeAxioms(OWLOntology ontology, Collection<? extends OWLAxiom> axioms) throws OWLException {
        OntologyUtils.updateOntology(ontology, axioms, false);
    }

    public static void removeAxioms(OWLOntology ontology, OWLAxiom ... axioms) throws OWLException {
        OntologyUtils.removeAxioms(ontology, Arrays.asList(axioms));
    }

    public static void save(OWLOntology ont, String path) throws UnknownOWLOntologyException, OWLOntologyStorageException {
        manager.saveOntology(ont, new File(path).toURI());
    }

    public static void updateOntology(OWLOntology ontology, Collection<? extends OWLAxiom> axioms, boolean add) throws OWLException {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLAxiom oWLAxiom : axioms) {
            AddAxiom change = add ? new AddAxiom(ontology, oWLAxiom) : new RemoveAxiom(ontology, oWLAxiom);
            changes.add(change);
        }
        manager.applyChanges(changes);
    }

    public static boolean containsUnreferencedEntity(OWLOntology ontology, OWLDescription desc) {
        OWLEntityCollector entityCollector = new OWLEntityCollector();
        desc.accept((OWLObjectVisitor)entityCollector);
        for (OWLEntity entity : entityCollector.getObjects()) {
            if (ontology.containsEntityReference(entity) || entity instanceof OWLClass && (((OWLClass)entity).isOWLThing() || ((OWLClass)entity).isOWLNothing())) continue;
            return true;
        }
        return false;
    }

    public static Set<OWLOntology> removeAxiom(OWLAxiom axiom, Set<OWLOntology> ontologies, OWLOntologyManager manager) throws OWLOntologyChangeException {
        HashSet<OWLOntology> modifiedOnts = new HashSet<OWLOntology>();
        for (OWLOntology ont : ontologies) {
            if (!ont.getAxioms().contains(axiom)) continue;
            modifiedOnts.add(ont);
            manager.applyChange((OWLOntologyChange)new RemoveAxiom(ont, axiom));
        }
        return modifiedOnts;
    }

    public static void addAxiom(OWLAxiom axiom, Set<OWLOntology> ontologies, OWLOntologyManager manager) throws OWLOntologyChangeException {
        for (OWLOntology ont : ontologies) {
            manager.applyChange((OWLOntologyChange)new AddAxiom(ont, axiom));
        }
    }

    public static void removeAllAnnotations(OWLOntology ontology, OWLOntologyManager manager) {
        try {
            HashSet referencedEntities = new HashSet();
            referencedEntities.addAll(ontology.getReferencedClasses());
            referencedEntities.addAll(ontology.getReferencedObjectProperties());
            referencedEntities.addAll(ontology.getReferencedDataProperties());
            referencedEntities.addAll(ontology.getReferencedIndividuals());
            ArrayList<Object> changes = new ArrayList<Object>();
            for (OWLAxiom axiom : ontology.getAxioms()) {
                if (axiom.isLogicalAxiom()) continue;
                changes.add(new RemoveAxiom(ontology, axiom));
            }
            manager.applyChanges(changes);
            changes = new ArrayList();
            for (OWLEntity entity : referencedEntities) {
                if (ontology.containsEntityReference(entity)) continue;
                OWLDeclarationAxiom declaration = manager.getOWLDataFactory().getOWLDeclarationAxiom(entity);
                changes.add(new AddAxiom(ontology, (OWLAxiom)declaration));
            }
            manager.applyChanges(changes);
        }
        catch (OWLOntologyChangeException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public static OWLEntity findEntity(String name, Set<OWLOntology> ontologies) {
        OWLOntology ontology;
        OWLEntity entity = null;
        Iterator<OWLOntology> i$ = ontologies.iterator();
        while (i$.hasNext() && (entity = OntologyUtils.findEntity(name, ontology = i$.next())) == null) {
        }
        return entity;
    }

    public static OWLEntity findEntity(String name, OWLOntology ontology) {
        OWLClass entity = null;
        if (name.equals("owl:Thing")) {
            entity = OWL.Thing;
        } else if (name.equals("owl:Nothing")) {
            entity = OWL.Nothing;
        } else {
            URI uri = URI.create(name);
            if (uri == null) {
                try {
                    uri = new URI(name);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!uri.isAbsolute()) {
                URI baseURI = ontology.getURI();
                uri = baseURI.resolve("#" + uri);
            }
            if (ontology.containsClassReference(uri)) {
                entity = OWL.Class(uri);
            } else if (ontology.containsObjectPropertyReference(uri)) {
                entity = OWL.ObjectProperty(uri);
            } else if (ontology.containsDataPropertyReference(uri)) {
                entity = OWL.DataProperty(uri);
            } else if (ontology.containsIndividualReference(uri)) {
                entity = OWL.Individual(uri);
            }
        }
        return entity;
    }

    static {
        collector.setCollectDataTypes(false);
    }
}

