/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io.abstract_syntax;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owl.io.Parser;
import org.semanticweb.owl.io.ParserException;
import org.semanticweb.owl.io.abstract_syntax.ANTLRParser;
import org.semanticweb.owl.io.abstract_syntax.AbstractOWLLexer;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.helper.OWLBuilder;
import org.semanticweb.owl.util.OWLConnection;

public class AbstractOWLParser
implements Parser {
    public static final String RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String XSD = "http://www.w3.org/2001/XMLSchema#";
    public static final String RDFS = "http://www.w3.org/2000/01/rdf-schema#";
    public static final String OWL = "http://www.w3.org/2002/07/owl#";
    ANTLRParser antlrParser;
    OWLBuilder builder;
    Map options;

    public AbstractOWLParser() {
        this.builder = new OWLBuilder();
    }

    public AbstractOWLParser(OWLConnection connection) {
        this.builder = new OWLBuilder(connection);
    }

    public ANTLRParser getANTLRParser() {
        return this.antlrParser;
    }

    public void setANTLRParser(ANTLRParser newAntlrParser) {
        this.antlrParser = newAntlrParser;
    }

    public OWLBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(OWLBuilder newBuilder) {
        this.builder = newBuilder;
    }

    public OWLConnection getConnection() {
        return this.builder.getConnection();
    }

    public void setConnection(OWLConnection newConnection) {
        this.builder.setConnection(newConnection);
    }

    public OWLOntology parseOntology(URI uri) throws ParserException {
        try {
            return this.parseOntology(new InputStreamReader(uri.toURL().openStream()), uri);
        }
        catch (MalformedURLException e) {
            throw new ParserException(uri.toString() + " is not well formed", (Exception)e);
        }
        catch (IOException e) {
            throw new ParserException("IOException while parsing " + uri.toString(), (Exception)e);
        }
    }

    public OWLOntology parseOntology(Reader reader, URI physicalURI) throws ParserException {
        try {
            AbstractOWLLexer lexer = new AbstractOWLLexer(reader);
            this.antlrParser = new ANTLRParser(lexer);
            this.initialiseNamespaceTable();
            OWLOntology ontology = this.antlrParser.ontology(physicalURI, this.builder);
            reader.close();
            return ontology;
        }
        catch (RecognitionException e) {
            throw new ParserException("RecognitionException while parsing " + physicalURI.toString(), (Exception)((Object)e));
        }
        catch (TokenStreamException e) {
            throw new ParserException("TokenStreamException while parsing " + physicalURI.toString(), (Exception)((Object)e));
        }
        catch (OWLException e) {
            throw new ParserException("OWLException while parsing " + physicalURI.toString(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ParserException("IOException while parsing " + physicalURI.toString(), (Exception)e);
        }
    }

    public void setOptions(Map newOptions) {
        this.options = newOptions;
    }

    public Map getOptions() {
        return this.options;
    }

    public OWLDescription parseDescription(Reader descriptionReader) throws OWLException, RecognitionException, TokenStreamException, FileNotFoundException, IOException, ParserException {
        if (this.antlrParser == null) {
            throw new ParserException("ANTLRParser has not been initialised");
        }
        AbstractOWLLexer lexer = new AbstractOWLLexer(descriptionReader);
        ANTLRParser descriptionParser = new ANTLRParser(lexer);
        OWLDescription owlDescription = descriptionParser.externalDescription(this.builder, this.antlrParser.getIdsTable(), this.antlrParser.getNamespaceTable());
        descriptionReader.close();
        return owlDescription;
    }

    public OWLDescription parseDescription(String descriptionString) throws OWLException, RecognitionException, TokenStreamException, FileNotFoundException, IOException, ParserException {
        return this.parseDescription(new StringReader(descriptionString));
    }

    void initialiseNamespaceTable() throws ParserException {
        if (this.antlrParser == null) {
            throw new ParserException("ANTLRParser has not been initialised");
        }
        HashMap<String, String> namespaceTable = new HashMap<String, String>();
        namespaceTable.put("rdf", RDF);
        namespaceTable.put("xsd", XSD);
        namespaceTable.put("rdfs", RDFS);
        namespaceTable.put("owl", OWL);
        this.antlrParser.setNamespaceTable(namespaceTable);
    }

    public static void main(String[] args) {
        try {
            new AbstractOWLParser().parseOntology(new URI(args[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

