/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia;

import aterm.ATermAppl;
import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.mindswap.pellet.output.ATermManchesterSyntaxRenderer;
import org.mindswap.pellet.test.PelletTestCase;

public class TestATermManchesterSyntaxRenderer {
    public static Test suite() {
        return new JUnit4TestAdapter(TestATermManchesterSyntaxRenderer.class);
    }

    @org.junit.Test
    public void testAll() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = PelletTestCase.term("C");
        ATermAppl p = PelletTestCase.term("p");
        r.visit(PelletTestCase.all(p, C));
        String expected = new String("(p only C)");
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testAnd() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = PelletTestCase.term("C");
        ATermAppl D = PelletTestCase.term("D");
        ATermAppl E = PelletTestCase.term("E");
        r.visit(PelletTestCase.and(C, D, E));
        String expected = new String("(C and D and E)");
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testHasValue() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl l = PelletTestCase.literal("foobar");
        ATermAppl p = PelletTestCase.term("p");
        r.visit(PelletTestCase.hasValue(p, l));
        String expected = new String("(p value \"foobar\")");
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testInverse() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl p = PelletTestCase.term("p");
        r.visit(PelletTestCase.inv(p));
        String expected = new String("inverse p");
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testMax() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = PelletTestCase.term("C");
        ATermAppl p = PelletTestCase.term("p");
        r.visit(PelletTestCase.max(p, 3, C));
        String expected = new String("(p max 3 C)");
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testMin() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = PelletTestCase.term("C");
        ATermAppl p = PelletTestCase.term("p");
        r.visit(PelletTestCase.min(p, 3, C));
        String expected = new String("(p min 3 C)");
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testNot() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = PelletTestCase.term("C");
        r.visit(PelletTestCase.not(C));
        String expected = new String("not C");
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testOneOf() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = PelletTestCase.term("C");
        ATermAppl D = PelletTestCase.term("D");
        ATermAppl E = PelletTestCase.term("E");
        r.visit(PelletTestCase.oneOf(C, D, E));
        String expected = new String("{E D C}");
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testOr() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = PelletTestCase.term("C");
        ATermAppl D = PelletTestCase.term("D");
        ATermAppl E = PelletTestCase.term("E");
        r.visit(PelletTestCase.or(C, D, E));
        String expected = new String("(C or D or E)");
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testSelf() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl p = PelletTestCase.term("p");
        r.visit(PelletTestCase.self(p));
        String expected = new String("(p Self)");
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testSome() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = PelletTestCase.term("C");
        ATermAppl p = PelletTestCase.term("p");
        r.visit(PelletTestCase.some(p, C));
        String expected = new String("(p some C)");
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void test1() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = PelletTestCase.term("C");
        ATermAppl D = PelletTestCase.term("D");
        ATermAppl p = PelletTestCase.term("p");
        r.visit(PelletTestCase.and(C, PelletTestCase.some(p, D)));
        String expected = new String("(C and (p some D))");
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

