/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation.test;

import com.clarkparsia.explanation.BlackBoxExplanation;
import com.clarkparsia.explanation.ExplanationGenerator;
import com.clarkparsia.explanation.GlassBoxExplanation;
import com.clarkparsia.explanation.HSTExplanationGenerator;
import com.clarkparsia.explanation.TransactionAwareSingleExpGen;
import com.clarkparsia.explanation.test.ExplanationTester;
import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.owlapi.OntologyUtils;
import com.clarkparsia.owlapi.SWRL;
import com.clarkparsia.owlapi.XSD;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.owlapi.PelletReasonerFactory;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.inference.OWLClassReasoner;
import org.semanticweb.owl.inference.OWLReasonerFactory;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLAtomIVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class SimpleExplanationTest {
    static final String BASEPATH = "file:data/";
    static final OWLOntologyManager manager = OntologyUtils.getOWLOntologyManager();
    static final URI ontologyURI = URI.create("http://www.example.org/test#");
    private Reasoner reasoner;
    private Class<? extends TransactionAwareSingleExpGen> expGenClass;
    private HSTExplanationGenerator hst;
    private ExplanationTester tester;
    private boolean classify;
    private OWLOntology ontology;
    private OWLClass A;
    private OWLClass B;
    private OWLClass C;
    private OWLClass D;
    private OWLClass E;
    private OWLClass F;
    private OWLObjectProperty p;
    private OWLObjectProperty q;
    private OWLDataProperty dp;
    private OWLIndividual a;
    private OWLIndividual b;
    private OWLIndividual c;
    private SWRLAtomIVariable x;
    private SWRLAtomIVariable y;
    private SWRLAtomDVariable dx;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{GlassBoxExplanation.class, false});
        parameters.add(new Object[]{GlassBoxExplanation.class, true});
        parameters.add(new Object[]{BlackBoxExplanation.class, false});
        parameters.add(new Object[]{BlackBoxExplanation.class, true});
        return parameters;
    }

    public SimpleExplanationTest(Class<? extends TransactionAwareSingleExpGen> expGenClass, boolean classify) {
        this.expGenClass = expGenClass;
        this.classify = classify;
    }

    @Before
    public void createEntities() {
        this.A = OWL.Class((String)"A");
        this.B = OWL.Class((String)"B");
        this.C = OWL.Class((String)"C");
        this.D = OWL.Class((String)"D");
        this.E = OWL.Class((String)"E");
        this.F = OWL.Class((String)"F");
        this.p = OWL.ObjectProperty((String)"p");
        this.q = OWL.ObjectProperty((String)"q");
        this.dp = OWL.DataProperty((String)"dp");
        this.a = OWL.Individual((String)"a");
        this.b = OWL.Individual((String)"b");
        this.c = OWL.Individual((String)"c");
        this.x = SWRL.iVariable((String)"x");
        this.y = SWRL.iVariable((String)"y");
        this.dx = SWRL.dVariable((String)"dx");
    }

    public void setupGenerators(Collection<OWLAxiom> ontologyAxioms) throws Exception {
        PelletReasonerFactory pelletFactory = new PelletReasonerFactory();
        this.ontology = manager.createOntology(ontologyURI);
        OntologyUtils.addAxioms((OWLOntology)this.ontology, ontologyAxioms);
        TransactionAwareSingleExpGen singleExpGen = this.expGenClass.getConstructor(OWLOntologyManager.class).newInstance(manager);
        this.reasoner = pelletFactory.createReasoner(manager);
        this.reasoner.loadOntology(this.ontology);
        this.hst = new HSTExplanationGenerator(singleExpGen);
        this.hst.setReasonerFactory((OWLReasonerFactory)pelletFactory);
        this.hst.setReasoner((OWLClassReasoner)this.reasoner);
        this.hst.setOntology(this.ontology);
        if (this.classify) {
            this.reasoner.getKB().setDoExplanation(true);
            this.reasoner.getKB().ensureConsistency();
            this.reasoner.getKB().setDoExplanation(false);
            this.reasoner.classify();
        }
        this.tester = new ExplanationTester((ExplanationGenerator)this.hst);
    }

    @After
    public void after() throws OWLOntologyCreationException {
        manager.removeOntology(ontologyURI);
        this.hst = null;
        this.tester = null;
    }

    @Test
    public void annotationOnlyEntity() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)OWL.Thing), OWL.comment((OWLEntity)this.B, (String)"Annotation only class")};
        this.setupGenerators(Arrays.asList(axioms));
        this.tester.testExplanations((OWLAxiom)OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.A), 0, new OWLAxiom[][]{{axioms[0]}});
    }

    @Test
    public void annotationOnlyDuringMUPSEntity() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.A), OWL.comment((OWLEntity)this.B, (String)"Annotation only class")};
        this.setupGenerators(Arrays.asList(axioms));
        this.tester.testExplanations((OWLAxiom)OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.A), 0, new OWLAxiom[][]{{axioms[1]}});
    }

    @Test
    public void declarationOnlyEntity() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)OWL.Thing), OWL.declaration((OWLEntity)this.B)};
        this.setupGenerators(Arrays.asList(axioms));
        this.tester.testExplanations((OWLAxiom)OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.A), 0, new OWLAxiom[][]{{axioms[0]}});
    }

    @Test
    public void declarationOnlyIrrelevantEntity() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.A), OWL.declaration((OWLEntity)this.p)};
        this.setupGenerators(Arrays.asList(axioms));
        this.tester.testExplanations((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.and((OWLDescription[])new OWLDescription[]{this.B, OWL.some((OWLObjectPropertyExpression)this.p, (OWLDescription)OWL.Thing)}), (OWLDescription)this.A), 0, new OWLAxiom[][]{{axioms[0]}});
    }

    @Test
    public void disjointRange() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.some((OWLObjectPropertyExpression)this.p, (OWLDescription)this.B)), OWL.range((OWLObjectPropertyExpression)this.p, (OWLDescription)this.C), OWL.disjointClasses((OWLDescription)this.B, (OWLDescription)this.C)};
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)OWL.Nothing);
        OWLAxiom[] explanation = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.some((OWLObjectPropertyExpression)this.p, (OWLDescription)this.B)), OWL.range((OWLObjectPropertyExpression)this.p, (OWLDescription)this.C), OWL.disjointClasses((OWLDescription)this.B, (OWLDescription)this.C)};
        this.setupGenerators(Arrays.asList(axioms));
        this.tester.testExplanations((OWLAxiom)axiom, 0, new OWLAxiom[][]{explanation});
    }

    @Test
    public void disjointRangeSuper() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.some((OWLObjectPropertyExpression)this.p, (OWLDescription)this.B)), OWL.range((OWLObjectPropertyExpression)this.p, (OWLDescription)this.C), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.D), OWL.disjointClasses((OWLDescription)this.D, (OWLDescription)this.C), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.E), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.F)};
        this.setupGenerators(Arrays.asList(axioms));
        this.tester.testExplanations((OWLAxiom)OWL.disjointClasses((OWLDescription)this.B, (OWLDescription)this.C), 0, new OWLAxiom[][]{{axioms[2], axioms[3]}});
        this.tester.testExplanations((OWLAxiom)OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)OWL.Nothing), 0, new OWLAxiom[][]{{axioms[0], axioms[1], axioms[2], axioms[3]}});
    }

    @Test
    public void disjointSupers() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.C), OWL.disjointClasses((OWLDescription)this.B, (OWLDescription)this.C)};
        this.setupGenerators(Arrays.asList(axioms));
        this.tester.testExplanations((OWLAxiom)OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)OWL.Nothing), 0, new OWLAxiom[][]{axioms});
    }

    @Test
    public void multipleEquivalentClasses() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)this.C), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.D), OWL.subClassOf((OWLDescription)this.D, (OWLDescription)this.E), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.E), OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.all((OWLObjectPropertyExpression)this.p, (OWLDescription)this.A))};
        this.setupGenerators(Arrays.asList(axioms));
        this.tester.testExplanations((OWLAxiom)OWL.subClassOf((OWLDescription)this.C, (OWLDescription)this.D), 0, new OWLAxiom[][]{{axioms[0], axioms[1]}});
        this.tester.testExplanations((OWLAxiom)OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.D), 0, new OWLAxiom[][]{{axioms[1]}});
        this.tester.testExplanations((OWLAxiom)OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.D), 0, new OWLAxiom[][]{{axioms[1], axioms[4]}});
    }

    @Test
    public void ruleTest1() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), OWL.classAssertion((OWLIndividual)this.b, (OWLDescription)this.B), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.A, (SWRLAtomIObject)this.x)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.x)})), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.x), SWRL.propertyAtom((OWLObjectPropertyExpression)this.p, (SWRLAtomIObject)this.x, (SWRLAtomIObject)this.y), SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.y)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.C, (SWRLAtomIObject)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.tester.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), 0, new OWLAxiom[][]{{axioms[0]}});
        this.tester.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.B), 0, new OWLAxiom[][]{{axioms[0], axioms[3]}});
        this.tester.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.C), 1, new OWLAxiom[][]{axioms});
    }

    @Test
    public void ruleTest2() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subPropertyOf((OWLObjectPropertyExpression)this.q, (OWLObjectPropertyExpression)this.p), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.q, (OWLIndividual)this.b), OWL.classAssertion((OWLIndividual)this.b, (OWLDescription)this.B), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.propertyAtom((OWLObjectPropertyExpression)this.p, (SWRLAtomIObject)this.x, (SWRLAtomIObject)this.y), SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.y)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.A, (SWRLAtomIObject)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.tester.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), 1, new OWLAxiom[][]{axioms});
    }

    @Test
    public void ruleTest3() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.inverseProperties((OWLObjectPropertyExpression)this.q, (OWLObjectPropertyExpression)this.p), OWL.propertyAssertion((OWLIndividual)this.b, (OWLObjectPropertyExpression)this.q, (OWLIndividual)this.a), OWL.classAssertion((OWLIndividual)this.b, (OWLDescription)this.B), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.propertyAtom((OWLObjectPropertyExpression)this.p, (SWRLAtomIObject)this.x, (SWRLAtomIObject)this.y), SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.y)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.A, (SWRLAtomIObject)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.tester.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), 1, new OWLAxiom[][]{axioms});
    }

    @Test
    public void ruleBuiltinTest1() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLConstant)OWL.constant((int)9)), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.A, (SWRLAtomIObject)this.x), SWRL.propertyAtom((OWLDataPropertyExpression)this.dp, (SWRLAtomIObject)this.x, (SWRLAtomDObject)this.dx), SWRL.lessThan((SWRLAtomDObject)this.dx, (SWRLAtomDObject)SWRL.constant((int)10))}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.tester.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.B), 0, new OWLAxiom[][]{axioms});
    }

    @Test
    public void ruleBuiltinTest2() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLConstant)OWL.constant((int)9)), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.A, (SWRLAtomIObject)this.x), SWRL.propertyAtom((OWLDataPropertyExpression)this.dp, (SWRLAtomIObject)this.x, (SWRLAtomDObject)this.dx), SWRL.greaterThan((SWRLAtomDObject)this.dx, (SWRLAtomDObject)SWRL.constant((int)5)), SWRL.lessThan((SWRLAtomDObject)this.dx, (SWRLAtomDObject)SWRL.constant((int)10))}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.tester.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.B), 0, new OWLAxiom[][]{axioms});
    }

    @Test
    public void userDefinedDatatype1() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLConstant)OWL.constant((int)9)), OWL.equivalentClasses((OWLDescription)this.B, (OWLDescription)OWL.and((OWLDescription[])new OWLDescription[]{this.A, OWL.some((OWLDataPropertyExpression)this.dp, (OWLDataRange)OWL.restrict((OWLDataType)XSD.INTEGER, (OWLDataRangeFacetRestriction[])new OWLDataRangeFacetRestriction[]{OWL.maxExclusive((int)10)}))}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.tester.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.B), 0, new OWLAxiom[][]{axioms});
    }

    @Test
    public void userDefinedDatatype2() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.and((OWLDescription[])new OWLDescription[]{OWL.max((OWLDataPropertyExpression)this.dp, (int)1), OWL.some((OWLDataPropertyExpression)this.dp, (OWLDataRange)OWL.restrict((OWLDataType)XSD.INTEGER, (OWLDataRangeFacetRestriction[])new OWLDataRangeFacetRestriction[]{OWL.minExclusive((int)10)}))})), OWL.equivalentClasses((OWLDescription)this.B, (OWLDescription)OWL.and((OWLDescription[])new OWLDescription[]{OWL.min((OWLDataPropertyExpression)this.dp, (int)1), OWL.all((OWLDataPropertyExpression)this.dp, (OWLDataRange)OWL.restrict((OWLDataType)XSD.INTEGER, (OWLDataRangeFacetRestriction[])new OWLDataRangeFacetRestriction[]{OWL.minExclusive((int)5)}))}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.tester.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.B), 0, new OWLAxiom[][]{axioms});
    }

    @Test
    public void transitiveProperty() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.transitive((OWLObjectPropertyExpression)this.p), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), OWL.propertyAssertion((OWLIndividual)this.b, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.c), OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)OWL.hasValue((OWLObjectPropertyExpression)this.p, (OWLIndividual)this.c))};
        this.setupGenerators(Arrays.asList(axioms));
        this.tester.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.b, (OWLDescription)this.A), 0, new OWLAxiom[][]{{axioms[2], axioms[3]}});
        this.tester.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), 0, new OWLAxiom[][]{axioms});
    }

    public static void main(String[] args) throws Exception {
        GlassBoxExplanation.log.setLevel(Level.FINER);
        ABox.log.setLevel(Level.FINER);
        SimpleExplanationTest test = new SimpleExplanationTest(GlassBoxExplanation.class, true);
        test.createEntities();
        test.transitiveProperty();
    }
}

