/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.test.AbstractModularityTest;
import com.clarkparsia.modularity.test.TestUtils;
import com.clarkparsia.owlapi.OntologyUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.junit.Ignore;
import org.junit.Test;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;

public abstract class RandomizedIncrementalClassifierTest
extends AbstractModularityTest {
    private String path;

    public RandomizedIncrementalClassifierTest(String path) {
        this.path = path;
        if (!new File(path).exists()) {
            throw new RuntimeException("Path to data files is not correct: " + path);
        }
    }

    private void classifyCorrectnessTest(String file) throws OWLException {
        OWLOntology ontology = OntologyUtils.loadOntology((String)("file:" + file), (boolean)false);
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>(TestUtils.selectRandomAxioms(ontology, 10));
        OntologyUtils.removeAxioms((OWLOntology)ontology, axioms.subList(0, 5));
        List<OWLAxiom> additions = axioms.subList(0, 5);
        List<OWLAxiom> deletions = axioms.subList(5, 10);
        try {
            TestUtils.runUpdateTest(ontology, this.modExtractor, additions, deletions);
        }
        catch (AssertionError e) {
            System.err.println("Additions: " + additions);
            System.err.println("Deletions: " + deletions);
            throw e;
        }
        catch (RuntimeException e) {
            System.err.println("Additions: " + additions);
            System.err.println("Deletions: " + deletions);
            throw e;
        }
    }

    @Test
    @Ignore(value="Known to trigger bug in Pellet, see http://cvsdude.com/trac/clark-parsia/pellet-devel/ticket/106")
    public void galenClassifyTest() throws OWLException {
        this.classifyCorrectnessTest(this.path + "galen.owl");
    }

    @Test
    public void koalaClassifyTest() throws OWLException {
        this.classifyCorrectnessTest(this.path + "koala.owl");
    }

    @Test
    public void sumoClassifyTest() throws OWLException {
        this.classifyCorrectnessTest(this.path + "SUMO.owl");
    }

    @Test
    public void sweetClassifyTest() throws OWLException {
        this.classifyCorrectnessTest(this.path + "SWEET.owl");
    }

    @Test
    @Ignore(value="Known to non-deterministically fail")
    public void wineClassifyTest() throws OWLException {
        this.classifyCorrectnessTest(this.path + "wine.owl");
    }
}

