/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.locality.LocalityClass;
import com.clarkparsia.modularity.locality.SyntacticLocalityEvaluator;
import com.clarkparsia.modularity.test.TestUtils;
import com.clarkparsia.owlapi.OWL;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;

public class SyntacticTopLocalityTests {
    private SyntacticLocalityEvaluator evaluator = new SyntacticLocalityEvaluator(LocalityClass.TOP_BOTTOM);

    private void assertLocal(OWLAxiom a, OWLEntity ... signature) {
        Assert.assertTrue((boolean)this.evaluator.isLocal(a, TestUtils.set(signature)));
    }

    private void assertNonLocal(OWLAxiom a, OWLEntity ... signature) {
        Assert.assertFalse((boolean)this.evaluator.isLocal(a, TestUtils.set(signature)));
    }

    @Test
    public void objectComplementSubCls() {
        this.assertLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.not((OWLDescription)OWL.Thing), (OWLDescription)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A")});
        this.assertLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.not((OWLDescription)OWL.Class((String)"B")), (OWLDescription)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.not((OWLDescription)OWL.Class((String)"B")), (OWLDescription)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A"), OWL.Class((String)"B")});
    }

    @Test
    public void objectExistentialFillerSuperCls() {
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.Class((String)"A"), (OWLDescription)OWL.some((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (OWLDescription)OWL.Class((String)"B"))), new OWLEntity[]{OWL.Class((String)"A")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.Class((String)"A"), (OWLDescription)OWL.some((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (OWLDescription)OWL.Class((String)"B"))), new OWLEntity[]{OWL.Class((String)"A"), OWL.ObjectProperty((String)"p")});
    }

    @Test
    public void objectMaxSubCls() {
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.max((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (int)2, (OWLDescription)OWL.Thing), (OWLDescription)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.max((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (int)2, (OWLDescription)OWL.Thing), (OWLDescription)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A"), OWL.ObjectProperty((String)"p")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.max((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (int)2, (OWLDescription)OWL.Nothing), (OWLDescription)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.max((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (int)2, (OWLDescription)OWL.Nothing), (OWLDescription)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A"), OWL.ObjectProperty((String)"p")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.max((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (int)2, (OWLDescription)OWL.Class((String)"B")), (OWLDescription)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.max((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (int)2, (OWLDescription)OWL.Class((String)"B")), (OWLDescription)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A"), OWL.ObjectProperty((String)"p")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.max((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (int)2, (OWLDescription)OWL.Class((String)"B")), (OWLDescription)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A"), OWL.ObjectProperty((String)"p"), OWL.Class((String)"B")});
    }

    @Test
    public void objectSuperCls() {
        this.assertLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.Class((String)"A"), (OWLDescription)OWL.Class((String)"B")), new OWLEntity[]{OWL.Class((String)"A")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.Class((String)"A"), (OWLDescription)OWL.Class((String)"B")), new OWLEntity[]{OWL.Class((String)"B")});
    }

    @Test
    public void objectUniversalSubCls() {
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.all((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (OWLDescription)OWL.Class((String)"B")), (OWLDescription)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.all((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (OWLDescription)OWL.Class((String)"B")), (OWLDescription)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A"), OWL.Class((String)"B")});
        this.assertNonLocal((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.all((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (OWLDescription)OWL.Class((String)"B")), (OWLDescription)OWL.Class((String)"A")), new OWLEntity[]{OWL.Class((String)"A"), OWL.ObjectProperty((String)"p")});
    }
}

