/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.owlapi;

import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.owlapi.OntologyUtils;
import com.clarkparsia.owlapi.XSD;
import java.util.Arrays;
import junit.framework.JUnit4TestAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.owlapi.PelletLoader;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.RemoveAxiom;

public class LoaderTests {
    private boolean oldTracing;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(LoaderTests.class);
    }

    @Before
    public void enableTracing() {
        this.oldTracing = PelletOptions.USE_TRACING;
        PelletOptions.USE_TRACING = true;
    }

    @After
    public void resetTracing() {
        PelletOptions.USE_TRACING = this.oldTracing;
    }

    @Test
    public void removeDataPropertyDomainAxiom() {
        OWLOntology ont = OntologyUtils.getOntologyFromAxioms((OWLAxiom[])new OWLAxiom[]{OWL.declaration((OWLEntity)OWL.DataProperty((String)"p")), OWL.declaration((OWLEntity)OWL.Class((String)"C")), OWL.domain((OWLDataPropertyExpression)OWL.DataProperty((String)"p"), (OWLDescription)OWL.Class((String)"C")), OWL.propertyAssertion((OWLIndividual)OWL.Individual((String)"a"), (OWLDataPropertyExpression)OWL.DataProperty((String)"p"), (OWLConstant)OWL.constant((String)"foo"))});
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.loadOntology(ont);
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertTrue((boolean)reasoner.hasType(OWL.Individual((String)"a"), (OWLDescription)OWL.Class((String)"C")));
        PelletLoader loader = reasoner.getLoader();
        boolean changeApplied = loader.applyChanges(Arrays.asList(new RemoveAxiom(ont, (OWLAxiom)OWL.domain((OWLDataPropertyExpression)OWL.DataProperty((String)"p"), (OWLDescription)OWL.Class((String)"C")))));
        Assert.assertTrue((String)"Unable to remove data property domain axiom", (boolean)changeApplied);
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertFalse((boolean)reasoner.hasType(OWL.Individual((String)"a"), (OWLDescription)OWL.Class((String)"C")));
    }

    @Test
    public void removeDataPropertyRangeAxiom() {
        OWLOntology ont = OntologyUtils.getOntologyFromAxioms((OWLAxiom[])new OWLAxiom[]{OWL.declaration((OWLEntity)OWL.DataProperty((String)"p")), OWL.declaration((OWLEntity)OWL.Class((String)"C")), OWL.range((OWLDataPropertyExpression)OWL.DataProperty((String)"p"), (OWLDataRange)XSD.INTEGER), OWL.propertyAssertion((OWLIndividual)OWL.Individual((String)"a"), (OWLDataPropertyExpression)OWL.DataProperty((String)"p"), (OWLConstant)OWL.constant((String)"foo"))});
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.loadOntology(ont);
        Assert.assertFalse((boolean)reasoner.isConsistent());
        PelletLoader loader = reasoner.getLoader();
        boolean changeApplied = loader.applyChanges(Arrays.asList(new RemoveAxiom(ont, (OWLAxiom)OWL.range((OWLDataPropertyExpression)OWL.DataProperty((String)"p"), (OWLDataRange)XSD.INTEGER))));
        Assert.assertTrue((String)"Unable to remove data property range axiom", (boolean)changeApplied);
        Assert.assertTrue((boolean)reasoner.isConsistent());
    }

    @Test
    public void removeObjectPropertyDomainAxiom() {
        OWLOntology ont = OntologyUtils.getOntologyFromAxioms((OWLAxiom[])new OWLAxiom[]{OWL.declaration((OWLEntity)OWL.ObjectProperty((String)"p")), OWL.declaration((OWLEntity)OWL.Class((String)"C")), OWL.domain((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (OWLDescription)OWL.Class((String)"C")), OWL.propertyAssertion((OWLIndividual)OWL.Individual((String)"a"), (OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (OWLIndividual)OWL.Individual((String)"b"))});
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.loadOntology(ont);
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertTrue((boolean)reasoner.hasType(OWL.Individual((String)"a"), (OWLDescription)OWL.Class((String)"C")));
        PelletLoader loader = reasoner.getLoader();
        boolean changeApplied = loader.applyChanges(Arrays.asList(new RemoveAxiom(ont, (OWLAxiom)OWL.domain((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (OWLDescription)OWL.Class((String)"C")))));
        Assert.assertTrue((String)"Unable to remove object property domain axiom", (boolean)changeApplied);
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertFalse((boolean)reasoner.hasType(OWL.Individual((String)"a"), (OWLDescription)OWL.Class((String)"C")));
    }

    @Test
    public void removeObjectPropertyRangeAxiom() {
        OWLOntology ont = OntologyUtils.getOntologyFromAxioms((OWLAxiom[])new OWLAxiom[]{OWL.declaration((OWLEntity)OWL.ObjectProperty((String)"p")), OWL.declaration((OWLEntity)OWL.Class((String)"C")), OWL.range((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (OWLDescription)OWL.Class((String)"C")), OWL.propertyAssertion((OWLIndividual)OWL.Individual((String)"a"), (OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (OWLIndividual)OWL.Individual((String)"b"))});
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.loadOntology(ont);
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertTrue((boolean)reasoner.hasType(OWL.Individual((String)"b"), (OWLDescription)OWL.Class((String)"C")));
        PelletLoader loader = reasoner.getLoader();
        boolean changeApplied = loader.applyChanges(Arrays.asList(new RemoveAxiom(ont, (OWLAxiom)OWL.range((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (OWLDescription)OWL.Class((String)"C")))));
        Assert.assertTrue((String)"Unable to remove object property range axiom", (boolean)changeApplied);
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertFalse((boolean)reasoner.hasType(OWL.Individual((String)"b"), (OWLDescription)OWL.Class((String)"C")));
    }

    @Before
    @After
    public void resetOntologyManager() {
        for (OWLOntology o : OWL.manager.getOntologies()) {
            OWL.manager.removeOntology(o.getURI());
        }
    }
}

